package com.ptteng.controller;

import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.model.Constants;
import com.ptteng.util.Calculation;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.util.userNameUtil;
import com.ptteng.yi.nucleus.model.*;
import com.ptteng.yi.nucleus.service.*;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.service.ImAccountService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.sun.javafx.animation.TickCalculation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * Students  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class StudentsController {
	private static final Log log = LogFactory.getLog(StudentsController.class);

	@Autowired
	private StudentsService studentsService;
	@Autowired
	private CoachService coachService;
	@Autowired
	private SchoolService schoolService;
	@Autowired
	private SchoolVenuesRelationService schoolVenuesRelationService;
	@Autowired
	private DrivingClassService drivingClassService;
	@Autowired
	private FreezeUserService freezeUserService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private ProbationService probationService;
	@Autowired
	private TestRecordsService testRecordsService;
	@Autowired
	private SubjectExamService subjectExamService;
	@Autowired
	private CoachRecommendService coachRecommendService;
	@Autowired
	ImAccountService imAccountService;
	@Autowired
	ImChatUtil imChatUtil;

	/**
	 * 学员列表
	 * @param request
	 * @param response
	 * @param model
	 * @param students
	 * @param channel
	 * @param page
	 * @param size
	 * @param status
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/student/list ", method = RequestMethod.GET)
	public String getStudentsList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String name,String nick,Long cityId,Long schoolId,Long classId,String mobile, Integer channel, Integer page, Integer size,
			Integer progress,String identification,Integer status) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);
		log.info(" name is " + name+" nick is " + nick+" cityId is " + cityId+" schoolId is " + schoolId+" classId is " + classId+" mobile is " + mobile
		+" progress is " + progress+" identification is " + identification);
		try {
			Integer certification = null;
			if (DataUtils.isNotNullOrEmpty(schoolId)) {
				certification = Coach.CERTIFICATION_ON;
			}
			Map<String, Object> map = DynamicUtil.getStudentListParams(name, nick,
					cityId, schoolId, classId, mobile,
					progress, identification, channel, certification, status);
			log.info("map is "+map);
			List<Long> ids = studentsService.getIdsByDynamicCondition(Students.class, map, start, size);
			log.info("ids is "+ids);
			List<Long> totalIds = studentsService.getIdsByDynamicCondition(Students.class, map, 0, Integer.MAX_VALUE);
			log.info("get countstudentIdsByStatusOrderByCreateBy size is " + ids.size());

			List<Students> studentsList = studentsService.getObjectsByIds(ids);
			log.info("get students data is " + studentsList.size());

			Integer total = totalIds.size();
			log.info("get students count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("studentsList", studentsList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get students list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/students/json/studentsListJson";
	}

	/**
	 * 查看学员详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/students/{id}", method = RequestMethod.GET)
	public String getStudentsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Students students = studentsService.getObjectById(id);
			log.info("get students data is " + students);

			model.addAttribute("code", 0);

			model.addAttribute("students", students);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get students error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/students/json/studentsDetailJson";
	}

	/**
	 * 修改学生信息
	 * @param request
	 * @param response
	 * @param model
	 * @param students
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/students/{id}", method = RequestMethod.PUT)
	public String updateStudentsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Students students, @PathVariable Long id) throws Exception {

		log.info("update students : students= " + students);

		try {
			Students studentsDetail = studentsService.getObjectById(id);
			if (DataUtils.isNotNullOrEmpty(students.getTrainingVenues())) {
				studentsDetail.setTrainingVenues(students.getTrainingVenues());
				log.info(" getTrainingVenues update");
			}
			if (DataUtils.isNotNullOrEmpty(students.getClassId())) {
				DrivingClass drivingClass = drivingClassService.getObjectById(students.getClassId());
				studentsDetail.setClassId(students.getClassId());
				studentsDetail.setClassName(drivingClass.getName());
				log.info(" getClassId update");
			}
			if (DataUtils.isNotNullOrEmpty(students.getSectionTwoDenominator())) {
				BigDecimal f1=null;
				BigDecimal f2=null;
				if(DataUtils.isNullOrEmpty(students.getSectionTwoDenominator())){
					f1 = new BigDecimal(0);
				}else {
					f1 = new BigDecimal(students.getSectionTwoDenominator());
				}
				if(DataUtils.isNullOrEmpty(studentsDetail.getSectionTwoNumerator())){
					f2 = new BigDecimal(0);
				}else {
					f2 = new BigDecimal(studentsDetail.getSectionTwoNumerator());
				}
				double f3 = Calculation.sub(f1.doubleValue(), f2.doubleValue());
				if (f3 >= 0) {
					studentsDetail.setSectionTwoDenominator(students.getSectionTwoDenominator());
					log.info(" getSectionTwoDenominator update");
				} else {
					log.error("getSectionTwoDenominator  update  error  ");
					model.addAttribute("code", -22000);
					return "/common/failure";
				}
			}
			if (DataUtils.isNotNullOrEmpty(students.getSectionThreeDenominator())) {
				BigDecimal f1=null;
				BigDecimal f2=null;
				if(DataUtils.isNullOrEmpty(students.getSectionThreeDenominator())){
					f1 = new BigDecimal(0);
				}else {
					f1 = new BigDecimal(students.getSectionThreeDenominator());
				}
				if(DataUtils.isNullOrEmpty(studentsDetail.getSectionThreeNumerator())){
					f2 = new BigDecimal(0);
				}else {
					f2 = new BigDecimal(studentsDetail.getSectionThreeNumerator());
				}
				double f3 = Calculation.sub(f1.doubleValue(), f2.doubleValue());
				if (f3 >= 0) {
					studentsDetail.setSectionThreeDenominator(students.getSectionThreeDenominator());
					log.info(" getSectionThreeDenominator update");
				} else {
					log.error("getSectionThreeDenominator  update  error  ");
					model.addAttribute("code", -22001);
					return "/common/failure";
				}
			}
			if (DataUtils.isNotNullOrEmpty(students.getSectionTwoCoachId())) {
				Coach coach = coachService.getObjectById(Long.valueOf(students.getSectionTwoCoachId()));
				studentsDetail.setSectionTwoCoach(coach.getName());
				studentsDetail.setSectionTwoCoachId(students.getSectionTwoCoachId());
				log.info(" getSectionTwoCoach update");

			}
			if (DataUtils.isNotNullOrEmpty(students.getSectionThreeCoachId())) {
				Coach coach = coachService.getObjectById(Long.valueOf(students.getSectionThreeCoachId()));
				studentsDetail.setSectionThreeCoach(coach.getName());
				studentsDetail.setSectionThreeCoachId(students.getSectionThreeCoachId());
				log.info(" getSectionThreeCoach update");

			}
			if (DataUtils.isNotNullOrEmpty(students.getResidualNum())) {
				studentsDetail.setResidualNum(students.getResidualNum());
				log.info(" getResidualNum update");
			}
			if (DataUtils.isNotNullOrEmpty(students.getDistributionType())) {
				studentsDetail.setDistributionType(students.getDistributionType());
				log.info(" getTrainingVenues update");
			}

			log.info("studentsDetail is " + studentsDetail);
			studentsService.update(studentsDetail);
			log.info("students  update");

			model.addAttribute("code", 0);

			model.addAttribute("students", students);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update students error,id is  " + students.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	/**
	 * 新增学员
	 * @param request
	 * @param response
	 * @param model
	 * @param students
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/students", method = RequestMethod.POST)
	public String addStudentsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Students students) throws Exception {

		log.info("update students : students= " + students);

		Long id = null;
		Long imAccountId = null;
		if (DataUtils.isNullOrEmpty(students.getName())) {
			model.addAttribute("code", -22005);
			log.info("parameter schools getName is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(students.getMobile())) {
			model.addAttribute("code", -22006);
			log.info("parameter schools getMobile is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(students.getIdentification())) {
			model.addAttribute("code", -22008);
			log.info("parameter schools getIdentification is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(students.getSex())) {
			model.addAttribute("code", -22009);
			log.info("parameter schools getSex is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(students.getSchoolId())) {
			model.addAttribute("code", -22010);
			log.info("parameter schools getSchoolId is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(students.getClassId())) {
			model.addAttribute("code", -22011);
			log.info("parameter schools getClassId is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(students.getPwd())) {
			model.addAttribute("code", -22007);
			log.info("parameter schools getPwd is null or empty");
			return "/common/failure";
		} else {
			String encodePass = PasswordUtils.encode(students.getPwd());
			students.setPwd(encodePass);
		}
		try {
			Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
			students.setId(null);

			Map<String, Object> mapP =  DynamicUtil.getStudentListParams(null, null, null, null, null, students.getMobile(), null, null,
					null, null, null);
			log.info("mapP is "+mapP);
			List<Long> mobile = studentsService.getIdsByDynamicCondition(Coach.class, mapP, 0, Integer.MAX_VALUE);
			if (mobile.size() > 0) {
				model.addAttribute("code", -23013);
				log.info("parameter schools is null or empty");
				return "/common/failure";
			}


			School school = schoolService.getObjectById(students.getSchoolId());
			log.info("school ======" + school);
			if (DataUtils.isNotNullOrEmpty(school)) {
				students.setSchool(school.getName());
			} else {
				model.addAttribute("code", -22004);
				log.info("search school error");
				return "/common/failure";
			}
			userNameUtil userNameUtill = new userNameUtil();
			students.setNick("易-" + userNameUtill.getRandomName());
			DrivingClass drivingClass = drivingClassService.getObjectById(students.getClassId());
			log.info("drivingClass ======" + drivingClass);
			if (DataUtils.isNotNullOrEmpty(drivingClass)) {
				students.setClassName(drivingClass.getName());
			} else {
				model.addAttribute("code", -22002);
				log.info("search drivingClass error");
				return "/common/failure";
			}
			List<Long> ids = schoolVenuesRelationService
					.getSchoolVenuesRelationIdsBySchoolIdOrderByCreateBy(students.getSchoolId(), 0, Integer.MAX_VALUE);
			log.info("schoolVenuesRelation  ids ======" + ids);
			if (CollectionUtils.isNotEmpty(ids)) {
				SchoolVenuesRelation schoolVenuesRelation = schoolVenuesRelationService.getObjectById(ids.get(0));
				students.setTrainingVenues(schoolVenuesRelation.getVenueName());
			} else {
				model.addAttribute("code", -22003);
				log.info("search schoolVenuesRelation error");
				return "/common/failure";
			}

			students.setCertification(1);
			students.setCreateBy(mid);
			students.setUpdateBy(mid);
			students.setId(null);
			students.setStatus(Students.STATUS_ON);
			Long time = System.currentTimeMillis();
			students.setRegistrationDate(time);
			id = studentsService.insert(students);

			//创建网易云Im即时通讯账号
			if (null != id) {
				String accid = imChatUtil.getAccid(id, ImChatUtil.AccidType.STUDENT);
				String accidToken = null;
				String code = null;
				String message = null;
				Map<String, String> result = imChatUtil.createImAccount(accid);
				log.info("result is=="
						+ (null != result && 0 != result.size() ? Arrays.asList(result) : " null or size is zero"));

				code = result.get("code");
				if (code.equals("200")) {
					log.info("create im account success");
					accidToken = result.get("token");
					accid = result.get("accid");
					ImAccount imAccount = new ImAccount();
					imAccount.setAccount(accid);
					imAccount.setBelongId(id);
					imAccount.setBelongtType(0);
					imAccount.setToken(accidToken);
					imAccount.setCreateAt(System.currentTimeMillis());
					imAccount.setCreateBy(mid);
					imAccount.setUpdateAt(System.currentTimeMillis());
					imAccount.setUpdateBy(mid);

					imAccountId = imAccountService.insert(imAccount);
					log.info("create im account success,insert to DB success");

					boolean success = imChatUtil.updateStudentInfo(accid, students);
					if (success)
						log.info("update student info success");
					else
						log.info("update student info failed");

				} else {
					message = result.get("message");
					log.info("create im account failed,see==" + message);
					studentsService.delete(id);
					throw new Exception("register failed,cause create im account failed");
				}
			}

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add students error ");
			if (null != t.getMessage() && t.getMessage().equals("register failed,cause create im account failed")) {
				model.addAttribute("code", -26000);
			} else {
				model.addAttribute("code", -6002);
			}

			if (null != imAccountId)
				imAccountService.delete(imAccountId);

			if (null != id)
				studentsService.delete(id);
		}

		return "/data/json";
	}

	/**
	 * 删除学员
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/students/{id}", method = RequestMethod.DELETE)
	public String deleteStudentsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete students : id= " + id);
		try {
			studentsService.delete(id);

			log.info("add students success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete students error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/multi/students", method = RequestMethod.GET)
	public String getMultiStudentsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Students> studentsList = studentsService.getObjectsByIds(idList);
			log.info("get  students data is " + studentsList);

			model.addAttribute("code", 0);
			model.addAttribute("total", studentsList.size());

			model.addAttribute("studentsList", studentsList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get students error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/students/json/studentsListJson";
	}

	/**
	 * 线索管理 */

	@RequestMapping(value = "/a/u/clue/list", method = RequestMethod.GET)
	public String getMultiClueJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String name, String mobile, String os, Long submitStart, Long submitEnd, Integer page, Integer size,
			Long cityId) throws Exception {

		log.info("GET request url: /a/u/clue/list, get parameter name: " + name + ", mobile: " + mobile + ", os:" + os
				+ ", submitStart: " + submitStart + ", submitEnd: " + submitEnd + ", page: " + page + ", size: "
				+ size);

		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		if (DataUtils.isNullOrEmpty(cityId)) {
			model.addAttribute("code", -5022);
			log.info("search drivingClass error");
			return "/common/failure";
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> map = DynamicUtil.getStudentClueListParams(name, mobile, os, submitStart, submitEnd,
					cityId);
			log.info("get query student clue map: " + map);

			List<Long> ids = probationService.getIdsByDynamicCondition(Probation.class, map, start, size);
			log.info("get student clue ids size is " + ids.size());

			List<Probation> clueList = probationService.getObjectsByIds(ids);
			log.info("get student clue list size is " + clueList.size());

			Integer total = probationService.getIdsByDynamicCondition(Students.class, map, 0, Integer.MAX_VALUE).size();
			log.info("get students clue total is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("studentsList", clueList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get students list error,page is  " + page + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/students/json/clueListJson";
	}

	/**
	 * 冻结
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param type
	 * @param status
	 * @param uid
	 * @return
	 */
	@RequestMapping(value = "/a/u/status", method = RequestMethod.POST)
	public String freezeStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model, int type,
			int status, Long uid, Long thawtime, Integer page, Integer size) {
		log.info("  begin /a/u/status ");
		log.info("get data : type = " + type + " , status = " + status + " , uid = " + uid + " , thawtime = "
				+ thawtime);

		if (DataUtils.isNullOrEmpty(status) || status == 1) {
			model.addAttribute("code", -5024);
			log.info("unfreeze user  error");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(uid)) {
			model.addAttribute("code", -5013);
			log.info("unfreeze user  error");
			return "/common/failure";

		}

		if (DataUtils.isNullOrEmpty(thawtime)) {
			model.addAttribute("code", -5026);
			log.info("unfreeze user  error");
			return "/common/failure";
		}
		FreezeUser freezeUser = new FreezeUser();

		try {
			Map<String, Object> map = new HashMap<>();
			switch (type) {
			case Constants.stuUser:
				Students students = studentsService.getObjectById(uid);
				students.setStatus(status);
				//					Long targetId = freezeUserService.getFreezeUserIds(uid);
				log.info("students is " + students);

				map = DynamicUtil.getFreezeUserListParams(uid, type);

				List<Long> ids = freezeUserService.getIdsByDynamicCondition(FreezeUser.class, map, 0,
						Integer.MAX_VALUE);
				int idsContent = ids.size();
				log.info("ids is " + idsContent);
				if (0 == idsContent) {
					freezeUser.setName(students.getName());
					freezeUser.setUid(uid);
					freezeUser.setType(type);
					freezeUser.setThawTime(thawtime);
					freezeUser.setStatus(FreezeUser.STATUS_FREEZE);
					studentsService.update(students);
					freezeUserService.insert(freezeUser);
				} else if (1 == ids.size()) {
					freezeUser = freezeUserService.getObjectById(ids.get(0));
					freezeUser.setName(students.getName());
					freezeUser.setUid(uid);
					freezeUser.setType(type);
					freezeUser.setThawTime(thawtime);
					freezeUser.setStatus(FreezeUser.STATUS_FREEZE);
					studentsService.update(students);
					freezeUserService.update(freezeUser);
				}
				log.info("freezeUser is " + freezeUser);
				break;
			default:

			}
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("manager logout error  ");
			model.addAttribute("code", -5005);
			model.addAttribute("result", null);
		}

		return "common/success";
	}

	/**
	 * 解冻
	 * @param request
	 * @param response
	 * @param model
	 * @param type
	 * @param status
	 * @param uid
	 * @return
	 */
	@RequestMapping(value = "/a/u/status", method = RequestMethod.PUT)
	public String unfreezeStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model, int type,
			int status, Long uid) {
		log.info(" unfreezeStatus begin /a/u/status ");
		log.info("get data : type = " + type + " , status = " + status + " , uid = " + uid);

		if (DataUtils.isNullOrEmpty(status) || 0 == status) {
			model.addAttribute("code", -5024);
			log.info("unfreeze user  error");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(uid)) {
			model.addAttribute("code", -5013);
			log.info("unfreeze user  error");
			return "/common/failure";

		}
		FreezeUser freezeUser = new FreezeUser();

		try {
			Map<String, Object> map = new HashMap<>();
			switch (type) {
			case Constants.stuUser:
				Students students = studentsService.getObjectById(uid);
				students.setStatus(status);
				//					Long targetId = freezeUserService.getFreezeUserIds(uid);
				log.info("students is " + students);

				map = DynamicUtil.getFreezeUserListParams(uid, type);

				List<Long> ids = freezeUserService.getIdsByDynamicCondition(FreezeUser.class, map, 0,
						Integer.MAX_VALUE);
				int idsContent = ids.size();
				log.info("ids is " + idsContent);
				if (0 == idsContent) {
					model.addAttribute("code", -5024);
					log.info("unfreeze user  error");
					return "/common/failure";
				} else if (1 == ids.size()) {
					freezeUser = freezeUserService.getObjectById(ids.get(0));
					freezeUser.setStatus(FreezeUser.STATUS_UNFREEZE);
					studentsService.update(students);
					freezeUserService.update(freezeUser);
				}
				break;
			default:

			}
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("unfreeze user  error  ");
			model.addAttribute("code", -5005);
			model.addAttribute("result", null);
		}

		return "common/success";
	}

	/**
	 * 查看考试学员列表
	 * @param request
	 * @param response
	 * @param model
	 * @param cityId
	 * @param schoolId
	 * @param name
	 * @param mobile
	 * @param progress
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = " /a/u/exam/student/list ", method = RequestMethod.GET)
	public String getExamStudentsList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			String name, Long cityId, Long schoolId, String mobile, Integer progress, Integer page, Integer size)
			throws Exception {

		log.info("/a/u/exam/student/list param is " + "  cityId ===== " + cityId + ", schoolId ==" + schoolId
				+ ", name ==" + name + ", mobile ==" + mobile + ", progress ==" + progress + ", page == " + page
				+ " , size == " + size);

		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		Map<String, Object> params = DynamicUtil.getStudentListParams(name, null, cityId, schoolId, null, mobile,
				progress, null, null, null, null);
		List<Long> studentListIds = studentsService.getIdsByDynamicCondition(Students.class, params, start, size);
		List<Students> studentsList = studentsService.getObjectsByIds(studentListIds);
		Integer total = studentsService.getIdsByDynamicCondition(Students.class, params, 0, Integer.MAX_VALUE).size();

		//以下代码为从coach表中获取教练mobile,并与studentId对应起来.
		Map<Long, String> studentId_coach = MyListUtil.convert2Map(Students.class.getDeclaredField("id"),
				Students.class.getDeclaredField("sectionTwoCoachId"), studentsList);
		log.info("studentId_coach is : " + studentId_coach);
		//剔除重复和null
		Set<Long> coachIds = new HashSet<>();
		for (String coachId : studentId_coach.values()) {
			if (DataUtils.isNullOrEmpty(coachId)) {
				log.info(" coachId is null ");
			} else {
				Long examCoachId = Long.valueOf(coachId);
				log.info(" examCoachId is : " + examCoachId);
				coachIds.add(examCoachId);
			}
		}
		//转为list
		List<Long> asListCoachIds = new ArrayList<>(coachIds);
		log.info(" asListCoachIds is : " + asListCoachIds);
		List<Coach> coachList = coachService.getObjectsByIds(asListCoachIds);
		Map<Long, String> examCoachId2CoachMobile = MyListUtil.convert2Map(Coach.class.getDeclaredField("id"),
				Coach.class.getDeclaredField("mobile"), coachList);
		log.info("esamCoachId2CoachMobile is :" + examCoachId2CoachMobile);

		List<Map<String, Object>> examStudentList = new ArrayList<>();
		for (Students students : studentsList) {

			Map<String, Object> examStudent = new HashedMap();

			examStudent.put("id", students.getId());
			examStudent.put("name", students.getName());
			examStudent.put("school", students.getSchool());
			examStudent.put("mobile", students.getMobile());
			examStudent.put("coach", students.getSectionTwoCoach());
			if (DataUtils.isNullOrEmpty(students.getSectionThreeCoachId())) {
				examStudent.put("coachMobile", "");
			} else {
				String coachMobile = examCoachId2CoachMobile.get(Long.valueOf(studentId_coach.get(students.getId())));
				log.info("coachMobile is : " + coachMobile);
				examStudent.put("coachMobile", coachMobile);
			}
			examStudent.put("className", students.getClassName());
			examStudent.put("progress", students.getProgress());
			log.info("examStudent is " + examStudent);

			examStudentList.add(examStudent);
		}

		model.addAttribute("code", 0);
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", total);
		model.addAttribute("examStudentList", examStudentList);

		return "/yi-nucleus-service/students/json/examStudentsListJson";
	}

	/**
	 * 人员搜索:符合条件的科一,科四,体检,受理进度学员
	 * @param request
	 * @param response
	 * @param model
	 * @param type
	 * @param schoolId
	 * @param mobile
	 * @param times
	 * @param score
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/exam/student/practice/list", method = RequestMethod.GET)
	public String getPracticeStudentJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer type, Long schoolId, String mobile, Integer times, Integer score, Integer page, Integer size)
			throws Exception {

		log.info("/a/u/exam/student/practice/list " + "  type ===== " + type + ", schoolId ==" + schoolId
				+ ", mobile ==" + mobile + ", times == " + times + ", score == " + score + ", page == " + page
				+ " , size == " + size);

		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		//入参判空,考试类型必填
		if (!(type == 3) && !(type == 6) && !(type == 1) && !(type == 2)) {
			model.addAttribute("code", -24201);
			log.info("testActivity type  error");
			return "/common/failure";

		}

		//初次筛选符合条件(驾校,考务活动类型,手机号)学生
		Map<String, Object> params = DynamicUtil.getExamStudentsListParams(type, schoolId, mobile, null);
		List<Long> examStudentsIds = studentsService.getIdsByDynamicCondition(Students.class, params, start, size);
		Integer total = studentsService.getIdsByDynamicCondition(Students.class, params, 0, Integer.MAX_VALUE).size();

		//防止examStudentsIds为空的问题
		if ((examStudentsIds == null ? "null" : examStudentsIds.size()).equals(0)) {
			model.addAttribute("code", -24202);
			log.info(" examStudentsIds  error");
			return "/common/failure";
		}

		log.info(" 1  examStudentsIds is : " + examStudentsIds);

		//进一步根据模拟练习成绩筛选(受理和体检不用),group by保证studentId唯一性
		if (DataUtils.isNotNullOrEmpty(times) || DataUtils.isNotNullOrEmpty(score)) {

			Map<String, Object> countsParams = DynamicUtil.getCountsByConditonsParams(type, score, examStudentsIds);
			examStudentsIds = subjectExamService.getIdsByDynamicCondition(SubjectExam.class, countsParams, 0,
					Integer.MAX_VALUE);
			log.info(" 2  examStudentsIds is : " + examStudentsIds);
		}

		log.info(" 3  examStudentsIds is : " + examStudentsIds);

		List<Students> examStudentsList = studentsService.getObjectsByIds(examStudentsIds);
		List<Map<String, Object>> practiceStudentsList = new ArrayList<>();

		for (Students students : examStudentsList) {

			log.info("students is : " + students);

			HashMap<String, Object> examStudentMap = new HashMap<>();

			//获取考试次数
			List<Long> oldTestRecordIds = testRecordsService.getTestRecordsIdsByStuIdAndIsNews(students.getId(), 0, 0,
					Integer.MAX_VALUE);
			log.info("oldTestRecordIds is : " + oldTestRecordIds);
			//判断是否第一考试,第一考试没有考试记录,id为空,通
			if ((oldTestRecordIds == null ? "null" : oldTestRecordIds.size()).equals(0)) {
				examStudentMap.put("times", 1);
			} else {
				Long oldTestRecordId = oldTestRecordIds.get(0);
				log.info("oldTestRecordId is : " + oldTestRecordId);
				TestRecords oldTestRecord = testRecordsService.getObjectById(oldTestRecordId);
				examStudentMap.put("times", oldTestRecord.getTimes() + 1);
			}

			examStudentMap.put("id", students.getId());
			examStudentMap.put("name", students.getName());
			examStudentMap.put("mobile", students.getMobile());
			examStudentMap.put("applyTime", students.getRegistrationDate());

			practiceStudentsList.add(examStudentMap);

		}

		model.addAttribute("code", 0);
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", total);
		model.addAttribute("practiceStudentsList", practiceStudentsList);

		return "/yi-nucleus-service/students/json/practiceStudentsListJson";
	}

	/**
	 * 人员搜索:符合条件的科二,科三进度学员
	 * @param request
	 * @param response
	 * @param model
	 * @param coachId
	 * @param type
	 * @param schoolId
	 * @param mobile
	 * @param startTime
	 * @param endTime
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/exam/student/operation/list", method = RequestMethod.GET)
	public String getOperationStudentJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long coachId, Integer type, Long schoolId, String mobile, Long startTime, Long endTime, Integer page,
			Integer size) throws Exception {

		log.info("/a/u/exam/student/operation/list " + ", coachId == " + coachId + "  type ===== " + type
				+ ", schoolId ==" + schoolId + ", mobile ==" + mobile + ", endTime == " + endTime + ", startTime == "
				+ startTime + ", page == " + page + " , size == " + size);

		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		//入参判空,考试类型必填
		if (!(type == 4) && !(type == 5)) {
			model.addAttribute("code", -24201);
			log.info("testActivity type  error");
			return "/common/failure";

		}

		Map<String, Object> params = DynamicUtil.getExamStudentsListParams(type, schoolId, mobile, coachId);
		List<Long> examStudentsIds = studentsService.getIdsByDynamicCondition(Students.class, params, start, size);
		Integer total = studentsService.getIdsByDynamicCondition(Students.class, params, 0, Integer.MAX_VALUE).size();

		//防止examStudentsIds为空的问题
		if ((examStudentsIds == null ? "null" : examStudentsIds.size()).equals(0)) {
			model.addAttribute("code", -24202);
			log.info(" examStudentsIds  error");
			return "/common/failure";
		}

		log.info(" 1  examStudentsIds is : " + examStudentsIds);

		//进一步根据推荐时间筛选,group by保证studentId唯一性
		if (DataUtils.isNotNullOrEmpty(startTime) || DataUtils.isNotNullOrEmpty(endTime)) {

			Map<String, Object> countsParams = DynamicUtil.getRecommendStudentsByConditonsParams(type, startTime,
					startTime, examStudentsIds);
			examStudentsIds = subjectExamService.getIdsByDynamicCondition(SubjectExam.class, countsParams, 0,
					Integer.MAX_VALUE);
			log.info(" 2  examStudentsIds is : " + examStudentsIds);
		}

		log.info(" 3  examStudentsIds is : " + examStudentsIds);

		List<Students> examStudentsList = studentsService.getObjectsByIds(examStudentsIds);
		List<Map<String, Object>> operationStudentsList = new ArrayList<>();

		for (Students students : examStudentsList) {

			log.info("students is : " + students);

			Map<String, Object> operationStudentMap = new HashedMap();

			//获取考试次数
			List<Long> oldTestRecordIds = testRecordsService.getTestRecordsIdsByStuIdAndIsNews(students.getId(), 0, 0,
					Integer.MAX_VALUE);
			log.info("oldTestRecordIds is : " + oldTestRecordIds);
			//判断是否第一考试,第一考试没有考试记录,id为空,通
			if ((oldTestRecordIds == null ? "null" : oldTestRecordIds.size()).equals(0)) {
				operationStudentMap.put("times", 1);
			} else {
				Long oldTestRecordId = oldTestRecordIds.get(0);
				log.info("oldTestRecordId is : " + oldTestRecordId);
				TestRecords oldTestRecord = testRecordsService.getObjectById(oldTestRecordId);
				operationStudentMap.put("times", oldTestRecord.getTimes() + 1);
			}

			//获取推荐时间
			Map<String, Object> recommendStudentParm = DynamicUtil.getRecommendStudentsByStudentId(students.getId());
			List<Long> oldCoachRecommendIds = coachRecommendService.getIdsByDynamicCondition(CoachRecommend.class,
					recommendStudentParm, 0, Integer.MAX_VALUE);
			log.info("oldTestRecordIds is : " + oldTestRecordIds);
			//判断是否推荐,
			if ((oldCoachRecommendIds == null ? "null" : oldCoachRecommendIds.size()).equals(0)) {
				operationStudentMap.put("recommendTime", -1);
			} else {
				Long oldCoachRecommendId = oldCoachRecommendIds.get(0);
				log.info("oldCoachRecommendId is : " + oldCoachRecommendId);
				CoachRecommend oldCoachRecommend = coachRecommendService.getObjectById(oldCoachRecommendId);
				operationStudentMap.put("recommendTime", oldCoachRecommend.getCreateAt());
			}

			operationStudentMap.put("id", students.getId());
			operationStudentMap.put("name", students.getName());
			operationStudentMap.put("mobile", students.getMobile());

			operationStudentsList.add(operationStudentMap);
		}

		model.addAttribute("code", 0);
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", total);
		model.addAttribute("operationStudentsList", operationStudentsList);

		return "/yi-nucleus-service/students/json/operationStudentsListJson";
	}

	/**
	 * 获取教练推荐学员
	 * @param request
	 * @param response
	 * @param model
	 * @param name
	 * @param type
	 * @param schoolId
	 * @param mobile
	 * @param coach
	 * @param coachMobile
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/recommend/student/list", method = RequestMethod.GET)
	public String getRecommendStudentJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
										  Long cityId , String name, Integer type, Long schoolId, String mobile, String coach, String coachMobile, Integer page,
			Integer size) throws Exception {

		log.info("/a/u/recommend/student/list "
				+ ", cityId == " + cityId
				+ ", name == " + name
				+ ", type ===== " + type
				+ ", schoolId ==" + schoolId
				+ ", mobile ==" + mobile
				+ ", coach ==" + coach
				+ ", coachMobile == " + coachMobile
				+ ", page == " + page
				+ ", size == " + size);

		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		//通过姓名获取ID
		Long coachId   = null ;
		Long studentId = null ;

		if (DataUtils.isNullOrEmpty(name)) {
			log.info("name is null");
		}else {
			Map<String,Object> studentParams = DynamicUtil.getStudentIdByName(name);
			List<Long> studentIds = studentsService.getIdsByDynamicCondition(Students.class , studentParams , 0 , Integer.MAX_VALUE);
			if ((studentIds == null ? "null" : studentIds.size()).equals(0)) {
				model.addAttribute("code", -24302);
				log.info(" studentIds  error");
				return "/common/failure";
			} else {
				studentId = studentIds.get(0);
				log.info("studentId is : " + studentId );
			}
		}
		if (DataUtils.isNullOrEmpty(coach)) {
			log.info("coachName is null");
		}else {
			Map<String, Object> coachParams = DynamicUtil.getCoachIdByName(coach);
			List<Long> coachIds = coachService.getIdsByDynamicCondition(Coach.class, coachParams, 0, Integer.MAX_VALUE);
			log.info("coachIds is : " + coachIds);
			if ((coachIds == null ? "null" : coachIds.size()).equals(0)) {
				model.addAttribute("code", -24301);
				log.info(" coachIds  error");
				return "/common/failure";
			} else {
				coachId = coachIds.get(0);
				log.info("coachId is : " + coachId);
			}
		}

		Map<String,Object> params = DynamicUtil.getRecommendStudents( studentId , type , schoolId , mobile , coachId , coachMobile);
        List<Long> coachRecommendIds = coachRecommendService.getIdsByDynamicCondition(CoachRecommend.class , params , 0 , Integer.MAX_VALUE );
        log.info("coachRecommendIds is : " + coachRecommendIds);
        List<CoachRecommend> coachRecommendList = coachRecommendService.getObjectsByIds(coachRecommendIds);

		log.info("coachRecommendList is : " + coachRecommendList.size());
		List<Map<String, Object>> recommendStudentsList = new ArrayList<>();

		List<Long> stuIds = MyListUtil.getList(CoachRecommend.class.getDeclaredField("stuId") , coachRecommendList);
		List<Long> coaIds = MyListUtil.getList(CoachRecommend.class.getDeclaredField("coachId") , coachRecommendList);
		List<Long> schoIds = MyListUtil.getList(CoachRecommend.class.getDeclaredField("schoolId") , coachRecommendList);

		List<Students> stuList = studentsService.getObjectsByIds(stuIds);
		Map<Long,Students> stuId_student = MyListUtil.convert2Map(Students.class.getDeclaredField("id"),stuList);
		log.info("1  stuList is : " + stuList.size());
		List<CoachRecommend> newCoachRecommendList = new ArrayList<>();
		if (DataUtils.isNotNullOrEmpty(cityId)) {
			for ( CoachRecommend stu : coachRecommendList) {
				log.info(" stu is : " + stu);

				Long getstuCity = stuId_student.get(stu.getStuId()).getCityId();
				log.info("getstuCity is : " +getstuCity);
				if (DataUtils.isNullOrEmpty(getstuCity)){
					log.info(" stu is not cityId ");
				}else {
					if ((stuId_student.get(stu.getStuId())).getCityId().equals(cityId)) {
						newCoachRecommendList.add(stu);
					}
				}

			}
			coachRecommendList = newCoachRecommendList;
			log.info("2 newstuList is : " + newCoachRecommendList.size());
		}

		//判断分页
		Integer total = coachRecommendList.size();
		List<CoachRecommend> oldCoachRecommendList = coachRecommendList;
		int end = page * size;
		if (total-end < 0) {
			end = total-(page-1)*size;
		}
		coachRecommendList = oldCoachRecommendList.subList(start,end);

		List<Coach> coaList = coachService.getObjectsByIds(coaIds);
		List<School> schoList = schoolService.getObjectsByIds(schoIds);

		Map<Long,String> stuId_name = MyListUtil.convert2Map(Students.class.getDeclaredField("id") , Students.class.getDeclaredField("name") , stuList);
		Map<Long,String> coaId_name = MyListUtil.convert2Map(Coach.class.getDeclaredField("id") , Coach.class.getDeclaredField("name") , coaList);
		Map<Long,String> schoId_name = MyListUtil.convert2Map(School.class.getDeclaredField("id") , School.class.getDeclaredField("name") , schoList);

		for ( CoachRecommend recommendStudent : coachRecommendList ){
			Map<String, Object> recommendStudentMap = new HashedMap();

			recommendStudentMap.put("id", recommendStudent.getId());
			recommendStudentMap.put("name", stuId_name.get(Long.valueOf(recommendStudent.getStuId())));
			recommendStudentMap.put("mobile", recommendStudent.getStuMobile());
			recommendStudentMap.put("times", recommendStudent.getTimes());
			recommendStudentMap.put("coach", coaId_name.get(Long.valueOf(recommendStudent.getCoachId())));
			recommendStudentMap.put("coachMobile", recommendStudent.getCoachMobile());
			recommendStudentMap.put("subject", recommendStudent.getSubject() );
			log.info("subject is : " + recommendStudent.getSubject() );
			recommendStudentMap.put("recommendTime", recommendStudent.getCreateAt());
			//驾校属性有可能为空么
			recommendStudentMap.put("school", schoId_name.get(Long.valueOf(recommendStudent.getSchoolId())));

			recommendStudentsList.add(recommendStudentMap);
		}

		model.addAttribute("code", 0);
		model.addAttribute("page", page);
		model.addAttribute("size", size);
		model.addAttribute("total", total);
		model.addAttribute("recommendStudentsList", recommendStudentsList);

		return "/yi-nucleus-service/students/json/recommendStudentsListJson";
	}

}
