package com.ptteng.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.pub.model.StudentUnregistered;
import com.ptteng.yi.pub.service.StudentUnregisteredService;

/**
 * StudentUnregistered  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class StudentUnregisteredController {
	private static final Log log = LogFactory.getLog(StudentUnregisteredController.class);

	@Autowired
	private StudentUnregisteredService studentUnregisteredService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/studentUnregistered", method = RequestMethod.GET)
	public String getstudentUnregisteredList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/studentUnregistered  to /studentUnregistered/view/studentUnregisteredList");

		return "/yi-public-service/studentUnregistered/view/studentUnregisteredList";
	}

	@RequestMapping(value = "/c/studentUnregistered/{id}", method = RequestMethod.GET)
	public String getStudentUnregistered(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/studentUnregistered/" + id + "  to /studentUnregistered/view/studentUnregisteredDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-public-service/studentUnregistered/view/studentUnregisteredDetail";
	}

	@RequestMapping(value = "/a/studentUnregistered/{id}", method = RequestMethod.GET)
	public String getStudentUnregisteredJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			StudentUnregistered studentUnregistered = studentUnregisteredService.getObjectById(id);
			log.info("get studentUnregistered data is " + studentUnregistered);

			model.addAttribute("code", 0);

			model.addAttribute("studentUnregistered", studentUnregistered);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get studentUnregistered error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-public-service/studentUnregistered/json/studentUnregisteredDetailJson";
	}

	@RequestMapping(value = "/a/studentUnregistered/{id}", method = RequestMethod.PUT)
	public String updateStudentUnregisteredJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, StudentUnregistered studentUnregistered) throws Exception {

		log.info("update studentUnregistered : studentUnregistered= " + studentUnregistered);

		try {

			studentUnregisteredService.update(studentUnregistered);

			model.addAttribute("code", 0);

			model.addAttribute("studentUnregistered", studentUnregistered);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update studentUnregistered error,id is  " + studentUnregistered.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/studentUnregistered", method = RequestMethod.POST)
	public String addStudentUnregisteredJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			StudentUnregistered studentUnregistered) throws Exception {

		log.info("update studentUnregistered : studentUnregistered= " + studentUnregistered);

		try {
			studentUnregistered.setId(null);

			studentUnregisteredService.insert(studentUnregistered);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add studentUnregistered error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/studentUnregistered/{id}", method = RequestMethod.DELETE)
	public String deleteStudentUnregisteredJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete studentUnregistered : id= " + id);
		try {
			studentUnregisteredService.delete(id);

			log.info("add studentUnregistered success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete studentUnregistered error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/studentUnregistered", method = RequestMethod.GET)
	public String getMultiStudentUnregisteredJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<StudentUnregistered> studentUnregisteredList = studentUnregisteredService.getObjectsByIds(idList);
			log.info("get  studentUnregistered data is " + studentUnregisteredList);

			model.addAttribute("code", 0);
			model.addAttribute("total", studentUnregisteredList.size());

			model.addAttribute("studentUnregisteredList", studentUnregisteredList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get studentUnregistered error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-public-service/studentUnregistered/json/studentUnregisteredListJson";
	}

}
