package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Settlement;
import com.ptteng.yi.nucleus.service.SettlementService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @Description: 包含结算相关接口
 * @author: zhangxin
 * @Date: 2017-10-12
 */
@Controller
public class SettlementController {
    private static final Log log = LogFactory.getLog(SettlementController.class);

    @Resource
    private SettlementService settlementService;

    /**
     * 查询结算列表
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/settlement/list", method = RequestMethod.GET)
    public String getSettlementList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer page, Integer size, Long schoolId, Long startTime, Long endTime, Integer status, Long cityId)
            throws Exception {

        log.info("Interface GET /a/u/settlement/list, Method getSettlementList() parameters, schoolId: " + schoolId
                + ", startTime: " + startTime + ", endTime: " + endTime + ", status: " + status + ", cityId: "
                + cityId);
        int actualSize = ParamsUtil.calculateActualSize(size);
        int startPosition = ParamsUtil.calculateStartPosition(page, actualSize);
        log.info("page: " + startPosition + " , size: " + actualSize);

        int validateResult = ParamsUtil.checkParametersOfGetSettlementList(schoolId, status, cityId);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            Map<String, Object> querySettlementMap = DynamicUtil.getSettlementListParams(schoolId, startTime, endTime,
                    status, cityId, false);
            List<Long> settlementIdList = settlementService.getIdsByDynamicCondition(Settlement.class,
                    querySettlementMap, startPosition, actualSize);
            log.info("get settlement Id list, list is : " + settlementIdList);

            List<Settlement> settlementList = null;
            Long total = 0L;
            if (CollectionUtils.isNotEmpty(settlementIdList)) {
                settlementList = settlementService.getObjectsByIds(settlementIdList);
                log.info("get settlement list by ids, list size is : " + settlementList.size());

                Map<String, Object> countSettlementMap = DynamicUtil.getSettlementListParams(schoolId, startTime, endTime, status, cityId, true);
                total = settlementService.getIdsByDynamicCondition(Settlement.class, countSettlementMap, 0, Integer.MAX_VALUE).get(0);
                log.info("count settlement list total size is : " + total);
            }

            model.addAttribute("code", 0);
            model.addAttribute("settlementList", settlementList);
            model.addAttribute("total", total);
            model.addAttribute("size", actualSize);

            return "/yi-nucleus-service/settlement/json/settlementListJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getSettlementList() failed, page is: " + page + ", size is: " + size);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }
}