package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.SchoolVenuesRelation;
import com.ptteng.yi.nucleus.service.SchoolVenuesRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * SchoolVenuesRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SchoolVenuesRelationController {
	private static final Log log = LogFactory.getLog(SchoolVenuesRelationController.class);

	@Autowired
	private SchoolVenuesRelationService schoolVenuesRelationService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/schoolVenuesRelation", method = RequestMethod.GET)
	public String getschoolVenuesRelationList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/schoolVenuesRelation  to /schoolVenuesRelation/view/schoolVenuesRelationList");

		return "/yi-nucleus-service/schoolVenuesRelation/view/schoolVenuesRelationList";
	}

	/**
	* 
	* @param 
	* @return 
	* @throws ServiceException
	* @throws ServiceDaoException
	*/

	@RequestMapping(value = "/c/schoolVenuesRelation1 ", method = RequestMethod.GET)
	public String getSchoolVenuesRelationIdsBySchoolIdOrderByCreateByList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long schoolId) throws Exception {

		log.info("/schoolVenuesRelation  to /schoolVenuesRelation/view/schoolVenuesRelationList");

		return "/yi-nucleus-service/schoolVenuesRelation/view/schoolVenuesRelationList";
	}

	@RequestMapping(value = "/c/schoolVenuesRelation/{id}", method = RequestMethod.GET)
	public String getSchoolVenuesRelation(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/schoolVenuesRelation/" + id + "  to /schoolVenuesRelation/view/schoolVenuesRelationDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/schoolVenuesRelation/view/schoolVenuesRelationDetail";
	}

	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/schoolVenuesRelation1 ", method = RequestMethod.GET)
	public String getSchoolVenuesRelationIdsBySchoolIdOrderByCreateByJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size, Long schoolId) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = schoolVenuesRelationService.getSchoolVenuesRelationIdsBySchoolIdOrderByCreateBy(schoolId,
					start, size);
			log.info("get countSchoolVenuesRelationIdsBySchoolIdOrderByCreateBy size is " + ids.size());

			List<SchoolVenuesRelation> schoolVenuesRelationList = schoolVenuesRelationService.getObjectsByIds(ids);
			log.info("get schoolVenuesRelation data is " + schoolVenuesRelationList.size());

			Integer total = schoolVenuesRelationService.countSchoolVenuesRelationIdsBySchoolIdOrderByCreateBy(schoolId);
			log.info("get schoolVenuesRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("schoolVenuesRelationList", schoolVenuesRelationList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get schoolVenuesRelation list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/schoolVenuesRelation/json/schoolVenuesRelationListJson";
	}

	@RequestMapping(value = "/a/schoolVenuesRelation/{id}", method = RequestMethod.GET)
	public String getSchoolVenuesRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			SchoolVenuesRelation schoolVenuesRelation = schoolVenuesRelationService.getObjectById(id);
			log.info("get schoolVenuesRelation data is " + schoolVenuesRelation);

			model.addAttribute("code", 0);

			model.addAttribute("schoolVenuesRelation", schoolVenuesRelation);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get schoolVenuesRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/schoolVenuesRelation/json/schoolVenuesRelationDetailJson";
	}

	@RequestMapping(value = "/a/schoolVenuesRelation/{id}", method = RequestMethod.PUT)
	public String updateSchoolVenuesRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, SchoolVenuesRelation schoolVenuesRelation) throws Exception {

		log.info("update schoolVenuesRelation : schoolVenuesRelation= " + schoolVenuesRelation);

		try {

			schoolVenuesRelationService.update(schoolVenuesRelation);

			model.addAttribute("code", 0);

			model.addAttribute("schoolVenuesRelation", schoolVenuesRelation);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update schoolVenuesRelation error,id is  " + schoolVenuesRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/schoolVenuesRelation", method = RequestMethod.POST)
	public String addSchoolVenuesRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			SchoolVenuesRelation schoolVenuesRelation) throws Exception {

		log.info("update schoolVenuesRelation : schoolVenuesRelation= " + schoolVenuesRelation);

		try {
			schoolVenuesRelation.setId(null);

			schoolVenuesRelationService.insert(schoolVenuesRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add schoolVenuesRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/schoolVenuesRelation/{id}", method = RequestMethod.DELETE)
	public String deleteSchoolVenuesRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete schoolVenuesRelation : id= " + id);
		try {
			schoolVenuesRelationService.delete(id);

			log.info("add schoolVenuesRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete schoolVenuesRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/schoolVenuesRelation", method = RequestMethod.GET)
	public String getMultiSchoolVenuesRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<SchoolVenuesRelation> schoolVenuesRelationList = schoolVenuesRelationService.getObjectsByIds(idList);
			log.info("get  schoolVenuesRelation data is " + schoolVenuesRelationList);

			model.addAttribute("code", 0);
			model.addAttribute("total", schoolVenuesRelationList.size());

			model.addAttribute("schoolVenuesRelationList", schoolVenuesRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get schoolVenuesRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/schoolVenuesRelation/json/schoolVenuesRelationListJson";
	}

}
