package com.ptteng.controller;

import com.gemantic.common.util.PasswordUtils;
import com.ptteng.common.yi.model.Manager;
import com.ptteng.common.yi.service.ManagerService;
import com.ptteng.model.schoolAbout.SchoolTable;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.util.ParametersUtil;
import com.ptteng.yi.nucleus.model.*;
import com.ptteng.yi.nucleus.service.*;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.service.ImAccountService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * School  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SchoolController {
	private static final Log log = LogFactory.getLog(SchoolController.class);

	@Autowired
	private SchoolService schoolService;

	@Autowired
	private TrainingVenuesService trainingVenuesService;

	@Autowired
	private SchoolVenuesRelationService schoolVenuesRelationService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private DrivingClassService drivingClassService;

	@Autowired
	private SchoolClassRelationService schoolClassRelationService;
	@Autowired
	private ManagerService managerService;

	@Autowired
	private StudentsService studentsService;

	@Autowired
	private CoachService coachService;

	@Autowired
	private ImAccountService imAccountService;

	@Autowired
	ImChatUtil imChatUtil;

	/**获取驾校列表，搜索
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param cityId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/school/list", method = RequestMethod.GET)
	public String getSchoolIdsByStatusOrderByCreateByJsonList(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Integer page, Integer size, Long cityId, String name, String location,
			String trainingVenuesName, String resPersion, String mobile) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			if (DataUtils.isNullOrEmpty(cityId)) {
				model.addAttribute("code", -9049);
				log.info("parameter tid is null or empty");
				return "/common/failure";
			}

			Map<String, Object> map = new HashMap<>();

			//动态查询
			map = DynamicUtil.getSchoolListByCondition(cityId, name, location, trainingVenuesName, resPersion, mobile);
			List<Long> ids = schoolService.getIdsByDynamicCondition(School.class, map, start, size);
			log.info(ids);
			log.info("get countSchoolIdsByStatusOrderByCreateBy size is " + ids.size());

			List<School> schoolList = schoolService.getObjectsByIds(ids);
			log.info("get school data is " + schoolList.size());

			Integer total = schoolService.getIdsByDynamicCondition(School.class, map, 0, Integer.MAX_VALUE).size();
			log.info("get school count is " + total);

			//学员,运营中心下
			Map<String, Object> sMap = new HashMap<>();
			sMap = DynamicUtil.getStudentIdsByCity(cityId);
			List<Long> stuIds = studentsService.getIdsByDynamicCondition(Students.class, sMap, 0, Integer.MAX_VALUE);
			log.info("get stuIds is" + stuIds);
			List<Students> studentsList = studentsService.getObjectsByIds(stuIds);

			//教练,运营中心下
			Map<String, Object> cMap = new HashMap<>();
			cMap = DynamicUtil.getCoachIdsByCity(cityId);
			List<Long> coachIds = coachService.getIdsByDynamicCondition(Coach.class, cMap, 0, Integer.MAX_VALUE);
			log.info("get coachIds is" + coachIds);
			List<Coach> coachList = coachService.getObjectsByIds(coachIds);

			List<SchoolTable> schoolTableList = new ArrayList<>();
			//添加学员，教练数量
			for (School school : schoolList) {
				Long schoolId = school.getId();

				Integer stuNum = 0;
				//学员数量
				for (Students student :studentsList)
				{
					if ( DataUtils.isNotNullOrEmpty(student.getSchoolId()) && student.getSchoolId().equals(schoolId))
					{
						stuNum++;
					}
				}

				Integer coachNum = 0;
				//教练数量
				for (Coach coach :coachList)
				{
					if (DataUtils.isNotNullOrEmpty(coach.getSchoolId()) && coach.getSchoolId().equals(schoolId))
					{
						coachNum++;
					}
				}

				SchoolTable schoolTable = new SchoolTable();
				schoolTable.setSchool(school);
				schoolTable.setStudentTotal(stuNum);
				schoolTable.setCoachTotal(coachNum);
				schoolTableList.add(schoolTable);
			}

			log.info("get schoolTableList is" + schoolTableList);
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("schoolList", schoolTableList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get school list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/school/json/schoolListJson";
	}

	@RequestMapping(value = "/a/u/school/{id}", method = RequestMethod.GET)
	public String getSchoolJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			School school = schoolService.getObjectById(id);
			log.info(school);
			List<Long> schoolClassRelationids = schoolClassRelationService
					.getSchoolClassRelationIdsBySchoolIdOrderByCreateBy(id, 0, Integer.MAX_VALUE);
			log.info("schoolClassRelationids" + schoolClassRelationids);
			List<SchoolClassRelation> slists = schoolClassRelationService.getObjectsByIds(schoolClassRelationids);
			log.info("slists is" + slists);

			TrainingVenues trainingVenues = trainingVenuesService.getObjectById(school.getTrainingVenues());
			log.info( "school getTrainingVenues is" + school.getTrainingVenues());
			log.info( "trainingVenues is " + trainingVenues);
			log.info("get school data is " + school);

			model.addAttribute("code", 0);

			model.addAttribute("school", school);
			model.addAttribute("trainingVenues", trainingVenues);
			model.addAttribute("schoolClassRelationList", slists);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get school error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/school/json/schoolDetailJson";
	}

	/**修改驾校
	 *
	 * @param request
	 *
	 * @param model
	 * @param school
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/school/{sid}", method = RequestMethod.PUT)
	public String updateSchoolJson(HttpServletRequest request, Long trainingVenuesId, ModelMap model, School school,
			@RequestParam(value = "classes") Long[] classes, @PathVariable Long sid) throws Exception {

		log.info("update school : school= " + school);
		log.info("classes= " + classes);

		try {
			Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
			double hundred =  School.RATE_HUNDRED;

			double zero = School.RATE_ZERO;

			BigDecimal hundredFinal = new BigDecimal(hundred);

			BigDecimal zeroFinal = new BigDecimal(zero);

			//阿里账号
			if (DataUtils.isNullOrEmpty(school.getAlipay())) {
				model.addAttribute("code", -9036);
				log.info("parameter alipay is null or empty");
				return "/common/failure";
			}
			//银行卡号
			if (DataUtils.isNullOrEmpty(school.getBackAccount())) {
				model.addAttribute("code", -9036);
				log.info("parameter amount is null or empty");
				return "/common/failure";
			}
			//持卡人
			if (DataUtils.isNullOrEmpty(school.getCardholder())) {
				model.addAttribute("code", -9037);
				log.info("parameter cardholder is null or empty");
				return "/common/failure";
			}
			//持卡人身份证
			if (DataUtils.isNullOrEmpty(school.getCardholderIdentify())) {
				model.addAttribute("code", -9034);
				log.info("parameter cardholderIdentify is null or empty");
				return "/common/failure";
			}
			//城市
			if (DataUtils.isNullOrEmpty(school.getCityId())) {
				model.addAttribute("code", -9038);
				log.info("parameter cityId is null or empty");
				return "/common/failure";
			}
			//合同
			if (DataUtils.isNullOrEmpty(school.getContract())) {
				model.addAttribute("code", -9039);
				log.info("parameter contract is null or empty");
				return "/common/failure";
			}
			//开户行
			if (DataUtils.isNullOrEmpty(school.getDepositBank())) {
				model.addAttribute("code", -9035);
				log.info("parameter depositBank is null or empty");
				return "/common/failure";
			}
			//名字
			if (DataUtils.isNullOrEmpty(school.getName())) {
				model.addAttribute("code", -9037);
				log.info("parameter name is null or empty");
				return "/common/failure";
			}
			//地址
			if (DataUtils.isNullOrEmpty(school.getLocation())) {
				model.addAttribute("code", -9040);
				log.info("parameter Location is null or empty");
				return "/common/failure";
			}
			//费率
			if (DataUtils.isNullOrEmpty(school.getRate())) {
				model.addAttribute("code", -9041);
				log.info("parameter rate is null or empty");
				return "/common/failure";
			}
			Double rate = Double.valueOf(school.getRate());
			BigDecimal rateB = new BigDecimal(rate);
			Integer max = rateB.compareTo(hundredFinal);
			Integer min = rateB.compareTo(zeroFinal);
			if (max.equals(1) || max.equals(0) || min.equals(0) || min.equals(-1)) {
				model.addAttribute("code", -23012);
				log.info("parameter rate is invaild");
				return "/common/failure";
			}

			//考务电话
			if (DataUtils.isNullOrEmpty(school.getHotline())) {
				model.addAttribute("code", -9042);
				log.info("parameter hotline is null or empty");
				return "/common/failure";
			}
			//密码
			if (DataUtils.isNullOrEmpty(school.getPwd())) {
				model.addAttribute("code", -9043);
				log.info("parameter pwd is null or empty");
				return "/common/failure";
			} else {
				String encodePass = PasswordUtils.encode(school.getPwd());
				school.setPwd(encodePass);
			}
			//负责人
			if (DataUtils.isNullOrEmpty(school.getResPerson())) {
				model.addAttribute("code", -9037);
				log.info("parameter resPerson is null or empty");
				return "/common/failure";
			}
			//负责人电话
			if (DataUtils.isNullOrEmpty(school.getMobile())) {
				model.addAttribute("code", -9042);
				log.info("parameter mobile is null or empty");
				return "/common/failure";
			}



			//预约说明
			if (DataUtils.isNullOrEmpty(school.getInstruction())) {
				model.addAttribute("code", -9044);
				log.info("parameter instruction is null or empty");
				return "/common/failure";
			}
			//训练场名字
			if (DataUtils.isNullOrEmpty(school.getTrainingVenuesName())) {
				model.addAttribute("code", -9037);
				log.info("parameter trainingVenuesName is null or empty");
				return "/common/failure";
			}
			//训练场
			if (DataUtils.isNullOrEmpty(school.getTrainingVenues())) {
				model.addAttribute("code", -9045);
				log.info("parameter TrainingVenues is null or empty");
				return "/common/failure";
			}

			//班级
			if (DataUtils.isNullOrEmpty(classes)) {
				model.addAttribute("code", -9025);
				log.info("parameter classes is null or empty");
				return "/common/failure";
			}
			//办公室电话
			if (DataUtils.isNullOrEmpty(school.getOfficeMobile())) {
				model.addAttribute("code", -9042);
				log.info("parameter officeMobile is null or empty");
				return "/common/failure";
			}
			//办公地址
			if (DataUtils.isNullOrEmpty(school.getAddress())) {
				model.addAttribute("code", -9040);
				log.info("parameter address is null or empty");
				return "/common/failure";
			}
			//发票
			if (DataUtils.isNullOrEmpty(school.getInvoice())) {
				model.addAttribute("code", -9046);
				log.info("parameter invoice is null or empty");
				return "/common/failure";
			}

			//qq
			if (String.valueOf(school.getQq()).length() > 20) {
				model.addAttribute("code", -9047);
				log.info("parameter qq is too long");
				return "/common/failure";
			}

			School oldSchool = schoolService.getObjectById(sid);
			school.setId(sid);

			//更新密码
			List<Long> newManagerIds = managerService.getManagerIdsByName(oldSchool.getMobile(), 0,
					Integer.MAX_VALUE);
			if (newManagerIds.size() > 0) {
				Manager manager = managerService.getObjectById(newManagerIds.get(0));
				manager.setPwd(school.getPwd());
				managerService.update(manager);
			}

            List<Long> managerIds = managerService.getManagerIdsByName(school.getMobile(), 0, Integer.MAX_VALUE);
			if (!oldSchool.getMobile().equals(school.getMobile())) {

				if (managerIds.size() > 0) {
					log.info(" manager name is exit ");
					model.addAttribute("code", -5019);
					return "/data/json";
				}
				//更新管理员
				List<Long> managerIdsNew = managerService.getManagerIdsByName(oldSchool.getMobile(), 0,
						Integer.MAX_VALUE);
				if (managerIdsNew.size() > 0) {
					Manager manager = managerService.getObjectById(managerIdsNew.get(0));
					manager.setName(school.getMobile());
					managerService.update(manager);
				}
			}

			school.setCreateBy(oldSchool.getCreateBy());
			school.setCreateAt(oldSchool.getCreateAt());
			school.setStatus(oldSchool.getStatus());

			school.setUpdateBy(mid);
			List<Long> classIdList = Arrays.asList(classes);

			//更新驾校
			schoolService.update(school);

			//更新驾校考务IM账号基本信息
			List<Long> imAccountIds = imAccountService.getIdByBelongIdAndBelongType(4, sid);
			Long accountId = null != imAccountIds && 0 != imAccountIds.size()
					? imAccountIds.get(imAccountIds.size() - 1)
					: null;
			ImAccount imAccount = imAccountService.getObjectById(accountId);

			if (null != imAccount) {
				boolean success = imChatUtil.updateSchoolManagerInfo(imAccount.getAccount(), school);

				if (success)
					log.info("success to update school manager im account info");
				else
					log.info("failed to update school manager im account info");
			}

			//更新关联的训练场,目前为一对一关系
			TrainingVenues trainingVenues = trainingVenuesService.getObjectById(school.getTrainingVenues());
			trainingVenues.setSchoolId(sid);
			trainingVenuesService.update(trainingVenues);

			Map<String, Object> svrMap = new HashMap<>();
			svrMap = DynamicUtil.getSchoolVenuesRelationIdBySchoolId(sid);
			List<Long> svrId = schoolVenuesRelationService.getIdsByDynamicCondition(SchoolVenuesRelation.class, svrMap,
					0, Integer.MAX_VALUE);
			log.info(svrId);
			log.info("get countSchoolVenuesRelationIdBySchoolId size is " + svrId.size());

			if (null != trainingVenues) {

				SchoolVenuesRelation schoolVenuesRelation = schoolVenuesRelationService.getObjectById(svrId.get(0));

				schoolVenuesRelation.setLocation(trainingVenues.getLocation());
				schoolVenuesRelation.setVenueId(trainingVenues.getId());
				schoolVenuesRelation.setVenueName(trainingVenues.getName());

				schoolVenuesRelation.setUpdateBy(mid);
				schoolVenuesRelationService.update(schoolVenuesRelation);
				log.info("更新训练场关联表成功");
			}

			//更新驾校-班型关联表
			List<DrivingClass> drivingClassList = drivingClassService.getObjectsByIds(classIdList);
			log.info("班级id" + classIdList);

			Map<String, Object> scrMap = new HashMap<>();
			scrMap = DynamicUtil.getSchoolClassRelationIdBySchoolId(sid);
			List<Long> scrId = schoolClassRelationService.getIdsByDynamicCondition(SchoolClassRelation.class, scrMap, 0,
					Integer.MAX_VALUE);
			log.info(scrId);
			log.info("get countSchoolClassRelationIdBySchoolId size is " + scrId.size());
			schoolClassRelationService.deleteList(SchoolClassRelation.class, scrId);

			List<SchoolClassRelation> schoolClassRelationList = new ArrayList<>();

			for (DrivingClass drivingClass : drivingClassList) {
				SchoolClassRelation schoolClassRelation = new SchoolClassRelation();
				schoolClassRelation.setUpdateBy(mid);
				schoolClassRelation.setCreateBy(mid);
				schoolClassRelation.setCityId(school.getCityId());
				schoolClassRelation.setClassId(drivingClass.getId());
				schoolClassRelation.setClassName(drivingClass.getName());
				schoolClassRelation.setSchoolName(school.getName());
				schoolClassRelation.setSchoolId(sid);
				schoolClassRelationList.add(schoolClassRelation);
			}
			schoolClassRelationService.insertList(schoolClassRelationList);
			log.info("关联班型成功");

			model.addAttribute("code", 0);

			model.addAttribute("school", school);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update school error,id is  " + school.getId());
			model.addAttribute("code", -100000);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/school", method = RequestMethod.POST)
	public String addSchoolJson(HttpServletRequest request, Long trainingVenuesId, HttpServletResponse response,
			ModelMap model, School school, @RequestParam(value = "classes") Long[] classes) throws Exception {

		log.info("insert school : school= " + school);
		log.info("classes= " + classes);

		//网易云IM即时通讯账号
		Long imAccountId = null;

		Long sid = null;

		try {
			Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
			double hundred = School.RATE_HUNDRED;

			double zero =  School.RATE_ZERO;

			BigDecimal hundredFinal = new BigDecimal(hundred);

			BigDecimal zeroFinal = new BigDecimal(zero);

			//阿里账号
			if (DataUtils.isNullOrEmpty(school.getAlipay())) {
				model.addAttribute("code", -9036);
				log.info("parameter alipay is null or empty");
				return "/common/failure";
			}
			//银行卡号
			if (DataUtils.isNullOrEmpty(school.getBackAccount())) {
				model.addAttribute("code", -9036);
				log.info("parameter backAccount is null or empty");
				return "/common/failure";
			}
			//持卡人
			if (DataUtils.isNullOrEmpty(school.getCardholder())) {
				model.addAttribute("code", -9037);
				log.info("parameter cardholder is null or empty");
				return "/common/failure";
			}
			//持卡人身份证
			if (DataUtils.isNullOrEmpty(school.getCardholderIdentify())) {
				model.addAttribute("code", -9034);
				log.info("parameter cardholderIdentify is null or empty");
				return "/common/failure";
			}
			//城市
			if (DataUtils.isNullOrEmpty(school.getCityId())) {
				model.addAttribute("code", -9038);
				log.info("parameter cityId is null or empty");
				return "/common/failure";
			}
			//合同
			if (DataUtils.isNullOrEmpty(school.getContract())) {
				model.addAttribute("code", -9039);
				log.info("parameter contract is null or empty");
				return "/common/failure";
			}
			//开户行
			if (DataUtils.isNullOrEmpty(school.getDepositBank())) {
				model.addAttribute("code", -9035);
				log.info("parameter depositBank is null or empty");
				return "/common/failure";
			}
			//名字
			if (DataUtils.isNullOrEmpty(school.getName())) {
				model.addAttribute("code", -9037);
				log.info("parameter name is null or empty");
				return "/common/failure";
			}
			//地址
			if (DataUtils.isNullOrEmpty(school.getLocation())) {
				model.addAttribute("code", -9040);
				log.info("parameter Location is null or empty");
				return "/common/failure";
			}
			//费率
			if (DataUtils.isNullOrEmpty(school.getRate())) {
				model.addAttribute("code", -9041);
				log.info("parameter rate is null or empty");
				return "/common/failure";
			}

			Double rate = Double.valueOf(school.getRate());
			BigDecimal rateB = new BigDecimal(rate);
			Integer max = rateB.compareTo(hundredFinal);
			Integer min = rateB.compareTo(zeroFinal);
			if (max.equals(1) || max.equals(0) || min.equals(0) || min.equals(-1)) {
				model.addAttribute("code", -23012);
				log.info("parameter rate is invaild");
				return "/common/failure";
			}
			//考务电话
			if (DataUtils.isNullOrEmpty(school.getHotline())) {
				model.addAttribute("code", -9042);
				log.info("parameter hotline is null or empty");
				return "/common/failure";
			}

			//密码
			if (DataUtils.isNullOrEmpty(school.getPwd())) {
				model.addAttribute("code", -9043);
				log.info("parameter Pwd is null or empty");
				return "/common/failure";
			} else {
				String encodePass = PasswordUtils.encode(school.getPwd());
				school.setPwd(encodePass);
			}
			//负责人
			if (DataUtils.isNullOrEmpty(school.getResPerson())) {
				model.addAttribute("code", -9037);
				log.info("parameter resPerson is null or empty");
				return "/common/failure";
			}
			//负责人电话
			if (DataUtils.isNullOrEmpty(school.getMobile())) {
				model.addAttribute("code", -9042);
				log.info("parameter mobile is null or empty");
				return "/common/failure";
			}
			List<Long> managerIds = managerService.getManagerIdsByName(school.getMobile(), 0, Integer.MAX_VALUE);
			log.info("manager name " + school.getMobile());
			if (managerIds.size() > 0) {
				log.info(" manager name is exit ");
				model.addAttribute("code", -5019);
				return "/data/json";
			}
			//预约说明
			if (DataUtils.isNullOrEmpty(school.getInstruction())) {
				model.addAttribute("code", -9044);
				log.info("parameter instruction is null or empty");
				return "/common/failure";
			}
			//训练场名字
			if (DataUtils.isNullOrEmpty(school.getTrainingVenuesName())) {
				model.addAttribute("code", -9045);
				log.info("parameter trainingVenuesName is null or empty");
				return "/common/failure";
			}
			//训练场
			if (DataUtils.isNullOrEmpty(school.getTrainingVenues())) {
				model.addAttribute("code", -9045);
				log.info("parameter TrainingVenues is null or empty");
				return "/common/failure";
			}
			//班级
			if (DataUtils.isNullOrEmpty(classes)) {
				model.addAttribute("code", -9025);
				log.info("parameter classes is null or empty");
				return "/common/failure";
			}
			//办公室电话
			if (DataUtils.isNullOrEmpty(school.getOfficeMobile())) {
				model.addAttribute("code", -9042);
				log.info("parameter officeMobile is null or empty");
				return "/common/failure";
			}
			//办公地址
			if (DataUtils.isNullOrEmpty(school.getAddress())) {
				model.addAttribute("code", -9040);
				log.info("parameter address is null or empty");
				return "/common/failure";
			}
			//发票
			if (DataUtils.isNullOrEmpty(school.getInvoice())) {
				model.addAttribute("code", -9046);
				log.info("parameter invoice is null or empty");
				return "/common/failure";
			}

			//qq
			if (String.valueOf(school.getQq()).length() > 20) {
				model.addAttribute("code", -9047);
				log.info("parameter qq too long ");
				return "/common/failure";
			}

			school.setCreateBy(mid);
			school.setUpdateBy(mid);
			school.setStatus(1);
			List<Long> classIdList = Arrays.asList(classes);
			school.setId(null);
			//插入学校
			sid = schoolService.insert(school);

			//创建网易云IM账号密码
			if (null != sid) {
				String accid = imChatUtil.getAccid(sid, ImChatUtil.AccidType.SCHOOL_MANAGER);
				String accidToken = null;
				String code = null;
				String message = null;
				Map<String, String> result = imChatUtil.createImAccount(accid);
				log.info("result is=="
						+ (null != result && 0 != result.size() ? Arrays.asList(result) : " null or size is zero"));

				code = result.get("code");
				if (code.equals("200")) {
					log.info("create im account success");
					accidToken = result.get("token");
					accid = result.get("accid");
					ImAccount imAccount = new ImAccount();
					imAccount.setAccount(accid);
					imAccount.setBelongId(sid);
					imAccount.setBelongtType(4);
					imAccount.setToken(accidToken);
					imAccount.setCreateAt(System.currentTimeMillis());
					imAccount.setCreateBy(sid);
					imAccount.setUpdateAt(System.currentTimeMillis());
					imAccount.setUpdateBy(sid);

					imAccountId = imAccountService.insert(imAccount);
					log.info("create im account success,insert to DB success");

					boolean success = imChatUtil.updateSchoolManagerInfo(accid, school);
					if (success)
						log.info("update school manager info success");
					else
						log.info("update school manager info failed");
				} else {
					message = result.get("message");
					log.info("create im account failed,see==" + message);
					schoolService.delete(sid);
					throw new Exception("register failed,cause create im account failed");
				}
			}

			//关联训练场
			TrainingVenues trainingVenues = trainingVenuesService.getObjectById(school.getTrainingVenues());


			if (null != trainingVenues) {
				trainingVenues.setSchoolId(sid);
				trainingVenuesService.update(trainingVenues);

				SchoolVenuesRelation schoolVenuesRelation = new SchoolVenuesRelation();
				schoolVenuesRelation.setSchoolId(sid);
				schoolVenuesRelation.setLocation(trainingVenues.getLocation());
				schoolVenuesRelation.setVenueId(trainingVenues.getId());
				schoolVenuesRelation.setVenueName(trainingVenues.getName());
				schoolVenuesRelation.setCreateBy(mid);
				schoolVenuesRelation.setUpdateBy(mid);
				schoolVenuesRelationService.insert(schoolVenuesRelation);
				log.info("关联训练场成功");
			}

			//关联班型
			List<DrivingClass> drivingClassList = drivingClassService.getObjectsByIds(classIdList);
			log.info("班级id" + classIdList);
			List<SchoolClassRelation> schoolClassRelationList = new ArrayList<>();
			for (DrivingClass drivingClass : drivingClassList) {
				SchoolClassRelation schoolClassRelation = new SchoolClassRelation();
				schoolClassRelation.setUpdateBy(mid);
				schoolClassRelation.setCreateBy(mid);
				schoolClassRelation.setCityId(school.getCityId());
				schoolClassRelation.setClassId(drivingClass.getId());
				schoolClassRelation.setClassName(drivingClass.getName());
				schoolClassRelation.setSchoolName(school.getName());
				schoolClassRelation.setSchoolId(sid);
				schoolClassRelationList.add(schoolClassRelation);
			}
			schoolClassRelationService.insertList(schoolClassRelationList);
			log.info("关联班型成功");
			model.addAttribute("code", 0);
			model.addAttribute("id", sid);
		} catch (Exception t) {
			t.printStackTrace();
			log.error("异常" + t.getMessage());
			log.error("add school error ");

			if (null != t.getMessage() && t.getMessage().equals("register failed,cause create im account failed")) {
				model.addAttribute("code", -26000);
			} else {
				model.addAttribute("code", -6002);
			}

			if (null != imAccountId)
				imAccountService.delete(imAccountId);

			if (null != sid)
				schoolService.delete(sid);
            model.addAttribute("code", -100000);
		}

		return "/data/json3";
	}

	@RequestMapping(value = "/a/u/school/{id}", method = RequestMethod.DELETE)
	public String deleteSchoolJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete school : id= " + id);
		try {
			schoolService.delete(id);

			log.info("add school success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete school error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/{status}/school/{id}", method = RequestMethod.PUT)
	public String changeSchoolStatusJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Integer status, @PathVariable Long id) throws Exception {

		log.info("delete school : id= " + id);
		try {
			School school = schoolService.getObjectById(id);
			school.setStatus(status);
			schoolService.update(school);
			log.info("add school success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete school error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	/**
	 * 获取cityId下指定类型的学校信息
	 * @param cityId
	 * @param type
	 * @return
	 */
	@RequestMapping(value = "/a/u/schools", method = RequestMethod.GET)
	public String getSchoolsByCityId(Long cityId, Integer type, Model model) {

		log.info("city id is==" + cityId + "	type is==" + type);
		boolean allParametersIsNotNull = ParametersUtil.allParametersIsNotNull(cityId, type);
		if (!allParametersIsNotNull) {
			log.info("parameters is null,end the request");
			model.addAttribute("code", -1000);
			return "yi-nucleus-service/school/json/schoolsListJsonByCityId";
		}
		boolean parametersIsIllegal = School.TYPE_OF_ADMIN != type && School.TYPE_OF_CITY != type && School.TYPE_OF_SCHOOL != type;
		if (parametersIsIllegal) {
			log.info("parameters is illegal,end the request");
			model.addAttribute("code", -1001);
			return "yi-nucleus-service/school/json/schoolsListJsonByCityId";
		}

		Map<String, Object> sqlInfo = null;
		List<Long> schoolIds = null;
		List<School> schoolList = null;
		try {
			sqlInfo = DynamicUtil.getSchoolIdsByCityIdAndType(cityId, type);
			schoolIds = null != sqlInfo
					? schoolService.getIdsByDynamicCondition(School.class, sqlInfo, 0, Integer.MAX_VALUE)
					: null;
			schoolList = null != schoolIds ? schoolService.getObjectsByIds(schoolIds) : null;

			model.addAttribute("code", 0);
			model.addAttribute("schoolList", schoolList);
		} catch (Exception e) {
			log.error("has an error,see==" + e);
			model.addAttribute("code", -100000);
		}

		return "yi-nucleus-service/school/json/schoolsListJsonByCityId";
	}
}
