package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.SchoolClassRelation;
import com.ptteng.yi.nucleus.service.DrivingClassService;
import com.ptteng.yi.nucleus.service.SchoolClassRelationService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * SchoolClassRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class SchoolClassRelationController {
	private static final Log log = LogFactory.getLog(SchoolClassRelationController.class);

	@Autowired
	private DrivingClassService drivingClassService;

	@Autowired
	private SchoolClassRelationService schoolClassRelationService;

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param schoolId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/school/class/list", method = RequestMethod.GET)
	public String getSchoolClassRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long schoolId) throws Exception {

		try {
			if (DataUtils.isNotNullOrEmpty(schoolId)) {
				List<Long> relationIds = schoolClassRelationService
						.getSchoolClassRelationIdsBySchoolIdOrderByCreateBy(schoolId, 0, Integer.MAX_VALUE);
				List<SchoolClassRelation> schoolClassRelationList = schoolClassRelationService
						.getObjectsByIds(relationIds);
				model.addAttribute("drivingClassList", schoolClassRelationList);
				model.addAttribute("code", 0);
			} else {
				model.addAttribute("code", -1000);
				log.info("parameter classes is null or empty");
				return "/common/failure";
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/schoolClassRelation/json/schoolClassRelationListJson";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param schoolClassRelation
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/school/class", method = RequestMethod.POST)
	public String addSchoolClassRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			SchoolClassRelation schoolClassRelation) throws Exception {

		log.info("update schoolClassRelation : schoolClassRelation= " + schoolClassRelation);

		try {
			schoolClassRelation.setId(null);

			schoolClassRelationService.insert(schoolClassRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add schoolClassRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/school/class/{id}", method = RequestMethod.DELETE)
	public String deleteSchoolClassRelationJson(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete schoolClassRelation : id= " + id);
		try {
			schoolClassRelationService.delete(id);

			log.info("add schoolClassRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete schoolClassRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

}
