package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Record;
import com.ptteng.yi.nucleus.service.RecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @Description: 包含驾校收支相关接口
 * @author: zhangxin
 * @Date: 2017-10-12
 */
@Controller
public class RecordController {
    private static final Log log = LogFactory.getLog(RecordController.class);

    @Resource
    private RecordService recordService;

    /**
     * 查询驾校收支列表接口
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/record/list", method = RequestMethod.GET)
    public String getRecordList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page,
            Integer size, Long startTime, Long endTime, Integer status, Long schoolId) throws Exception {
        //打印并设置page,size参数
        log.info("Interface GET /a/u/record/list, Method getRecordList() parameters, schoolId: " + schoolId
                + ", startTime: " + startTime + ", endTime: " + endTime + ", status: " + status);
        int actualSize = ParamsUtil.calculateActualSize(size);
        int startPosition = ParamsUtil.calculateStartPosition(page, actualSize);
        log.info("page: " + startPosition + " , size: " + size);

        int validateResult = ParamsUtil.checkParametersOfGetRecordList(schoolId, status);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            Map<String, Object> queryRecordMap = DynamicUtil.getRecordListParams(schoolId, startTime, endTime, status,
                    false);
            List<Long> recordIdList = recordService.getIdsByDynamicCondition(Record.class, queryRecordMap,
                    startPosition, actualSize);
            log.info("get record Id list, list is : " + recordIdList);

            List<Record> recordList = null;
            Long total = 0L;
            if (CollectionUtils.isNotEmpty(recordIdList)) {
                recordList = recordService.getObjectsByIds(recordIdList);
                log.info("get record list by Ids, list size is : " + recordList.size());

                Map<String, Object> countRecordMap = DynamicUtil.getRecordListParams(schoolId, startTime, endTime,
                        status, true);
                total = recordService.getIdsByDynamicCondition(Record.class, countRecordMap, 0, Integer.MAX_VALUE)
                        .get(0);
                log.info("get record list total is : " + total);
            }

            model.addAttribute("code", 0);
            model.addAttribute("size", actualSize);
            model.addAttribute("total", total);
            model.addAttribute("recordList", recordList);

            return "/yi-nucleus-service/record/json/recordListJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getRecordList() failed, page is : " + page + "size is : " + size);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }
}
