package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.Practice;
import com.ptteng.yi.nucleus.service.PracticeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Practice  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class PracticeController {
	private static final Log log = LogFactory.getLog(PracticeController.class);

	@Autowired
	private PracticeService practiceService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/practice", method = RequestMethod.GET)
	public String getpracticeList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/practice  to /practice/view/practiceList");

		return "/yi-nucleus-service/practice/view/practiceList";
	}

	@RequestMapping(value = "/c/practice/{id}", method = RequestMethod.GET)
	public String getPractice(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/practice/" + id + "  to /practice/view/practiceDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/practice/view/practiceDetail";
	}

	@RequestMapping(value = "/a/practice/{id}", method = RequestMethod.GET)
	public String getPracticeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Practice practice = practiceService.getObjectById(id);
			log.info("get practice data is " + practice);

			model.addAttribute("code", 0);

			model.addAttribute("practice", practice);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get practice error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/practice/json/practiceDetailJson";
	}

	@RequestMapping(value = "/a/practice/{id}", method = RequestMethod.PUT)
	public String updatePracticeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Practice practice) throws Exception {

		log.info("update practice : practice= " + practice);

		try {

			practiceService.update(practice);

			model.addAttribute("code", 0);

			model.addAttribute("practice", practice);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update practice error,id is  " + practice.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/practice", method = RequestMethod.POST)
	public String addPracticeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Practice practice) throws Exception {

		log.info("update practice : practice= " + practice);

		try {
			practice.setId(null);

			practiceService.insert(practice);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add practice error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/practice/{id}", method = RequestMethod.DELETE)
	public String deletePracticeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete practice : id= " + id);
		try {
			practiceService.delete(id);

			log.info("add practice success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete practice error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/practice", method = RequestMethod.GET)
	public String getMultiPracticeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Practice> practiceList = practiceService.getObjectsByIds(idList);
			log.info("get  practice data is " + practiceList);

			model.addAttribute("code", 0);
			model.addAttribute("total", practiceList.size());

			model.addAttribute("practiceList", practiceList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get practice error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/practice/json/practiceListJson";
	}

}
