package com.ptteng.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.pub.model.Message;
import com.ptteng.yi.pub.service.MessageService;

/**
 * Message  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class MessageController {
	private static final Log log = LogFactory.getLog(MessageController.class);

	@Autowired
	private MessageService messageService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/message", method = RequestMethod.GET)
	public String getmessageList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/message  to /message/view/messageList");

		return "/yi-public-service/message/view/messageList";
	}

	@RequestMapping(value = "/c/message/{id}", method = RequestMethod.GET)
	public String getMessage(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/message/" + id + "  to /message/view/messageDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-public-service/message/view/messageDetail";
	}

	@RequestMapping(value = "/a/message/{id}", method = RequestMethod.GET)
	public String getMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Message message = messageService.getObjectById(id);
			log.info("get message data is " + message);

			model.addAttribute("code", 0);

			model.addAttribute("message", message);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get message error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-public-service/message/json/messageDetailJson";
	}

	@RequestMapping(value = "/a/message/{id}", method = RequestMethod.PUT)
	public String updateMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Message message) throws Exception {

		log.info("update message : message= " + message);

		try {

			messageService.update(message);

			model.addAttribute("code", 0);

			model.addAttribute("message", message);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update message error,id is  " + message.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/message", method = RequestMethod.POST)
	public String addMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Message message) throws Exception {

		log.info("update message : message= " + message);

		try {
			message.setId(null);

			messageService.insert(message);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add message error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/message/{id}", method = RequestMethod.DELETE)
	public String deleteMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete message : id= " + id);
		try {
			messageService.delete(id);

			log.info("add message success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete message error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/message", method = RequestMethod.GET)
	public String getMultiMessageJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Message> messageList = messageService.getObjectsByIds(idList);
			log.info("get  message data is " + messageList);

			model.addAttribute("code", 0);
			model.addAttribute("total", messageList.size());

			model.addAttribute("messageList", messageList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get message error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-public-service/message/json/messageListJson";
	}

}
