package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.FreezeUser;
import com.ptteng.yi.nucleus.service.FreezeUserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * FreezeUser  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class FreezeUserController {
	private static final Log log = LogFactory.getLog(FreezeUserController.class);

	@Autowired
	private FreezeUserService freezeUserService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/freezeUser", method = RequestMethod.GET)
	public String getfreezeUserList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/freezeUser  to /freezeUser/view/freezeUserList");

		return "/yi-nucleus-service/freezeUser/view/freezeUserList";
	}

	@RequestMapping(value = "/c/freezeUser/{id}", method = RequestMethod.GET)
	public String getFreezeUser(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/freezeUser/" + id + "  to /freezeUser/view/freezeUserDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/freezeUser/view/freezeUserDetail";
	}

	@RequestMapping(value = "/a/freezeUser/{id}", method = RequestMethod.GET)
	public String getFreezeUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			FreezeUser freezeUser = freezeUserService.getObjectById(id);
			log.info("get freezeUser data is " + freezeUser);

			model.addAttribute("code", 0);

			model.addAttribute("freezeUser", freezeUser);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get freezeUser error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/freezeUser/json/freezeUserDetailJson";
	}

	@RequestMapping(value = "/a/freezeUser/{id}", method = RequestMethod.PUT)
	public String updateFreezeUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			FreezeUser freezeUser) throws Exception {

		log.info("update freezeUser : freezeUser= " + freezeUser);

		try {

			freezeUserService.update(freezeUser);

			model.addAttribute("code", 0);

			model.addAttribute("freezeUser", freezeUser);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update freezeUser error,id is  " + freezeUser.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/freezeUser", method = RequestMethod.POST)
	public String addFreezeUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			FreezeUser freezeUser) throws Exception {

		log.info("update freezeUser : freezeUser= " + freezeUser);

		try {
			freezeUser.setId(null);

			freezeUserService.insert(freezeUser);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add freezeUser error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/freezeUser/{id}", method = RequestMethod.DELETE)
	public String deleteFreezeUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete freezeUser : id= " + id);
		try {
			freezeUserService.delete(id);

			log.info("add freezeUser success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete freezeUser error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/freezeUser", method = RequestMethod.GET)
	public String getMultiFreezeUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<FreezeUser> freezeUserList = freezeUserService.getObjectsByIds(idList);
			log.info("get  freezeUser data is " + freezeUserList);

			model.addAttribute("code", 0);
			model.addAttribute("total", freezeUserList.size());

			model.addAttribute("freezeUserList", freezeUserList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get freezeUser error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/freezeUser/json/freezeUserListJson";
	}

}
