package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.Feedback;
import com.ptteng.yi.nucleus.service.FeedbackService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Feedback  crud
 * 
 * @author wangmeng
 * @Date 2018-1-4 13:43
 * 
 */
@Controller
public class FeedbackController {
    private static final Log log = LogFactory.getLog(FeedbackController.class);

    @Autowired
    private FeedbackService feedbackService;

    /**
     * 查看详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/feedback/{id}", method = RequestMethod.GET)
    public String getFeedbackJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {

        log.info("GET request url : /a/u/feedback/{id}, get path variable id : " + id);

        try {
            Feedback feedback = feedbackService.getObjectById(id);
            log.info("get feedback data is " + feedback);

            if (DataUtils.isNullOrEmpty(feedback)) {
                log.info("no this feedback");
                model.addAttribute("code", -14000);
                return "/common/failure";
            }

            model.addAttribute("code", 0);

            model.addAttribute("feedback", feedback);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get feedback error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/feedback/json/feedbackDetailJson";
    }

    /**
     * 删除
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/feedback/{id}", method = RequestMethod.DELETE)
    public String deleteFeedbackJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {

        log.info("DELETE request url : /a/u/feedback/{id}, get path variable id : " + id);

        try {
            feedbackService.delete(id);

            log.info("delete feedback success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete feedback error,id is  " + id);
            model.addAttribute("code", -100000);

        }

        return "/common/success";
    }

    /**
     * 查询列表
     * @param request
     * @param response
     * @param model
     * @param userMobile 用户手机号
     * @param name 用户名
     * @param source 来源
     * @param submitStart 提交时间起
     * @param submitEnd 提交时间止
     * @param cityId 城市id
     * @param page
     * @param size
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/feedback/list", method = RequestMethod.GET)
    public String getMultiFeedbackJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            String userMobile, String name, Integer source, Long submitStart, Long submitEnd, Long cityId, Integer page,
            Integer size) throws Exception {

        log.info("GET request url: /a/u/feedback/list, get parameter userMobile: " + userMobile + ", name: " + name
                + ", source: " + source + ", submitStart: " + submitStart + ", submitEnd: " + submitEnd + ", cityId: "
                + cityId + ", page: " + page + ", size: " + size);

        if (DataUtils.isNullOrEmpty(cityId)) {
            log.info("parameter cityId is null or empty");
            model.addAttribute("code", -10027);
            return "/common/failure";
        }

        if (cityId < 1L) {
            log.info("parameter cityId is illegal");
            model.addAttribute("code", -10028);
            return "/common/failure";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> map = DynamicUtil.getFeedbackListParams(userMobile, name, source, submitStart,
                    submitEnd, cityId, false);
            log.info("query feedback map : " + map);

            List<Long> ids = feedbackService.getIdsByDynamicCondition(Feedback.class, map, start, size);
            log.info("get feedback id list : " + ids);

            Integer total = feedbackService.getIdsByDynamicCondition(Feedback.class, map, 0, Integer.MAX_VALUE).size();

            if (CollectionUtils.isEmpty(ids)) {
                model.addAttribute("feedbackList", new ArrayList());
            } else {
                List<Feedback> feedbackList = feedbackService.getObjectsByIds(ids);
                log.info("get feedback list size is " + feedbackList.size());
                model.addAttribute("feedbackList", feedbackList);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get feedback list error, start is  " + start + " , size " + size);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/feedback/json/feedbackListJson";
    }

}
