package com.ptteng.controller;

import com.ptteng.model.Constants;
import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.DrivingClass;
import com.ptteng.yi.nucleus.model.SchoolClassRelation;
import com.ptteng.yi.nucleus.service.DrivingClassService;
import com.ptteng.yi.nucleus.service.SchoolClassRelationService;
import com.ptteng.yi.nucleus.service.SchoolService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

import static com.ptteng.model.Constants.appShow;
import static com.ptteng.model.Constants.status;

/**
 * DrivingClass  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class DrivingClassController {
	private static final Log log = LogFactory.getLog(DrivingClassController.class);

	@Autowired
	private DrivingClassService drivingClassService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private SchoolClassRelationService schoolClassRelationService;
	@Autowired
	private SchoolService schoolService;

	/**
	 *查看班型列表(入参没有判空)
	 * @param request
	 * @param response
	 * @param model
	 * @param cityId
	 * @param page
	 * @param size
	 * @param type
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/class/list ", method = RequestMethod.GET)
	public String getDrivingClassIdsByStatusOrderByCreateByJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long cityId, Integer page, Integer size, Integer type)
			throws Exception {
		log.info("cithId is =====" + cityId);
		try {
			if (page == null) {
				page = 1;
			}
			if (size == null) {
				size = 10;
			}
			int start = (page - 1) * size;
			if (start < 0) {
				start = 0;
			}
			List<Long> ids = new ArrayList<Long>();
			List<DrivingClass> classList = new ArrayList<DrivingClass>();
			List<Long> rids = new ArrayList<Long>();
			if (DataUtils.isNullOrEmpty(cityId)) {
				model.addAttribute("code", -1000);
				log.info("parameter classes is null or empty");
				return "/common/failure";
			}
			Map<String, Object> map = new HashMap<>();
			if (Constants.appList.equals(type)) {
				map = DynamicUtil.getDrivingClassIdsByCityIdAndStatusAndShowingcae(cityId, status, appShow);
			} else if (Constants.classList.equals(type)) {
				map = DynamicUtil.getDrivingClassIdsByCityId(cityId);
			}

			log.info("map is === " + map);
			ids = drivingClassService.getIdsByDynamicCondition(DrivingClass.class, map, start, size);
			classList = drivingClassService.getObjectsByIds(ids);
			log.info(classList);
			Integer total = drivingClassService.getIdsByDynamicCondition(DrivingClass.class, map, 0, Integer.MAX_VALUE)
					.size();
			Map<String, Object> rmap = DynamicUtil.getSchoolClassRelationByClassId(ids);
			log.info("query creator map = " + rmap);
			rids = schoolClassRelationService.getIdsByDynamicCondition(SchoolClassRelation.class, rmap, 0,
					Integer.MAX_VALUE);
			List<SchoolClassRelation> SchoolClassRelationList = schoolClassRelationService.getObjectsByIds(rids);
			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("drivingClassList", classList);
			model.addAttribute("schoolList", SchoolClassRelationList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/drivingClass/json/drivingClassListJson";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/class/{id}", method = RequestMethod.GET)
	public String getDrivingClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {

			DrivingClass drivingClass = drivingClassService.getObjectById(id);
			log.info("get drivingClass data is " + drivingClass);

			model.addAttribute("code", 0);

			model.addAttribute("drivingClass", drivingClass);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get drivingClass error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/drivingClass/json/drivingClassDetailJson";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param drivingClass
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/class/{id}", method = RequestMethod.PUT)
	public String updateDrivingClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			DrivingClass drivingClass, @PathVariable Long id) throws Exception {

		log.info("update drivingClass : drivingClass= " + drivingClass);

		try {
			Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
			DrivingClass eDrivingClass = drivingClassService.getObjectById(id);

			//服务承诺
			if (DataUtils.isNotNullOrEmpty(drivingClass.getCommitment())) {
				eDrivingClass.setCommitment(drivingClass.getCommitment());
			}
			//班名
			if (DataUtils.isNotNullOrEmpty(drivingClass.getName())) {
				eDrivingClass.setName(drivingClass.getName());
			}
			//费用
			if (DataUtils.isNotNullOrEmpty(drivingClass.getCost())) {
				eDrivingClass.setCost(drivingClass.getCost());
			}
			//费用明细
			if (DataUtils.isNotNullOrEmpty(drivingClass.getCostDetail())) {
				eDrivingClass.setCostDetail(drivingClass.getCostDetail());
			}
			//车型
			if (DataUtils.isNotNullOrEmpty(drivingClass.getCar())) {
				eDrivingClass.setCar(drivingClass.getCar());
			}
			//详情图片
			if (DataUtils.isNotNullOrEmpty(drivingClass.getDetailImg())) {
				eDrivingClass.setDetailImg(drivingClass.getDetailImg());
			}
			//科三课时
			if (DataUtils.isNotNullOrEmpty(drivingClass.getSubjectThreeHour())) {
				eDrivingClass.setSubjectThreeHour(drivingClass.getSubjectThreeHour());
			}
			//科三人数
			if (DataUtils.isNotNullOrEmpty(drivingClass.getSubjectThreeNumbers())) {
				eDrivingClass.setSubjectThreeNumbers(drivingClass.getSubjectThreeNumbers());
			}
			//科二课时
			if (DataUtils.isNotNullOrEmpty(drivingClass.getSubjectTwoHour())) {
				eDrivingClass.setSubjectTwoHour(drivingClass.getSubjectTwoHour());
			}
			//科二人数
			if (DataUtils.isNotNullOrEmpty(drivingClass.getSubjectTwoNumbers())) {
				eDrivingClass.setSubjectTwoNumbers(drivingClass.getSubjectTwoNumbers());
			}
			//班型描述
			if (DataUtils.isNotNullOrEmpty(drivingClass.getIntro())) {
				eDrivingClass.setIntro(drivingClass.getIntro());
			}
			//keyongchexing
			if (DataUtils.isNotNullOrEmpty(drivingClass.getAllowModels())) {
				eDrivingClass.setAllowModels(drivingClass.getAllowModels());
			}
			//列表图片
			if (DataUtils.isNotNullOrEmpty(drivingClass.getListImg())) {
				eDrivingClass.setListImg(drivingClass.getListImg());
			}
			eDrivingClass.setUpdateBy(mid);
			drivingClassService.update(eDrivingClass);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update drivingClass error,id is  " + drivingClass.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param drivingClass
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/class", method = RequestMethod.POST)
	public String addDrivingClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			DrivingClass drivingClass) throws Exception {

		log.info("update drivingClass : drivingClass= " + drivingClass);
		//城市
		if (DataUtils.isNullOrEmpty(drivingClass.getCityId())) {
			model.addAttribute("code", -1000);
			log.info("getCityId is null or empty");
			return "/common/failure";
		}
		//服务承诺
		if (DataUtils.isNullOrEmpty(drivingClass.getCommitment())) {
			model.addAttribute("code", -1000);
			log.info("getCommitment is null or empty");
			return "/common/failure";
		}
		//班名
		if (DataUtils.isNullOrEmpty(drivingClass.getName())) {
			model.addAttribute("code", -1000);
			log.info("getName is null or empty");
			return "/common/failure";
		}
		//费用
		if (DataUtils.isNullOrEmpty(drivingClass.getCost())) {
			model.addAttribute("code", -1000);
			log.info("getCost is null or empty");
			return "/common/failure";
		}
		//费用明细
		if (DataUtils.isNullOrEmpty(drivingClass.getCostDetail())) {
			model.addAttribute("code", -1000);
			log.info("getCostDetail is null or empty");
			return "/common/failure";
		}
		//车型
		if (DataUtils.isNullOrEmpty(drivingClass.getCar())) {
			model.addAttribute("code", -1000);
			log.info("getCar is null or empty");
			return "/common/failure";
		}
		//准驾车型
		if (DataUtils.isNullOrEmpty(drivingClass.getAllowModels())) {
			model.addAttribute("code", -1000);
			log.info("getAllowModels is null or empty");
			return "/common/failure";
		}
		//详情图片
		if (DataUtils.isNullOrEmpty(drivingClass.getDetailImg())) {
			model.addAttribute("code", -1000);
			log.info("getDetailImg is null or empty");
			return "/common/failure";
		}
		//科三课时
		if (DataUtils.isNullOrEmpty(drivingClass.getSubjectThreeHour())) {
			model.addAttribute("code", -1000);
			log.info("getSubjectThreeHour is null or empty");
			return "/common/failure";
		}
		//科三人数
		if (DataUtils.isNullOrEmpty(drivingClass.getSubjectThreeNumbers())) {
			model.addAttribute("code", -1000);
			log.info("getSubjectThreeNumbers is null or empty");
			return "/common/failure";
		}
		//科二课时
		if (DataUtils.isNullOrEmpty(drivingClass.getSubjectTwoHour())) {
			model.addAttribute("code", -1000);
			log.info("getSubjectTwoHour is null or empty");
			return "/common/failure";
		}
		//科二人数
		if (DataUtils.isNullOrEmpty(drivingClass.getSubjectTwoNumbers())) {
			model.addAttribute("code", -1000);
			log.info("getSubjectTwoNumbers is null or empty");
			return "/common/failure";
		}
		//班型描述
		if (DataUtils.isNullOrEmpty(drivingClass.getIntro())) {
			model.addAttribute("code", -1000);
			log.info("getIntro is null or empty");
			return "/common/failure";
		}
		//列表图片
		if (DataUtils.isNullOrEmpty(drivingClass.getListImg())) {
			model.addAttribute("code", -1000);
			log.info("getListImg is null or empty");
			return "/common/failure";
		}
		try {

			Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
			log.info(mid);

			drivingClass.setCreateBy(mid);
			drivingClass.setUpdateBy(mid);
			drivingClassService.insert(drivingClass);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add drivingClass error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/class/{id}", method = RequestMethod.DELETE)
	public String deleteDrivingClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete drivingClass : id= " + id);
		try {
			drivingClassService.delete(id);

			log.info("add drivingClass success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete drivingClass error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/status/{status}/class/{id}", method = RequestMethod.PUT)
	public String changeStatusClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, @PathVariable int status) throws Exception {

		log.info("status drivingClass : status= " + status);

		if (DataUtils.isNullOrEmpty(status)) {
			model.addAttribute("code", -1000);
			log.info("status is null or empty");
			return "/common/failure";
		}
		try {

			DrivingClass drivingClass = drivingClassService.getObjectById(id);
			drivingClass.setStatus(status);
			log.info(drivingClass);
			drivingClassService.update(drivingClass);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete drivingClass error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @param showingcase
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/appshowing/{showingcase}/class/{id}", method = RequestMethod.PUT)
	public String changeAppClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, @PathVariable int showingcase) throws Exception {

		log.info("showingcase drivingClass : showingcase= " + showingcase);

		if (DataUtils.isNullOrEmpty(showingcase)) {
			model.addAttribute("code", -1000);
			log.info("showingcase is null or empty");
			return "/common/failure";
		}
		try {

			DrivingClass drivingClass = drivingClassService.getObjectById(id);

			drivingClass.setShowcasing(showingcase);
			drivingClassService.update(drivingClass);

			log.info("add drivingClass success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete drivingClass error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/multi/drivingClass", method = RequestMethod.GET)
	public String getMultiDrivingClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<DrivingClass> drivingClassList = drivingClassService.getObjectsByIds(idList);
			log.info("get  drivingClass data is " + drivingClassList);

			model.addAttribute("code", 0);
			model.addAttribute("total", drivingClassList.size());

			model.addAttribute("drivingClassList", drivingClassList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get drivingClass error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/drivingClass/json/drivingClassListJson";
	}

}
