package com.ptteng.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.util.DynamicUtil;
import com.ptteng.util.TimeUtil;
import com.ptteng.yi.nucleus.model.AdvanceTime;
import com.ptteng.yi.nucleus.model.CoachAppointTime;
import com.ptteng.yi.nucleus.service.AdvanceTimeService;
import com.ptteng.yi.nucleus.service.CoachAppointTimeService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.Constant;
import com.ptteng.yi.nucleus.service.ConstantService;

/**
 * Constant  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ConstantController {
    private static final Log log = LogFactory.getLog(ConstantController.class);

    @Autowired
    private ConstantService constantService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private CoachAppointTimeService coachAppointTimeService;

    @Autowired
    private AdvanceTimeService advanceTimeService;

    /**
     * 查询驾校常量
     */
    @RequestMapping(value = "/a/u/school/constant", method = RequestMethod.GET)
    public String getConstantForSchool(Long schoolId, ModelMap model) {

        log.info("get schoolId :" + schoolId);

        try {
            Integer type = 2;

            Map<String, Object> haveMap = new HashMap<>();
            haveMap = DynamicUtil.getConstantByTypeAndId(type, schoolId);
            List<Long> conId = constantService.getIdsByDynamicCondition(Constant.class, haveMap, 0, Integer.MAX_VALUE);
            log.info("get id count :" + conId.size());

            Constant constant = new Constant();

            if (conId.size() > 0) {
                constant = constantService.getObjectById(conId.get(0));

            }
            log.info("get constant is : " + constant);

            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get schoolId error,id is  " + schoolId);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/constant/json/constantDetailJson";
    }

    /**
     * 添加 或 更新 驾校 开放预约天数
     */

    @RequestMapping(value = "/a/u/school/constant/day", method = RequestMethod.POST)
    public String setDayForSchool(ModelMap model, Long constantId, Long day, Long schoolId,
            HttpServletRequest request) {

        log.info("get schoolId :" + constantId);

        try {
            //天数
            if (DataUtils.isNullOrEmpty(day)) {
                model.addAttribute("code", -9048);
                log.info("parameter day is null or empty");
                return "/common/failure";
            }
            //驾校id
            if (DataUtils.isNullOrEmpty(schoolId)) {
                model.addAttribute("code", -9049);
                log.info("parameter schoolId is null or empty");
                return "/common/failure";
            }

            Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

            Constant constant = constantService.getObjectById(constantId);

            //添加
            if (null == constant) {
                constant = new Constant();
                constant.setDay(day);

                constant.setTargetId(schoolId);
                constant.setType(2);

                constant.setCreateBy(mid);
                constant.setUpdateBy(mid);

                Long id = constantService.insert(constant);
                constant.setId(id);

                log.info("insert constant is : " + constant);
            }
            //修改
            else {
                constant.setDay(day);

                constant.setUpdateBy(mid);
                constantService.update(constant);

                log.info("update constant is : " + constant);
            }

            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get schoolId error,id is  " + schoolId);
            log.error("get constantId error,id is  " + constantId);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/constant/json/constantDetailJson";
    }

    /**
     * 添加 或 更新 驾校 预约时间范围
     */
    @RequestMapping(value = "/a/u/school/constant/time", method = RequestMethod.POST)
    public String setTimeForSchool(ModelMap model, Long constantId, HttpServletRequest request, Long schoolId,
            Long timeStart, Long timeEnd) {

        log.info("get schoolId :" + constantId);

        try {

            if (DataUtils.isNullOrEmpty(schoolId)) {
                model.addAttribute("code", -9049);
                log.info("parameter schoolId is null or empty");
                return "/common/failure";
            }

            if (DataUtils.isNullOrEmpty(timeStart) || DataUtils.isNullOrEmpty(timeEnd)) {
                model.addAttribute("code", -9050);
                log.info("parameter timeStart or timeEnd is null or empty");
                return "/common/failure";
            }

            Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

            Constant constant = constantService.getObjectById(constantId);
            //添加
            if (null == constant) {
                constant = new Constant();
                constant.setTimeStart(timeStart);
                constant.setTimeEnd(timeEnd);

                constant.setTargetId(schoolId);
                constant.setType(2);

                constant.setCreateBy(mid);
                constant.setUpdateBy(mid);

                Long id = constantService.insert(constant);
                constant.setId(id);

                log.info("insert constant is : " + constant);
            }
            //修改
            else {
                constant.setTimeStart(timeStart );
                constant.setTimeEnd(timeEnd );

                constant.setUpdateBy(mid);
                constantService.update(constant);

                log.info("update constant is : " + constant);
            }

            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get schoolId error,id is  " + schoolId);

            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/constant/json/constantDetailJson";
    }



    /**
     * 运营中心，查询 - 是否强制评价
     */
    @RequestMapping(value = "/a/u/center/constant/evaluate", method = RequestMethod.GET)
    public String getEvaluateForCenter(ModelMap model, Long cityId) {

        log.info("get cityId :" + cityId);

        try {
            //类型，运营中心：1
            Integer type = 1;

            Map<String, Object> haveMap = new HashMap<>();
            haveMap = DynamicUtil.getConstantByTypeAndId(type, cityId);
            List<Long> conId = constantService.getIdsByDynamicCondition(Constant.class, haveMap, 0, Integer.MAX_VALUE);
            log.info("get id count :" + conId.size());

            Constant constant = new Constant();

            if (conId.size() > 0) {
                constant = constantService.getObjectById(conId.get(0));

                log.info("get constant is : " + constant);
            }

            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);

        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            log.error(" select error, cityId is  " + cityId);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/constant/json/constantDetailJson";
    }

    /**
     * 运营中心，修改 / 添加 ，是否强制评价
     * evaluate,0:是，1：否
     */
    @RequestMapping(value = "/a/u/center/constant/evaluate", method = RequestMethod.POST)
    public String setEvaluateForCenter(ModelMap model, Long constantId, Long cityId, Integer evaluate,
            HttpServletRequest request) {

        log.info("get cityId :" + cityId);
        log.info("get constantId :" + constantId);
        log.info("get evaluate:" + evaluate);

        try {

            if (DataUtils.isNullOrEmpty(cityId)) {
                model.addAttribute("code", -9049);
                log.info("parameter cityId is null or empty");
                return "/common/failure";
            }

            if (DataUtils.isNullOrEmpty(evaluate)) {
                model.addAttribute("code", -1000);
                log.info("parameter evaluate is null or empty");
                return "/common/failure";
            }

            Integer type = 1;

            Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

            Constant constant = constantService.getObjectById(constantId);
            log.info("get constant is : " + constant);

            //添加
            if (null == constant) {
                constant = new Constant();

                constant.setType(type);
                constant.setEvaluate(evaluate);
                constant.setTargetId(cityId);

                constant.setCreateBy(mid);
                constant.setUpdateBy(mid);

                Long id = constantService.insert(constant);
                constant.setId(id);

                log.info("insert constant is : " + constant + " and id is : " + id);
            }
            //修改
            else {
                constant.setEvaluate(evaluate);

                constant.setUpdateBy(mid);
                constantService.update(constant);
                log.info("update constant is : " + constant);
            }

            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);

        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            log.error(" select error, cityId is  " + cityId);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/constant/json/constantDetailJson";
    }

    /**
     * 运营中心，查询 - 预约时间
     */
    @RequestMapping(value = "/a/u/center/constant/time", method = RequestMethod.GET)
    public String getConstantForCenter(Long cityId, ModelMap model, Integer type) {

        log.info(" cityId " + cityId);
        if (DataUtils.isNullOrEmpty(cityId)) {
            model.addAttribute("code", -21001);
            log.info("cityId is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(type)) {
            model.addAttribute("code", -17002);
            log.info("cityId is null or empty");
            return "/common/failure";
        }

        try {

            List<Long> ids = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndCityIdAndType(
                    CoachAppointTime.COACHADVANCETIME_STATUS_YES, cityId, type, 0, Integer.MAX_VALUE);

            List<CoachAppointTime> coachAppointTimeList = coachAppointTimeService.getObjectsByIds(ids);
            log.info(" coachAppointTimeList is : " + coachAppointTimeList);

            CoachAppointTime coachAppointTime = new CoachAppointTime();

            List<AdvanceTime> advanceTimeList = new ArrayList<>();

            List<AdvanceTime> twoTimeList = new ArrayList<>();
            List<AdvanceTime> threeTimeList = new ArrayList<>();

            Integer idsSize = ids.size();
            if (!idsSize.equals(0)) {
                coachAppointTime = coachAppointTimeList.get(0);

                Map<String, Object> map = DynamicUtil.getAppointTimeList(coachAppointTime.getId(),
                        AdvanceTime.ADVANCE_TIME_STATUS_ON);

                List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, 0,
                        Integer.MAX_VALUE);

                advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
                log.info(" advanceTimeList is : " + advanceTimeList);
            }

            for (int i = 0; i < advanceTimeList.size(); i++) {
                AdvanceTime advanceTime = advanceTimeList.get(i);
                Integer subject = advanceTime.getSubject();
                if (subject.equals(AdvanceTime.TWO_SUBJECT)) {
                    twoTimeList.add(advanceTime);
                }
                if (subject.equals(AdvanceTime.THREE_SUBJECT)) {
                    threeTimeList.add(advanceTime);
                }
            }

            log.info(" twoTimeList is : " + twoTimeList);
            log.info(" threeTimeList is : " + threeTimeList);

            model.addAttribute("twoTimeList", twoTimeList);
            model.addAttribute("threeTimeList", threeTimeList);
            model.addAttribute("coachAppointTime", coachAppointTime);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete coach error,cityId is  " + cityId);
            model.addAttribute("code", -100000);

        }

        return "/yi-nucleus-service/constant/json/centerConstant";
    }

    /**
     * 运营中心，新增 / 修改  - 预约时间
     */
    @RequestMapping(value = "/a/u/center/constant/time", method = RequestMethod.POST)
    public String setConstantForCenter(ModelMap model, CoachAppointTime coachAppointTime, String twoTimeList,
            String threeTimeList, Long cityId, Integer evaluate) {

        log.info("coachAppointTime is " + coachAppointTime);
        log.info("twoTimeList is " + twoTimeList);
        log.info("threeTimeList is " + threeTimeList);

        if (DataUtils.isNullOrEmpty(coachAppointTime.getType())) {
            model.addAttribute("code", -23016);
            log.info("getType is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(coachAppointTime.getTwoAdvanceTime())) {
            model.addAttribute("code", -23018);
            log.info("getTwoAdvanceTime is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(coachAppointTime.getTwoAppointFrequency())) {
            model.addAttribute("code", -23019);
            log.info("getTwoAppointFrequency is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(coachAppointTime.getTwoRest())) {
            model.addAttribute("code", -23020);
            log.info("getTwoRest is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(twoTimeList)) {
            model.addAttribute("code", -23021);
            log.info("twoTimeList is null or empty");
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(coachAppointTime.getThreeAdvanceTime())) {
            model.addAttribute("code", -23022);
            log.info("getThreeAdvanceTime is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(coachAppointTime.getThreeAppointFrequency())) {
            model.addAttribute("code", -23023);
            log.info("getThreeAppointFrequency is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(threeTimeList)) {
            model.addAttribute("code", -23025);
            log.info("threeTimeList is null or empty");
            return "/common/failure";
        }

        //验证json格式
        try {
            AdvanceTimeEPRList(twoTimeList, -1L, AdvanceTime.TWO_SUBJECT);
            AdvanceTimeEPRList(threeTimeList, -1L, AdvanceTime.THREE_SUBJECT);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("add coachAppointTime error");
            model.addAttribute("code", -1001);
            return "/common/failure";
        }

        try {

            List<Long> coachAppointTimeIds = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndCityIdAndType(
                    CoachAppointTime.COACHADVANCETIME_STATUS_YES, cityId, coachAppointTime.getType(), 0,
                    Integer.MAX_VALUE);

            log.info("coachAppointTimeIds ======" + coachAppointTimeIds);
            log.info("coachAppointTimeIds size ====" + coachAppointTimeIds.size());

            //新增
            if (coachAppointTimeIds.size() == 0) {

                CoachAppointTime newCoachAppointTime = coachAppointTime;

                //教练id：0
                newCoachAppointTime.setCoachId(0L);

                newCoachAppointTime.setCityId(cityId);


                newCoachAppointTime.setStatus(CoachAppointTime.COACHADVANCETIME_STATUS_YES);
                log.info("newCoachAppointTime is " + newCoachAppointTime);
                Long id = coachAppointTimeService.insert(newCoachAppointTime);

                //关联，时间段表
                List<AdvanceTime> newTwoTimeList = AdvanceTimeEPRList(twoTimeList, id, AdvanceTime.TWO_SUBJECT);
                List<AdvanceTime> newThreeTimeList = AdvanceTimeEPRList(threeTimeList, id, AdvanceTime.THREE_SUBJECT);

                log.info("newTwoTimeList ===" + newTwoTimeList);
                log.info("newThreeTimeList ===" + newThreeTimeList);
                advanceTimeService.insertList(newTwoTimeList);
                advanceTimeService.insertList(newThreeTimeList);

            }

            //更新
            else {

                CoachAppointTime old = coachAppointTimeService.getObjectById(coachAppointTimeIds.get(0));

                Long id = old.getId();
                coachAppointTime.setCoachId(old.getCoachId());

                coachAppointTime.setId(old.getId());

                coachAppointTime.setCreateAt(old.getCreateAt());
                coachAppointTime.setStatus(CoachAppointTime.COACHADVANCETIME_STATUS_YES);

                log.info("coachAppointTime ===" + coachAppointTime);
                coachAppointTimeService.update(coachAppointTime);

                //下架
                Map<String, Object> map = DynamicUtil.getAppointTimeList(id, AdvanceTime.ADVANCE_TIME_STATUS_ON);
                List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, 0,
                        Integer.MAX_VALUE);
                List<AdvanceTime> advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
                for (int i = 0; i < advanceTimeList.size(); i++) {
                    //                    advanceTimeService.deleteList(AdvanceTime.class,advanceTimeIds);
                    AdvanceTime newAdvanceTime = advanceTimeList.get(i);
                    newAdvanceTime.setStatus(AdvanceTime.ADVANCE_TIME_STATUS_OFF);
                    advanceTimeService.update(newAdvanceTime);
                }

                //关联，时间段表
                List<AdvanceTime> newTwoTimeList = AdvanceTimeEPRList(twoTimeList, id, AdvanceTime.TWO_SUBJECT);
                List<AdvanceTime> newThreeTimeList = AdvanceTimeEPRList(threeTimeList, id, AdvanceTime.THREE_SUBJECT);

                log.info("newTwoTimeList ===" + newTwoTimeList);
                log.info("newThreeTimeList ===" + newThreeTimeList);
                advanceTimeService.insertList(newTwoTimeList);
                advanceTimeService.insertList(newThreeTimeList);
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add coachAppointTime error");
            model.addAttribute("code", -100000);

        }

        return "/data/json";
    }

    public static List<AdvanceTime> AdvanceTimeEPRList(String threeTimeList, Long id, int subject) {
        List<AdvanceTime> advanceTimeList = new ArrayList<>();
        JSONArray newThreeTimeList = JSONArray.fromObject(threeTimeList);
        for (int i = 0; i < newThreeTimeList.size(); i++) {
            JSONObject jsonObject = newThreeTimeList.getJSONObject(i);
            AdvanceTime advanceTime = new AdvanceTime();
            advanceTime.setCoachTimeId(id);
            advanceTime.setNum(jsonObject.getLong("num"));
            advanceTime.setStartTime(jsonObject.getLong("timeStart"));
            advanceTime.setEndTime(jsonObject.getLong("timeEnd"));
            advanceTime.setSubject(subject);
            advanceTime.setStatus(AdvanceTime.ADVANCE_TIME_STATUS_ON);
            log.info("advanceTime ======" + advanceTime);
            advanceTimeList.add(advanceTime);
        }

        return advanceTimeList;

    }


}
