package com.ptteng.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.CoachRecommend;
import com.ptteng.yi.nucleus.service.CoachRecommendService;

/**
 * CoachRecommend  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CoachRecommendController {
	private static final Log log = LogFactory.getLog(CoachRecommendController.class);

	@Autowired
	private CoachRecommendService coachRecommendService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/coachRecommend", method = RequestMethod.GET)
	public String getcoachRecommendList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/coachRecommend  to /coachRecommend/view/coachRecommendList");

		return "/yi-nucleus-service/coachRecommend/view/coachRecommendList";
	}

	@RequestMapping(value = "/c/coachRecommend/{id}", method = RequestMethod.GET)
	public String getCoachRecommend(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/coachRecommend/" + id + "  to /coachRecommend/view/coachRecommendDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/coachRecommend/view/coachRecommendDetail";
	}

	@RequestMapping(value = "/a/coachRecommend/{id}", method = RequestMethod.GET)
	public String getCoachRecommendJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			CoachRecommend coachRecommend = coachRecommendService.getObjectById(id);
			log.info("get coachRecommend data is " + coachRecommend);

			model.addAttribute("code", 0);

			model.addAttribute("coachRecommend", coachRecommend);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get coachRecommend error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/coachRecommend/json/coachRecommendDetailJson";
	}

	@RequestMapping(value = "/a/coachRecommend/{id}", method = RequestMethod.PUT)
	public String updateCoachRecommendJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			CoachRecommend coachRecommend) throws Exception {

		log.info("update coachRecommend : coachRecommend= " + coachRecommend);

		try {

			coachRecommendService.update(coachRecommend);

			model.addAttribute("code", 0);

			model.addAttribute("coachRecommend", coachRecommend);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update coachRecommend error,id is  " + coachRecommend.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/coachRecommend", method = RequestMethod.POST)
	public String addCoachRecommendJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			CoachRecommend coachRecommend) throws Exception {

		log.info("update coachRecommend : coachRecommend= " + coachRecommend);

		try {
			coachRecommend.setId(null);

			coachRecommendService.insert(coachRecommend);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add coachRecommend error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/coachRecommend/{id}", method = RequestMethod.DELETE)
	public String deleteCoachRecommendJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete coachRecommend : id= " + id);
		try {
			coachRecommendService.delete(id);

			log.info("add coachRecommend success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete coachRecommend error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/coachRecommend", method = RequestMethod.GET)
	public String getMultiCoachRecommendJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<CoachRecommend> coachRecommendList = coachRecommendService.getObjectsByIds(idList);
			log.info("get  coachRecommend data is " + coachRecommendList);

			model.addAttribute("code", 0);
			model.addAttribute("total", coachRecommendList.size());

			model.addAttribute("coachRecommendList", coachRecommendList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get coachRecommend error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/coachRecommend/json/coachRecommendListJson";
	}

}
