package com.ptteng.controller;


import com.ptteng.model.coachAbout.CoachPerformance;
import com.ptteng.model.coachAbout.CoachProgress;
import com.ptteng.model.coachAbout.CoachRate;
import com.ptteng.model.coachAbout.StudyTime;
import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.*;
import com.ptteng.yi.nucleus.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.*;

/**
 * 教练绩效模块
 */
@Controller
public class CoachPerformanceController {
    private static final Log log = LogFactory.getLog(CoachPerformanceController.class);

    @Autowired
    private AppointOrderService appointOrderService;

    @Autowired
    private StudentsService studentsService;

    @Autowired
    private TestRecordsService testRecordsService;

    @Autowired
    private TestActivityService testActivityService;

    @Autowired
    private CoachService coachService;


    /**
     * 绩效查看列表
     */
    @RequestMapping(value = "/a/u/coach/performance/list",method = RequestMethod.GET)
    public String getPerformance(Integer page, Integer size,Long schoolId,String coachName,String mobile,Long cityId,
                                 ModelMap model){

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Map<String, Object> coachMap = new HashMap<>();
            coachMap = DynamicUtil.getCoachPerformanceForCondition(cityId,schoolId,coachName,mobile);
            List<Long> coachIds = coachService.getIdsByDynamicCondition(Coach.class,coachMap,start,size);
            log.info("coachIds  is  : " + coachIds);

            Integer total = coachService.getIdsByDynamicCondition(Coach.class,coachMap,0,Integer.MAX_VALUE).size();
            log.info("total = " + total);

            List<Coach> coachList = coachService.getObjectsByIds(coachIds);

            List<CoachPerformance> performanceList = new ArrayList<>();

            //获取关联city学生
            Map<String, Object> stuMap = new HashMap<>();
            stuMap = DynamicUtil.getStudentIdForPerformance(cityId);
            List<Long> stuIds = studentsService.getIdsByDynamicCondition(Students.class,stuMap,0,Integer.MAX_VALUE);
            List<Students> studentsList = studentsService.getObjectsByIds(stuIds);
            log.info("stuIds = " + stuIds);

            //获取关联考试记录
            //第一次通过人数
            Map<String, Object> passMap = new HashMap<>();
            passMap = DynamicUtil.getNumberByCoachId(null,true);
            List<Long> onePassIds = testRecordsService.getIdsByDynamicCondition(TestRecords.class,passMap,0,Integer.MAX_VALUE);
            List<TestRecords> onePassStuList = testRecordsService.getObjectsByIds(onePassIds);
            log.info("onePassIds = " + onePassIds);

            //参加考试学员
            Map<String, Object> allMap = new HashMap<>();
            allMap = DynamicUtil.getAllTestForPerformance();
            List<Long> allTestIds = testRecordsService.getIdsByDynamicCondition(TestRecords.class,allMap,0,Integer.MAX_VALUE);
            List<TestRecords> allTestStuList = testRecordsService.getObjectsByIds(allTestIds);
            log.info("allTestIds = " + allTestIds);

            for (Coach coach :coachList)
            {
                Long coachId = coach.getId();
                //筛选有关于coachId
                String studyTime = "";
                Double twoAndThreeSum = 0.0;
                Double twoSum = 0.0;
                Double threeSum = 0.0;
                int twoAndThreeTimes = 0;
                int twoTimes = 0;
                int threeTimes = 0;
                StudyTime study = new StudyTime();
                for (Students student :studentsList)
                {
                    study = StudyTime.getTwoAndThreeData(student,coachId,twoAndThreeSum,twoAndThreeTimes,twoSum,twoTimes,
                            threeSum,threeTimes,study);
                }
                log.info("twoAndThreeSum = " + twoAndThreeSum + " and twoAndThreeTimes is :" + twoAndThreeTimes);
                log.info("twoSum = " + twoSum + " and twoTimes is :" + twoTimes);
                log.info("ThreeSum = " + threeSum + " and ThreeTimes is :" + threeTimes);
                //计算
                studyTime = (study.getStudySum()/study.getStudyTimes()) + "";
                if (studyTime.equals("NaN") || studyTime.equals("Infinity"))
                {
                    studyTime = "0";
                }
                if (studyTime.length()>3)
                {
                    studyTime = studyTime.substring(0,3);
                }
                //第一次通过人数
                Integer onePass = 0;
                for (TestRecords record :onePassStuList)
                {
                    if (DataUtils.isNotNullOrEmpty(record.getCoachId())  &&
                            record.getCoachId().equals(coachId))
                    {
                        onePass++;
                    }
                }
                Integer allTest = 0;
                Integer allPass = 0;
                for (TestRecords record:allTestStuList)
                {
                    //总人数
                    if (DataUtils.isNotNullOrEmpty(record.getCoachId())  &&
                            record.getCoachId().equals(coachId))
                    {
                        allTest++;
                    }
                    //通过人数
                    if (DataUtils.isNotNullOrEmpty(record.getCoachId())  &&
                            record.getCoachId().equals(coachId) && record.getPass() == 1)
                    {
                        allPass++;
                    }
                }
                //第一次通过率
                String firstRate = (onePass * 100.0 / allTest) + "";
                if (firstRate.equals("NaN") || firstRate.equals("Infinity"))
                {
                    firstRate = "0";
                }
                if (firstRate.length()>4)
                {
                    firstRate = firstRate.substring(0,4);
                }
                if (firstRate.equals("100."))
                {
                    firstRate = "100";
                }
                CoachPerformance performance = new CoachPerformance();
                performance.setCoach(coach);
                performance.setStuPass(allPass);
                performance.setRate(firstRate);
                performance.setAverageTerm(studyTime);
                performanceList.add(performance);
                log.info("performance = " + performance);
            }
            log.info("performanceList = " + performanceList);
            model.addAttribute("code", 0);
            model.addAttribute("performanceList", performanceList);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }
        return "/yi-nucleus-service/coachPerformance/json/performance";
    }


    /**
     * 评价详情列表
     */
    @RequestMapping(value = "/a/u/coach/comment/list",method = RequestMethod.GET)
    public String getCommentList(Integer page, Integer size,Long coachId,Integer subject,Long beginTime,Long endTime,
                                 ModelMap model){

        //默认科目二和科三
        if (DataUtils.isNullOrEmpty(subject) ) {
            subject = 2;
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            if (DataUtils.isNullOrEmpty(coachId)) {
                model.addAttribute("code", -23017);
                log.info("parameter coachId is null or empty");
                return "/common/failure";
            }

            Map<String, Object> map = new HashMap<>();
            map = DynamicUtil.getCommentByCoachIdAndCondition(coachId,subject,beginTime,endTime);
            List<Long> ids = appointOrderService.getIdsByDynamicCondition(AppointOrder.class,map,start,size);

            log.info("appointOrderIds is :" + ids);
            log.info("get getCommentByCoachIdAndCondition size is " + ids.size());

            List<AppointOrder> appointOrderList = appointOrderService.getObjectsByIds(ids);
            log.info("get appointOrder data is " + appointOrderList.size());

            List<Long> allIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class,map,0,Integer.MAX_VALUE);
            Integer total = allIds.size();
            log.info("get appointOrder count is " + total);

            //平均评分
            String avg = null;
            Double sum = 0.0;
            List<AppointOrder> scoreList = appointOrderService.getObjectsByIds(allIds);
            for (AppointOrder appointOrder :scoreList) {

                Double sc = Double.parseDouble(appointOrder.getScore());
                sum = sum + sc;
            }
            Double i = sum/total;
            avg = i + "" ;

            if (avg.equals("NaN") || avg.equals("Infinity"))
            {
                avg = "0";
            }

            if (avg.length()>3)
            {
                avg = avg.substring(0,3);
            }

            log.info("get avg is " + avg);
            log.info("get appointOrderList is " + appointOrderList);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("avg", avg);

            model.addAttribute("total", total);

            model.addAttribute("appointOrderList", appointOrderList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get comment list error,page is  " + start + " , size " + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/coachPerformance/json/comment";
    }

    /**
     * 学时详情列表
     * 科二：0，科三：1
     */
    @RequestMapping(value = "/a/u/coach/term/list",method = RequestMethod.GET)
    public String getProgressList(Integer page, Integer size,ModelMap model,Integer subject,String stuName,
                                  String mobile,Long coachId){

        //默认，科目二
        if (DataUtils.isNullOrEmpty(subject) ) {
            subject = 2;
        }

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : page= " + start + " , size=" + size);


        try {
            if (DataUtils.isNullOrEmpty(coachId)) {
                model.addAttribute("code", -23017);
                log.info("parameter coachId is null or empty");
                return "/common/failure";
            }

            Map<String, Object> stuMap = new HashMap<>();
            stuMap = DynamicUtil.getStudentIdByNameAndMobile(stuName,mobile,coachId,subject);

            List<Long> allStuIds = studentsService.getIdsByDynamicCondition(Students.class,stuMap,0,Integer.MAX_VALUE);
            Integer total0 = allStuIds.size();
            log.info("get allStudent size is " + total0);

            //学生数据
            List<Students> studentsList = studentsService.getObjectsByIds(allStuIds);

            List<CoachProgress> progressList = new ArrayList<>();

            Integer twoPeople = 0;
            Double twoTime = 0.0;
            Integer threePeople = 0;
            Double threeTime = 0.0;

            //考试记录，科二和科三
            Map<String, Object> testMap = new HashMap<>();
            testMap = DynamicUtil.getTestRecordByStuIdAndCoachId(null,2);
            List<Long> trIds = testRecordsService.getIdsByDynamicCondition(TestRecords.class,testMap,0,Integer.MAX_VALUE);
            List<TestRecords> testRecordsList = testRecordsService.getObjectsByIds(trIds);
            log.info("get trIds size is " + trIds);

            //获取科二和科三得考试活动
            Map<String, Object> tacMap = new HashMap<>();
            tacMap = DynamicUtil.getTestActivityByCondition(null,null,2);
            List<Long> allTacIds = testActivityService.getIdsByDynamicCondition(TestActivity.class,tacMap,0,Integer.MAX_VALUE);
            log.info("get allTacIds size is " + allTacIds);

            List<TestActivity> testActivityList  = testActivityService.getObjectsByIds(allTacIds);

            for (Students student:studentsList)
            {
                Long stuId = student.getId();
                //科二
                if (DataUtils.isNotNullOrEmpty(student.getSectionTwoCoachId()) &&
                        student.getSectionTwoCoachId().equals(coachId+"") && (subject == 0 || subject == 2))
                {
                    //考试时间,最近一次
                    Long testTime = 0L;

                    for (TestRecords record :testRecordsList)
                    {
                        if ( DataUtils.isNotNullOrEmpty(record.getStuId()) &&
                                record.getStuId().equals(stuId) && record.getType() == 4)
                        {
                            Long tacId = record.getTestActId();
                            for (TestActivity activity :testActivityList)
                            {
                                //考试时间
                                if ( DataUtils.isNotNullOrEmpty(tacId) && activity.getId().equals(tacId))
                                {
                                    testTime = activity.getTestTime();
                                }
                            }
                        }
                    }

                    CoachProgress progress = new CoachProgress();

                    progress.setStudents(student);
                    progress.setSubject(0);

                    progress.setStuTime(student.getSectionTwoNumerator());
                    progress.setTestTime(testTime);

                    //学时
                    if (DataUtils.isNotNullOrEmpty(student.getSectionTwoNumerator())){
                        twoTime = twoTime + Double.parseDouble(student.getSectionTwoNumerator());
                        twoPeople++;
                    }

                    progressList.add(progress);
                    log.info("get progress is " + progress);

                }

                //科三
                if (DataUtils.isNotNullOrEmpty(student.getSectionThreeCoachId()) &&
                        student.getSectionThreeCoachId().equals(coachId+"") && (subject == 1 || subject == 2))
                {
                    //考试时间,最近一次
                    Long testTime = 0L;
                    for (TestRecords record :testRecordsList)
                    {
                        if (DataUtils.isNotNullOrEmpty(record.getStuId()) &&
                                record.getStuId().equals(stuId) && record.getType() == 5)
                        {
                            Long tacId = record.getTestActId();
                            for (TestActivity activity :testActivityList)
                            {
                                //考试时间
                                if ( DataUtils.isNotNullOrEmpty(tacId) && activity.getId().equals(tacId))
                                {
                                    testTime = activity.getTestTime();
                                }
                            }
                        }
                    }
                    CoachProgress progress = new CoachProgress();

                    progress.setStudents(student);
                    progress.setSubject(1);

                    progress.setStuTime(student.getSectionThreeNumerator());
                    progress.setTestTime(testTime);

                    //学时
                    if (DataUtils.isNotNullOrEmpty(student.getSectionThreeNumerator())){
                        threeTime = threeTime + Double.parseDouble(student.getSectionThreeNumerator());
                        threePeople++;
                    }

                    progressList.add(progress);
                    log.info("get progress size is " + progress);
                }
            }

            String avg = (twoTime + threeTime)/(twoPeople + threePeople) + "";

            if (avg.equals("NaN") || avg.equals("Infinity"))
            {
                avg = "0";
            }

            if (avg.length()>3)
            {
                avg = avg.substring(0,3);
            }

            Integer total = progressList.size();
            progressList = progressList.subList(start < total ? start : total, start + size < total ? start + size : total);


            log.info("get avg size is " + avg);
            log.info("get progressList size is " + progressList);

            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("avgTime", avg);
            model.addAttribute("size", size);
            model.addAttribute("progressList",progressList );
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/coachPerformance/json/progress";
    }



    /**
     * 通过率列表
     */
    @RequestMapping(value = "/a/u/coach/rate/list",method = RequestMethod.GET)
    public String getPassRate(Integer page, Integer size,ModelMap model,Long coachId,Long beginTime,Long endTime,
                              Integer subject){

        if (DataUtils.isNullOrEmpty(beginTime)) {
            beginTime = 0L;
        }

        if (DataUtils.isNullOrEmpty(endTime)) {
            endTime = Long.MAX_VALUE;
        }

        //默认科二和科三
        if (DataUtils.isNullOrEmpty(subject)) {
            subject = 2;
        }


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            if (DataUtils.isNullOrEmpty(coachId)) {
                model.addAttribute("code", -23017);
                log.info("parameter coachId is null or empty");
                return "/common/failure";
            }

            Map<String, Object> tacMap = new HashMap<>();
            tacMap = DynamicUtil.getTestActivityByCondition(beginTime,endTime,subject);
            List<Long> tacIds = testActivityService.getIdsByDynamicCondition(TestActivity.class,tacMap,0,Integer.MAX_VALUE);
            log.info("tacIds size : " + tacIds.size());
            log.info("tacIds is : " + tacIds);

            List<TestActivity> testActivityList = testActivityService.getObjectsByIds(tacIds);

            List<CoachRate> coachRateList = new ArrayList<>();

            //通过人数 -- 总的
            Map<String, Object> coachPassMap = new HashMap<>();
            coachPassMap = DynamicUtil.getTestRecordByCondition(coachId,null,subject,true);
            List<Long> passIds  = testRecordsService.getIdsByDynamicCondition(TestRecords.class,coachPassMap,0,Integer.MAX_VALUE);
            List<TestRecords> passList = testRecordsService.getObjectsByIds(passIds);
            log.info(" passIds is : " + passIds);

            //没通过人数
            Map<String, Object> allMap = new HashMap<>();
            allMap = DynamicUtil.getTestRecordByCondition(coachId,null,subject,false);
            List<Long> notPassIds  = testRecordsService.getIdsByDynamicCondition(TestRecords.class,allMap,0,Integer.MAX_VALUE);
            List<TestRecords> notPassList = testRecordsService.getObjectsByIds(notPassIds);
            log.info(" notPassIds is : " + notPassIds);

            //筛选


            for (TestActivity activity :testActivityList)
            {
                Integer coachPass = 0;
                Integer coachNotPass = 0;
                Long tacId = activity.getId();
                //通过人数 -- 与对应考试活动相关
                for (TestRecords testRecord : passList)
                {
                    if (DataUtils.isNotNullOrEmpty(testRecord.getTestActId()) &&
                            testRecord.getTestActId().equals(tacId))
                    {
                        coachPass++;
                    }
                }

                //未通过人数
                for (TestRecords testRecord : notPassList)
                {
                    if ( DataUtils.isNotNullOrEmpty(testRecord.getTestActId()) &&
                            testRecord.getTestActId().equals(tacId))
                    {
                        coachNotPass++;
                    }
                }

                //总人数
                Integer all = coachPass + coachNotPass;

                //通过率
                String rate = (coachPass * 100.0 / all ) + "";
                if (rate.equals("NaN") || rate.equals("Infinity") || rate.equals("0"))
                {
                    rate = "0";
                }
                if (rate.length() > 4)
                {
                    rate = rate.substring(0,4);
                }

                if (rate.equals("100."))
                {
                    rate = "100";
                }

                //加入模型
                CoachRate coachRate = new CoachRate();
                coachRate.setPassTotal(coachPass);
                coachRate.setStuTotal(all);
                coachRate.setRate(rate);
                coachRate.setTestActivity(activity);

                if (all != 0)
                {
                    coachRateList.add(coachRate);
                    log.info(" coachRate is : " + coachRate);
                }
            }

            Integer total = coachRateList.size();
            log.info(" coachRateList  is  :" + total);

            //分页---------------
            coachRateList = coachRateList.subList(start < total ? start : total, start + size < total ? start + size : total);
            log.info(" coachRateList  is  :" + coachRateList);

            //通过人数
            Map<String, Object> passMap = new HashMap<>();
            passMap = DynamicUtil.getNumberByCoachId(coachId,false);
            Integer pass = testRecordsService.getIdsByDynamicCondition(TestRecords.class,passMap,0,Integer.MAX_VALUE).size();
            log.info(" pass  is :" + pass);

            //没通过人数
            Map<String, Object> notPassMap = new HashMap<>();
            notPassMap = DynamicUtil.getNotPassByCoachId(coachId);
            Integer notPass = testRecordsService.getIdsByDynamicCondition(TestRecords.class,notPassMap,0,Integer.MAX_VALUE).size();
            log.info(" notPass  is :" + notPass);

            //第一次人数
            Map<String, Object> oneMap = new HashMap<>();
            oneMap = DynamicUtil.getNumberByCoachId(coachId,true);
            Integer onePass = testRecordsService.getIdsByDynamicCondition(TestRecords.class,oneMap,0,Integer.MAX_VALUE).size();
            log.info(" onePass  is :" + onePass);

            //第一次通过率
            Double i = onePass * 100.0 / (pass + notPass);

            String firstRate  = i + "";

            if (firstRate.equals("NaN") || firstRate.equals("Infinity"))
            {
                firstRate = "0";
            }

            if (firstRate.length()>4)
            {
                firstRate = firstRate.substring(0,4);
            }

            if (firstRate.equals("100."))
            {
                firstRate = "100";
            }

            log.info(" firstRate  is :" + firstRate);
            log.info("coachRateList  is :" + coachRateList);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("firstRate", firstRate);
            model.addAttribute("coachRateList",coachRateList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);

        }
        return "/yi-nucleus-service/coachPerformance/json/passRate";
    }

    /**
     *学时查看模块
     */
    @RequestMapping(value = "/a/u/student/term/list",method = RequestMethod.GET)
    public String getStudyTimeList(Integer page, Integer size,ModelMap model,Long schoolId,Long cityId,String name,
                                   String mobile,String identification,Integer subject,Integer progress,String coach){

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        //默认科二
        if (DataUtils.isNullOrEmpty(subject)) {
            subject = 0;
        }

        try {
            Map<String, Object> stuMap = new HashMap<>();
            stuMap = DynamicUtil.getStudyTimeFormStudent(cityId,schoolId,name,mobile,identification,subject,progress,coach);
            List<Long> stuIds = studentsService.getIdsByDynamicCondition(Students.class,stuMap,start,size);
            log.info("stuIds size is :" + stuIds );

            Integer total = studentsService.getIdsByDynamicCondition(Students.class,stuMap,0,Integer.MAX_VALUE).size();
            log.info("total is :" + total );

            List<Students> studentsList = studentsService.getObjectsByIds(stuIds);
            log.info("studentsList is :" + studentsList );
            log.info("subject is :" + subject );

            model.addAttribute("subject", subject);
            model.addAttribute("studentsList", studentsList);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }
        return "/yi-nucleus-service/coachPerformance/json/studyTime";
    }

}

