package com.ptteng.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.CoachFree;
import com.ptteng.yi.nucleus.service.CoachFreeService;

/**
 * CoachFree  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CoachFreeController {
	private static final Log log = LogFactory.getLog(CoachFreeController.class);

	@Autowired
	private CoachFreeService coachFreeService;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/coachFree", method = RequestMethod.GET)
	public String getcoachFreeList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/coachFree  to /coachFree/view/coachFreeList");

		return "/yi-nucleus-service/coachFree/view/coachFreeList";
	}

	/**
	* 
	* @param 
	* @return 
	* @throws ServiceException
	* @throws ServiceDaoException
	*/

	@RequestMapping(value = "/c/coachFree1 ", method = RequestMethod.GET)
	public String getCoachFreeIdsByCoachIdOrderByCreateByList1(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Long coachId) throws Exception {

		log.info("/coachFree  to /coachFree/view/coachFreeList");

		return "/yi-nucleus-service/coachFree/view/coachFreeList";
	}

	@RequestMapping(value = "/c/coachFree/{id}", method = RequestMethod.GET)
	public String getCoachFree(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/coachFree/" + id + "  to /coachFree/view/coachFreeDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/coachFree/view/coachFreeDetail";
	}

	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/coachFree1 ", method = RequestMethod.GET)
	public String getCoachFreeIdsByCoachIdOrderByCreateByJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size, Long coachId) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = coachFreeService.getCoachFreeIdsByCoachIdOrderByCreateBy(coachId, start, size);
			log.info("get countCoachFreeIdsByCoachIdOrderByCreateBy size is " + ids.size());

			List<CoachFree> coachFreeList = coachFreeService.getObjectsByIds(ids);
			log.info("get coachFree data is " + coachFreeList.size());

			Integer total = coachFreeService.countCoachFreeIdsByCoachIdOrderByCreateBy(coachId);
			log.info("get coachFree count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("coachFreeList", coachFreeList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get coachFree list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/coachFree/json/coachFreeListJson";
	}

	@RequestMapping(value = "/a/coachFree/{id}", method = RequestMethod.GET)
	public String getCoachFreeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			CoachFree coachFree = coachFreeService.getObjectById(id);
			log.info("get coachFree data is " + coachFree);

			model.addAttribute("code", 0);

			model.addAttribute("coachFree", coachFree);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get coachFree error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/coachFree/json/coachFreeDetailJson";
	}

	@RequestMapping(value = "/a/coachFree/{id}", method = RequestMethod.PUT)
	public String updateCoachFreeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			CoachFree coachFree) throws Exception {

		log.info("update coachFree : coachFree= " + coachFree);

		try {

			coachFreeService.update(coachFree);

			model.addAttribute("code", 0);

			model.addAttribute("coachFree", coachFree);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update coachFree error,id is  " + coachFree.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/coachFree", method = RequestMethod.POST)
	public String addCoachFreeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			CoachFree coachFree) throws Exception {

		log.info("update coachFree : coachFree= " + coachFree);

		try {
			coachFree.setId(null);

			coachFreeService.insert(coachFree);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add coachFree error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/coachFree/{id}", method = RequestMethod.DELETE)
	public String deleteCoachFreeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete coachFree : id= " + id);
		try {
			coachFreeService.delete(id);

			log.info("add coachFree success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete coachFree error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/coachFree", method = RequestMethod.GET)
	public String getMultiCoachFreeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<CoachFree> coachFreeList = coachFreeService.getObjectsByIds(idList);
			log.info("get  coachFree data is " + coachFreeList);

			model.addAttribute("code", 0);
			model.addAttribute("total", coachFreeList.size());

			model.addAttribute("coachFreeList", coachFreeList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get coachFree error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/coachFree/json/coachFreeListJson";
	}

}
