package com.ptteng.controller;

import com.gemantic.common.util.PasswordUtils;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.util.userNameUtil;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.model.CoachClassRelation;
import com.ptteng.yi.nucleus.model.DrivingClass;
import com.ptteng.yi.nucleus.service.CoachClassRelationService;
import com.ptteng.yi.nucleus.service.CoachService;
import com.ptteng.yi.nucleus.service.DrivingClassService;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.service.ImAccountService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Coach  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CoachController {
	private static final Log log = LogFactory.getLog(CoachController.class);

	@Autowired
	private CoachService coachService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private DrivingClassService drivingClassService;

	@Autowired
	private CoachClassRelationService coachClassRelationService;

	@Autowired
	ImAccountService imAccountService;

	@Autowired
	ImChatUtil imChatUtil;

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param cityId
	 * @param schoolId
	 * @param name
	 * @param school
	 * @param identification
	 * @param mobile
	 * @param status
	 * @param subject
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coach/list ", method = RequestMethod.GET)
	public String getCoachIdsByCityIdAndStatusJsonList(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Integer page, Integer size, Long cityId, Long schoolId, String name, String school,
			String identification, String mobile, Integer status, String subject) throws Exception {

		log.info("page" + page + "size " + size + "cityId" + cityId + "schoolId " + schoolId + "name" + name
				+ " school " + school + "identification " + identification + " mobile " + mobile + " status " + status
				+ " subject " + subject);
		if (DataUtils.isNullOrEmpty(cityId)) {
			model.addAttribute("code", -23005);
			log.info("parameter cityId is null or empty");
			return "/common/failure";
		}
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Map<String, Object> map = new HashMap<>();
			Integer certification = null;
			if (DataUtils.isNotNullOrEmpty(schoolId)) {
				certification = 1;
			}
			map = DynamicUtil.getCoachListParams(schoolId, cityId, name, school, identification, mobile, status, 1,
					subject);

			List<Long> ids = coachService.getIdsByDynamicCondition(DrivingClass.class, map, start, size);
			List<Long> totalIds = coachService.getIdsByDynamicCondition(DrivingClass.class, map, 0, Integer.MAX_VALUE);
			log.info("get countCoachIdsByCityIdAndStatus size is " + ids.size());

			List<Coach> coachList = coachService.getObjectsByIds(ids);
			log.info("get coach data is " + coachList.size());

			Integer total = totalIds.size();
			log.info("get coach count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("coachList", coachList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get coach list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/coach/json/coachListJson";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coach/{id}", method = RequestMethod.GET)
	public String getCoachJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Coach coach = coachService.getObjectById(id);
			log.info("get coach data is " + coach);
			if (DataUtils.isNullOrEmpty(coach)) {
				model.addAttribute("code", -9024);
				log.info("parameter schools is null or empty");
				return "/common/failure";
			}

			model.addAttribute("code", 0);

			model.addAttribute("coach", coach);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get coach error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/coach/json/coachDetailJson";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param img
	 * @param model
	 * @param id
	 * @param career
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coach/{id}", method = RequestMethod.PUT)
	public String updateCoachJson(HttpServletRequest request, HttpServletResponse response, String img, ModelMap model,
			@PathVariable Long id, String career) throws Exception {

		log.info("update coach : coach= " + id);
		log.info(img + "img");
		log.info(career + "career");

		if (DataUtils.isNullOrEmpty(career)) {
			model.addAttribute("code", -23015);
			log.info("parameter schools is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(img)) {
			model.addAttribute("code", -23014);
			log.info("parameter schools is null or empty");
			return "/common/failure";
		}

		try {
			Coach coach = coachService.getObjectById(id);
			if (DataUtils.isNullOrEmpty(coach)) {
				model.addAttribute("code", -23026);
				log.info("coach is null or empty");
				return "/common/failure";
			}
			log.info("coach is "+coach);
			coach.setCareer(career);
			coach.setImg(img);
			coachService.update(coach);
			model.addAttribute("code", 0);
			model.addAttribute("coach", coach);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	/**
	 * 新增
	 * @param request
	 * @param response
	 * @param model
	 * @param coach
	 * @param classes
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coach", method = RequestMethod.POST)
	public String addCoachJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Coach coach,
			@RequestParam(value = "classes") Long[] classes) throws Exception {

		log.info("update coach : coach= " + coach);

		if (DataUtils.isNullOrEmpty(coach.getName())) {
			model.addAttribute("code", -23000);
			log.info("parameter name is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(coach.getMobile())) {
			model.addAttribute("code", -23001);
			log.info("parameter schools is null or empty");
			return "/common/failure";
		}

		Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
		coach.setId(null);

		Map<String, Object> mapP = new HashMap<>();
		mapP = DynamicUtil.getCoachListParams(null, null, null, null, null, coach.getMobile(), null, null, null);
		List<Long> mobile = coachService.getIdsByDynamicCondition(Coach.class, mapP, 0, Integer.MAX_VALUE);

		if (mobile.size() > 0) {
			model.addAttribute("code", -23013);
			log.info("parameter schools is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(coach.getPwd())) {
			model.addAttribute("code", -23002);
			log.info("parameter schools is null or empty");
			return "/common/failure";
		} else {
			String encodePass = PasswordUtils.encode(coach.getPwd());
			coach.setPwd(encodePass);
		}
		if (DataUtils.isNullOrEmpty(coach.getSchoolId())) {
			model.addAttribute("code", -23004);
			log.info("parameter schools is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(coach.getCareer())) {
			coach.setCareer("0");
		}
		if (DataUtils.isNullOrEmpty(coach.getSchool())) {
			model.addAttribute("code", -23003);
			log.info("parameter schools is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(coach.getCityId())) {
			model.addAttribute("code", -23005);
			log.info("parameter cityId is null or empty");
			return "/common/failure";
		}

		Long cid = null;
		Long imAccountId = null;
		try {

			coach.setCertification(Coach.CERTIFICATION_ON);
			coach.setStatus(Coach.STATUS_ON);
			coach.setCreateBy(mid);
			coach.setUpdateBy(mid);

			userNameUtil userNameUtill = new userNameUtil();
			coach.setNick("教-" + userNameUtill.getRandomName());
			cid = coachService.insert(coach);
			List<Long> classIdList = Arrays.asList(classes);

			//创建网易云IM账号
			if (null != cid) {
				String accid = imChatUtil.getAccid(cid, ImChatUtil.AccidType.COACH);
				String accidToken = null;
				String code = null;
				String message = null;
				Map<String, String> result = imChatUtil.createImAccount(accid);
				log.info("result is=="
						+ (null != result && 0 != result.size() ? Arrays.asList(result) : " null or size is zero"));

				code = result.get("code");
				if (code.equals("200")) {
					log.info("create im account success");
					accidToken = result.get("token");
					accid = result.get("accid");
					ImAccount imAccount = new ImAccount();
					imAccount.setAccount(accid);
					imAccount.setBelongId(cid);
					imAccount.setBelongtType(1);
					imAccount.setToken(accidToken);
					imAccount.setCreateAt(System.currentTimeMillis());
					imAccount.setCreateBy(cid);
					imAccount.setUpdateAt(System.currentTimeMillis());
					imAccount.setUpdateBy(cid);

					imAccountId = imAccountService.insert(imAccount);
					log.info("create im account success,insert to DB success");

					boolean success = imChatUtil.updateCoachInfo(accid, coach);
					if (success)
						log.info("update coach info success");
					else
						log.info("update coach info failed");

				} else {
					message = result.get("message");
					log.info("create im account failed,see==" + message);
					coachService.delete(cid);
					throw new Exception("register failed,cause create im account failed");
				}
			}

			//关联班型
			if (classIdList.size() == 0) {
				model.addAttribute("code", -23006);
				log.info("parameter cityId is null or empty");
				return "/common/failure";
			}
			List<DrivingClass> drivingClassList = drivingClassService.getObjectsByIds(classIdList);
			List<CoachClassRelation> coachClassRelationsList = new ArrayList<>();
			for (DrivingClass drivingClass : drivingClassList) {
				CoachClassRelation coachClassRelation = new CoachClassRelation();
				coachClassRelation.setClassId(drivingClass.getId());
				coachClassRelation.setCoachId(cid);
				coachClassRelation.setCreateBy(mid);
				coachClassRelation.setUpdateBy(mid);
				coachClassRelationsList.add(coachClassRelation);
			}
			coachClassRelationService.insertList(coachClassRelationsList);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add coach error ");
			if (null != t.getMessage() && t.getMessage().equals("register failed,cause create im account failed")) {
				model.addAttribute("code", -26000);
			} else {
				model.addAttribute("code", -6002);
			}

			if (null != imAccountId)
				imAccountService.delete(imAccountId);

			if (null != cid)
				coachService.delete(cid);
		}

		return "/data/json";
	}

	//	@RequestMapping(value = "/a/coach/{id}", method = RequestMethod.DELETE)
	//	public String deleteCoachJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
	//			@PathVariable Long id) throws Exception {
	//
	//		log.info("delete coach : id= " + id);
	//		try {
	//			coachService.delete(id);
	//
	//			log.info("add coach success");
	//			model.addAttribute("code", 0);
	//
	//		} catch (Throwable t) {
	//			t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("delete coach error,id is  " + id);
	//			model.addAttribute("code", -6004);
	//
	//		}
	//
	//		return "/data/json";
	//	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param status
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/status/{status}/coach/{id}", method = RequestMethod.PUT)
	public String statusCoachJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Integer status, @PathVariable Long id) throws Exception {

		log.info("delete coach : id= " + id);
		try {
			Coach coach = coachService.getObjectById(id);
			Integer s = coach.getStatus();
			if (s.equals(status)) {
				model.addAttribute("code", -9024);
				log.info("parameter schools is null or empty");
				return "/common/failure";
			} else {
				coach.setStatus(status);
			}
			coachService.update(coach);

			log.info("add coach success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete coach error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

}
