package com.ptteng.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.AdvanceTime;
import com.ptteng.yi.nucleus.model.AppointOrder;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.service.AdvanceTimeService;
import com.ptteng.yi.nucleus.service.AppointOrderService;
import com.ptteng.yi.nucleus.service.CoachService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.apache.commons.collections.CollectionUtils;

import com.ptteng.yi.nucleus.model.CoachAppointTime;
import com.ptteng.yi.nucleus.service.CoachAppointTimeService;

/**
 * CoachAppointTime  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CoachAppointTimeController {
	private static final Log log = LogFactory.getLog(CoachAppointTimeController.class);

	@Autowired
	private CoachAppointTimeService coachAppointTimeService;

	@Autowired
	private AdvanceTimeService advanceTimeService;

	@Autowired
	private CoachService coachService;
	@Autowired
	private AppointOrderService appointOrderService;

	/**
	 * 获取预约时间
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @param type
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coach/arrange/{id}", method = RequestMethod.GET)
	public String getCoachArrange(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, int type) throws Exception {

		log.info("id is " + id + " type is " + type);
		if (DataUtils.isNullOrEmpty(type)) {
			model.addAttribute("code", -23016);
			log.info("type is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(id)) {
			model.addAttribute("code", -23017);
			log.info("id is null or empty");
			return "/common/failure";
		}
		try {
			List<Long> coachAppointTimeIds = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndTypeAndCoachId(
					CoachAppointTime.COACHADVANCETIME_STATUS_NO, type, id, 0, Integer.MAX_VALUE);
			log.info("coachAppointTimeIds is "+coachAppointTimeIds);
			List<AdvanceTime> twoTimeList = new ArrayList<>();
			List<AdvanceTime> threeTimeList = new ArrayList<>();
			List<AdvanceTime> advanceTimeList = new ArrayList<>();
			CoachAppointTime coachAppointTime = new CoachAppointTime();
			if (CollectionUtils.isEmpty(coachAppointTimeIds)) {
				Coach coach = coachService.getObjectById(id);
				log.info("coach is "+coach);
				if(DataUtils.isNullOrEmpty(coach)){
					log.info("coach is null");
					model.addAttribute("code", -23026);
					return "/common/failure";
				}
				List<Long> ids = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndCityIdAndType(
						CoachAppointTime.COACHADVANCETIME_STATUS_YES, coach.getCityId(), type, 0, Integer.MAX_VALUE);
				log.info("ids is "+ids);
				List<CoachAppointTime> coachAppointTimeList=new ArrayList<>();
				if(CollectionUtils.isNotEmpty(ids)){
					coachAppointTimeList = coachAppointTimeService.getObjectsByIds(ids);
				}
				if (CollectionUtils.isNotEmpty(ids)) {
					coachAppointTime = coachAppointTimeList.get(0);
					Map<String, Object> map = DynamicUtil.getAppointTimeList(coachAppointTime.getId(),
							AdvanceTime.ADVANCE_TIME_STATUS_ON);
					log.info("map is "+map);
					List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, 0,
							Integer.MAX_VALUE);
					log.info("advanceTimeIds is "+advanceTimeIds);
					if(CollectionUtils.isNotEmpty(advanceTimeIds)){
						advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
					}
				}
			} else {
				List<CoachAppointTime> coachAppointTimeList = coachAppointTimeService
						.getObjectsByIds(coachAppointTimeIds);
				coachAppointTime = coachAppointTimeList.get(0);
				Map<String, Object> map = DynamicUtil.getAppointTimeList(coachAppointTime.getId(),
						AdvanceTime.ADVANCE_TIME_STATUS_ON);
				log.info("map is "+map);
				List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, 0,
						Integer.MAX_VALUE);
				log.info("advanceTimeIds is "+advanceTimeIds);
				if(CollectionUtils.isNotEmpty(advanceTimeIds)){
					advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
				}
			}
			for (int i = 0; i < advanceTimeList.size(); i++) {
				AdvanceTime advanceTime = advanceTimeList.get(i);
				log.info("advanceTime is "+advanceTime);
				Integer subject = advanceTime.getSubject();
				if (subject.equals(AdvanceTime.TWO_SUBJECT)) {
					twoTimeList.add(advanceTime);
				}
				if (subject.equals(AdvanceTime.THREE_SUBJECT)) {
					threeTimeList.add(advanceTime);
				}
			}

			model.addAttribute("twoTimeList", twoTimeList);
			model.addAttribute("threeTimeList", threeTimeList);
			model.addAttribute("coachAppointTime", coachAppointTime);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete coach error,id is  " + id);
			model.addAttribute("code", -100000);

		}

		return "/yi-nucleus-service/coachAppointTime/json/coachArrange";
	}

	/**
	 * 修改预约时间
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @param coachAppointTime
	 * @param twoTimeList
	 * @param threeTimeList
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coach/arrange/{id}", method = RequestMethod.PUT)
	public String putCoachArrange(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id, CoachAppointTime coachAppointTime, String twoTimeList, String threeTimeList,
			Integer rest) throws Exception {

		log.info("id is " + id + " coachAppointTime is " + coachAppointTime);
		log.info("twoTimeList is " + twoTimeList);
		log.info("threetimeList is " + threeTimeList);

		if (DataUtils.isNullOrEmpty(coachAppointTime.getTwoAdvanceTime())) {
			model.addAttribute("code", -23018);
			log.info("getTwoAdvanceTime is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(coachAppointTime.getTwoAppointFrequency())) {
			model.addAttribute("code", -23019);
			log.info("getTwoAppointFrequency is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(rest)) {
			model.addAttribute("code", -23020);
			log.info("getTwoRest is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(twoTimeList)) {
			model.addAttribute("code", -23021);
			log.info("twoTimeList is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(coachAppointTime.getThreeAdvanceTime())) {
			model.addAttribute("code", -23022);
			log.info("getThreeAdvanceTime is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(coachAppointTime.getThreeAppointFrequency())) {
			model.addAttribute("code", -23023);
			log.info("getThreeAppointFrequency is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(threeTimeList)) {
			model.addAttribute("code", -23025);
			log.info("threeTimeList is null or empty");
			return "/common/failure";
		}

		try {
			//修改时判断是否有订单
			CoachAppointTime coachAppointTimeData = coachAppointTimeService.getObjectById(id);
			if(DataUtils.isNullOrEmpty(coachAppointTimeData)){
				model.addAttribute("code", -23029);
				log.info("coachAppointTimeData is null or empty");
				return "/common/failure";
			}
			log.info("coachAppointTimeData is "+coachAppointTimeData);
			List<String> typeList = new ArrayList<>();
			List<String> ids = new ArrayList<>();
			typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
			typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
			typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
			Map<String, Object> advanceTimeMap = DynamicUtil.getAppointTimeList(id, AdvanceTime.ADVANCE_TIME_STATUS_ON);
			log.info("advanceTimeMap is "+advanceTimeMap);
			List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, advanceTimeMap, 0,
					Integer.MAX_VALUE);
			log.info("advanceTimeIds is "+advanceTimeIds);
			for (int i = 0; i < advanceTimeIds.size(); i++) {
				ids.add(advanceTimeIds.get(i).toString());
			}
			log.info("ids is " + ids + " typeList is " + typeList);
			Map<String, Object> appointOrderMap = DynamicUtil.advanceIdGetAppointOrderList(typeList, ids);
			log.info("appointOrderMap is  "+appointOrderMap);
			List<Long> appointOrderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, appointOrderMap,
					0, Integer.MAX_VALUE);
			log.info("appointOrderIds is " + appointOrderIds);
			if (!Integer.valueOf(appointOrderIds.size()).equals(0)) {
				model.addAttribute("code", -23028);
				log.info("appointOrder not canceled");
				return "/common/failure";
			}
			coachAppointTimeData.setTwoAdvanceTime(coachAppointTime.getTwoAdvanceTime());
			coachAppointTimeData.setTwoAppointFrequency(coachAppointTime.getTwoAppointFrequency());
			coachAppointTimeData.setTwoRest(rest);
			coachAppointTimeData.setThreeAdvanceTime(coachAppointTime.getThreeAdvanceTime());
			coachAppointTimeData.setThreeAppointFrequency(coachAppointTime.getThreeAppointFrequency());

			List<AdvanceTime> advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
			for (int i = 0; i < advanceTimeList.size(); i++) {
				AdvanceTime newAdvanceTime = advanceTimeList.get(i);
				newAdvanceTime.setStatus(AdvanceTime.ADVANCE_TIME_STATUS_OFF);
				advanceTimeService.update(newAdvanceTime);
			}

			List<AdvanceTime> newTwoTimeList = AdvanceTimeEPRList(twoTimeList, id, AdvanceTime.TWO_SUBJECT);
			List<AdvanceTime> newThreeTimeList = AdvanceTimeEPRList(threeTimeList, id, AdvanceTime.THREE_SUBJECT);
			advanceTimeService.insertList(newTwoTimeList);
			advanceTimeService.insertList(newThreeTimeList);
			coachAppointTimeService.update(coachAppointTimeData);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete coach error,id is  " + id);
			model.addAttribute("code", -100000);

		}

		return "/data/json";
	}

	/**
	 * 新增预约时间
	 * @param request
	 * @param response
	 * @param model
	 * @param coachAppointTime
	 * @param twoTimeList
	 * @param threeTimeList
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/coach/arrange", method = RequestMethod.POST)
	public String postCoachArrange(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			CoachAppointTime coachAppointTime, String twoTimeList, String threeTimeList, Integer rest)
			throws Exception {

		log.info("coachAppointTime is " + coachAppointTime);
		log.info("twoTimeList is " + twoTimeList);
		log.info("threeTimeList is " + threeTimeList);

		if (DataUtils.isNullOrEmpty(coachAppointTime.getType())) {
			model.addAttribute("code", -23016);
			log.info("getType is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(coachAppointTime.getCoachId())) {
			model.addAttribute("code", -23017);
			log.info("getCoachId is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(coachAppointTime.getTwoAdvanceTime())) {
			model.addAttribute("code", -23018);
			log.info("getTwoAdvanceTime is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(coachAppointTime.getTwoAppointFrequency())) {
			model.addAttribute("code", -23019);
			log.info("getTwoAppointFrequency is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(rest)) {
			model.addAttribute("code", -23020);
			log.info("getTwoRest is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(twoTimeList)) {
			model.addAttribute("code", -23021);
			log.info("twoTimeList is null or empty");
			return "/common/failure";
		}
		if (DataUtils.isNullOrEmpty(coachAppointTime.getThreeAdvanceTime())) {
			model.addAttribute("code", -23022);
			log.info("getThreeAdvanceTime is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(coachAppointTime.getThreeAppointFrequency())) {
			model.addAttribute("code", -23023);
			log.info("getThreeAppointFrequency is null or empty");
			return "/common/failure";
		}

		if (DataUtils.isNullOrEmpty(threeTimeList)) {
			model.addAttribute("code", -23025);
			log.info("threeTimeList is null or empty");
			return "/common/failure";
		}
		try {
			Coach coach = coachService.getObjectById(coachAppointTime.getCoachId());
			if (DataUtils.isNullOrEmpty(coach)) {
				model.addAttribute("code", -23026);
				log.info("coach is null or empty");
				return "/common/failure";
			}
			log.info("coach is "+coach);
			List<Long> coachAppointTimeIds = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndTypeAndCoachId(0,
					coachAppointTime.getType(), coachAppointTime.getCoachId(), 0, Integer.MAX_VALUE);
			log.info("coachAppointTimeIds ======" + coachAppointTimeIds);
			log.info("coachAppointTimeIds size ====" + coachAppointTimeIds.size());
			if (coachAppointTimeIds.size() > CoachAppointTime.COACHADVANCETIME_STATUS_NO) {
				model.addAttribute("code", -23027);
				log.info("coachAppointTimeIds is exist");
				return "/common/failure";
			} else {

				CoachAppointTime newCoachAppointTime = new CoachAppointTime();
				newCoachAppointTime.setCoachId(coachAppointTime.getCoachId());
				newCoachAppointTime.setType(coachAppointTime.getType());
				newCoachAppointTime.setTwoAdvanceTime(coachAppointTime.getTwoAdvanceTime());
				newCoachAppointTime.setTwoAppointFrequency(coachAppointTime.getTwoAppointFrequency());
				newCoachAppointTime.setTwoRest(rest);
				newCoachAppointTime.setThreeAdvanceTime(coachAppointTime.getThreeAdvanceTime());
				newCoachAppointTime.setThreeAppointFrequency(coachAppointTime.getThreeAppointFrequency());
				newCoachAppointTime.setCityId(coach.getCityId());
				newCoachAppointTime.setSchoolId(coach.getSchoolId());
				newCoachAppointTime.setStatus(CoachAppointTime.COACHADVANCETIME_STATUS_NO);
				log.info("newCoachAppointTime is " + newCoachAppointTime);
				Long id = coachAppointTimeService.insert(newCoachAppointTime);

				List<AdvanceTime> newTwoTimeList = AdvanceTimeEPRList(twoTimeList, id, AdvanceTime.TWO_SUBJECT);
				List<AdvanceTime> newThreeTimeList = AdvanceTimeEPRList(threeTimeList, id, AdvanceTime.THREE_SUBJECT);
				advanceTimeService.insertList(newTwoTimeList);
				advanceTimeService.insertList(newThreeTimeList);
			}

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add coachAppointTime error");
			model.addAttribute("code", -6002);

		}

		return "/data/json";
	}

	public static List<AdvanceTime> AdvanceTimeEPRList(String threeTimeList, Long id, int subject) {
		List<AdvanceTime> advanceTimeList = new ArrayList<>();
		JSONArray newThreeTimeList = JSONArray.fromObject(threeTimeList);
		for (int i = 0; i < newThreeTimeList.size(); i++) {
			JSONObject jsonObject = newThreeTimeList.getJSONObject(i);
			AdvanceTime advanceTime = new AdvanceTime();
			advanceTime.setCoachTimeId(id);
			advanceTime.setNum(jsonObject.getLong("num"));
			advanceTime.setStartTime(jsonObject.getLong("timeStart"));
			advanceTime.setEndTime(jsonObject.getLong("timeEnd"));
			advanceTime.setSubject(subject);
			advanceTime.setStatus(AdvanceTime.ADVANCE_TIME_STATUS_ON);
			log.info("advanceTime ======" + advanceTime);
			advanceTimeList.add(advanceTime);
		}

		return advanceTimeList;

	}

}
