package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.ClassCarRelation;
import com.ptteng.yi.nucleus.service.ClassCarRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * ClassCarRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ClassCarRelationController {
	private static final Log log = LogFactory.getLog(ClassCarRelationController.class);

	@Autowired
	private ClassCarRelationService classCarRelationService;

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param classId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/classCarRelation/list ", method = RequestMethod.GET)
	public String getClassCarRelationIdsByClassIdJsonList(HttpServletRequest request, HttpServletResponse response,
			ModelMap model, Integer page, Integer size, Long classId) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = classCarRelationService.getClassCarRelationIdsByClassId(classId, start, size);
			log.info("get countClassCarRelationIdsByClassId size is " + ids.size());

			List<ClassCarRelation> classCarRelationList = classCarRelationService.getObjectsByIds(ids);
			log.info("get classCarRelation data is " + classCarRelationList.size());

			Integer total = classCarRelationService.countClassCarRelationIdsByClassId(classId);
			log.info("get classCarRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("classCarRelationList", classCarRelationList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get classCarRelation list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/classCarRelation/json/classCarRelationListJson";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param classCarRelation
	 * @param mid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/classCarRelation", method = RequestMethod.POST)
	public String addClassCarRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			ClassCarRelation classCarRelation, Long mid) throws Exception {

		log.info("update classCarRelation : classCarRelation= " + classCarRelation);

		try {
			classCarRelation.setUpdateBy(mid);
			classCarRelation.setCreateBy(mid);
			classCarRelation.setId(null);

			classCarRelationService.insert(classCarRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add classCarRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	//	@RequestMapping(value = "/a/u/classCarRelation/{id}", method = RequestMethod.DELETE)
	//	public String deleteClassCarRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
	//			@PathVariable Long id) throws Exception {
	//
	//		log.info("delete classCarRelation : id= " + id);
	//		try {
	//			classCarRelationService.delete(id);
	//
	//			log.info("add classCarRelation success");
	//			model.addAttribute("code", 0);
	//
	//		} catch (Throwable t) {
	//			t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("delete classCarRelation error,id is  " + id);
	//			model.addAttribute("code", -6004);
	//
	//		}
	//
	//		return "/data/json";
	//	}

}
