package com.ptteng.controller;

import com.ptteng.common.yi.model.Manager;
import com.ptteng.common.yi.service.ManagerService;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.yi.nucleus.model.Center;
import com.ptteng.yi.nucleus.service.CenterService;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.service.ImAccountService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Center  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CenterController {
	private static final Log log = LogFactory.getLog(CenterController.class);

	@Autowired
	private CenterService centerService;

	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private ManagerService managerService;

	@Autowired
	ImAccountService imAccountService;

	@Autowired
	ImChatUtil imChatUtil;

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/center/{id}", method = RequestMethod.GET)
	public String getCenterJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Center center = centerService.getObjectById(id);
			log.info("get center data is " + center);

			model.addAttribute("code", 0);

			model.addAttribute("center", center);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get center error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/center/json/centerDetailJson";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param center
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/center/{id}", method = RequestMethod.PUT)
	public String updateCenterJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Center center, @PathVariable Long id) throws Exception {

		log.info("update center : center= " + center);

		try {
			if (center.getId() == null) {
				model.addAttribute("code", -21002);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getMobile() == null) {
				model.addAttribute("code", -21006);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getName() == null) {
				model.addAttribute("code", -21004);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getCityId() == null) {
				model.addAttribute("code", -21001);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getAfterMobile() == null) {
				model.addAttribute("code", -21005);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getProMobile() == null) {
				model.addAttribute("code", -21003);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getProvinceId() == null) {
				model.addAttribute("code", -21002);
				log.info(" center roleid is null");
				return "/data/json";
			}
			Center c = centerService.getObjectById(id);
			List<Long> managerIds = managerService.getManagerIdsByName(center.getMobile(), 0, Integer.MAX_VALUE);
			log.info("manager name " + center.getMobile());

			if (!center.getMobile().equals(c.getMobile())) {
				if (managerIds.size() > 0) {
					log.info(" manager name is exit ");
					model.addAttribute("code", -5019);
					return "/data/json";
				}
				List<Long> mids = managerService.getManagerIdsByName(c.getMobile(), 0, Integer.MAX_VALUE);
				List<Manager> managerList = managerService.getObjectsByIds(mids);
				if (managerList.size() > 0) {
					for (Manager manager : managerList) {
						manager.setName(center.getMobile());
					}
					managerService.updateList(managerList);
				}
			}

			centerService.update(center);

			//更新驾校售前售后客服IM账号基本信息
			List<Long> imAccountIds = imAccountService.getIdByBelongIdAndBelongType(2, id);
			Long accountId = null != imAccountIds && 0 != imAccountIds.size()
					? imAccountIds.get(imAccountIds.size() - 1)
					: null;
			ImAccount imAccount = imAccountService.getObjectById(accountId);

			if (null != imAccount) {
				boolean success = imChatUtil.updateCustomerServiceInfo(imAccount.getAccount(), center);

				if (success)
					log.info("success to update presale customer im account info");
				else
					log.info("failed to update presale customer im account info");
			}

			imAccountIds = imAccountService.getIdByBelongIdAndBelongType(3, id);
			accountId = null != imAccountIds && 0 != imAccountIds.size() ? imAccountIds.get(imAccountIds.size() - 1)
					: null;
			imAccount = imAccountService.getObjectById(accountId);

			if (null != imAccount) {
				boolean success = imChatUtil.updateCustomerServiceInfo(imAccount.getAccount(), center);

				if (success)
					log.info("success to update after customer im account info");
				else
					log.info("failed to update after customer im account info");
			}

			model.addAttribute("code", 0);
			model.addAttribute("center", center);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update center error,id is  " + center.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param center
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/center", method = RequestMethod.POST)
	public String addCenterJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Center center)
			throws Exception {

		log.info("update center : center= " + center);
		Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

		Long centerId = null;
		//网易云IM即时通讯售前客服账号
		Long presaleId = null;
		//网易云IM即时通讯售后客服账号
		Long afterId = null;

		try {
			Map<String, Object> map = DynamicUtil.geCenterByCityIdAndStatus(center.getCityId(), null);
			log.info("map--------------" + map);
			List<Long> ids = centerService.getIdsByDynamicCondition(Center.class, map, 0, Integer.MAX_VALUE);
			log.info("miiii--------------" + ids);
			if (ids.size() > 0) {
				model.addAttribute("code", -21000);
				log.info(" center roleid is null");
				return "/data/json";
			}
			center.setId(null);
			if (center.getMobile() == null) {
				model.addAttribute("code", -21006);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getName() == null) {
				model.addAttribute("code", -21004);
				log.info(" center roleid is null");
				return "/data/json";
			}

			List<Long> managerIds = managerService.getManagerIdsByName(center.getMobile(), 0, Integer.MAX_VALUE);
			log.info("manager name " + center.getMobile());
			if (managerIds.size() > 0) {
				log.info(" manager name is exit ");
				model.addAttribute("code", -5019);
				return "/data/json";
			}
			if (center.getCityId() == null) {
				model.addAttribute("code", -21001);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getAfterMobile() == null) {
				model.addAttribute("code", -21005);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getProMobile() == null) {
				model.addAttribute("code", -21003);
				log.info(" center roleid is null");
				return "/data/json";
			}
			if (center.getProvinceId() == null) {
				model.addAttribute("code", -21002);
				log.info(" center roleid is null");
				return "/data/json";
			}
			center.setStatus(0l);
			center.setCreateBy(mid);
			center.setUpdateBy(mid);

			centerId = centerService.insert(center);

			//创建网易云IM账号
			if (null != centerId) {
				//售前
				String accidOfPresale = imChatUtil.getAccid(centerId, ImChatUtil.AccidType.PresaleCustomerService);
				String accidTokenOfPresale = null;
				//售后
				String accidOfAfter = imChatUtil.getAccid(centerId, ImChatUtil.AccidType.AftersalesCustomerService);
				String accidTokenOfAfter = null;

				String codeOfPresale = null;
				String codeOfAfter = null;
				String messageOfPresale = null;
				String messageOfAfter = null;

				Map<String, String> resultOfPresale = imChatUtil.createImAccount(accidOfPresale);
				Map<String, String> resultOfAfter = imChatUtil.createImAccount(accidOfAfter);
				log.info("resultOfPresale is=="
						+ (null != resultOfPresale && 0 != resultOfPresale.size() ? Arrays.asList(resultOfPresale)
								: " null or size is zero")
						+ "	resultOfAfter is=="
						+ (null != resultOfAfter && 0 != resultOfAfter.size() ? Arrays.asList(resultOfPresale)
								: "null or size is zero"));

				codeOfPresale = resultOfPresale.get("code");
				codeOfAfter = resultOfAfter.get("code");

				if (codeOfPresale.equals("200") && codeOfAfter.equals("200")) {
					log.info("create im account success");
					accidTokenOfPresale = resultOfPresale.get("token");
					accidTokenOfAfter = resultOfAfter.get("token");

					accidOfPresale = resultOfPresale.get("accid");
					accidOfAfter = resultOfAfter.get("accid");

					ImAccount imAccount = new ImAccount();
					imAccount.setAccount(accidOfPresale);
					imAccount.setBelongId(centerId);
					imAccount.setBelongtType(2);
					imAccount.setToken(accidTokenOfPresale);
					imAccount.setCreateAt(System.currentTimeMillis());
					imAccount.setCreateBy(centerId);
					imAccount.setUpdateAt(System.currentTimeMillis());
					imAccount.setUpdateBy(centerId);

					presaleId = imAccountService.insert(imAccount);

					imAccount.setAccount(accidOfAfter);
					imAccount.setBelongId(centerId);
					imAccount.setBelongtType(3);
					imAccount.setToken(accidTokenOfAfter);
					imAccount.setCreateAt(System.currentTimeMillis());
					imAccount.setCreateBy(centerId);
					imAccount.setUpdateAt(System.currentTimeMillis());
					imAccount.setUpdateBy(centerId);

					afterId = imAccountService.insert(imAccount);

					log.info("create im account success,insert to DB success");

					boolean success = imChatUtil.updateCustomerServiceInfo(accidOfPresale, center);
					if (success)
						log.info("update presale customer info success");
					else
						log.info("update presale customer info failed");

					success = imChatUtil.updateCustomerServiceInfo(accidOfAfter, center);
					if (success)
						log.info("update after customer info success");
					else
						log.info("update after customer info failed");

				} else {
					messageOfPresale = resultOfPresale.get("message");
					messageOfAfter = resultOfAfter.get("message");

					log.info("create im account failed,messageOfPresale is==" + messageOfPresale
							+ "	messageOfAfter is==" + messageOfAfter);

					centerService.delete(centerId);

					throw new Exception("register failed,cause create im account failed");
				}
			}

			model.addAttribute("id", centerId);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage(),t);

			log.error("add center error ");
			if (null != t.getMessage() && t.getMessage().equals("register failed,cause create im account failed")) {
				model.addAttribute("code", -26000);
			} else {
				model.addAttribute("code", -6002);
			}

			if (null != presaleId) {
				imAccountService.delete(presaleId);
			}

			if (null != afterId) {
				imAccountService.delete(afterId);
			}

			if (null != centerId) {
				centerService.delete(centerId);
			}
		}

		return "/data/json3";
	}
	//
	//	@RequestMapping(value = "/a/u/center/{id}", method = RequestMethod.DELETE)
	//	public String deleteCenterJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
	//			@PathVariable Long id) throws Exception {
	//
	//		log.info("delete center : id= " + id);
	//		try {
	//			centerService.delete(id);
	//
	//			log.info("add center success");
	//			model.addAttribute("code", 0);
	//
	//		} catch (Throwable t) {
	//			t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("delete center error,id is  " + id);
	//			model.addAttribute("code", -6004);
	//
	//		}
	//
	//		return "/data/json";
	//	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param status
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/status/{status}/center/{id}", method = RequestMethod.PUT)
	public String updateCenterStatusJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long status, @PathVariable Long id) throws Exception {

		log.info("delete center : id= " + id);
		try {
			Center center = centerService.getObjectById(id);
			center.setStatus(status);
			if (center != null) {
				centerService.update(center);
			} else {
				model.addAttribute("code", -100000);
			}

			log.info("add center success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete center error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/center/list", method = RequestMethod.GET)
	public String getMultiCenterJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer page, Integer size) throws Exception {

		try {
			if (page == null) {
				page = 1;
			}
			if (size == null) {
				size = 10;
			}
			int start = (page - 1) * size;
			if (start < 0) {
				start = 0;
			}
			List<Long> ids = new ArrayList<>();
			Map<String, Object> map = new HashMap<>();
			map = DynamicUtil.geCenterByCityIdAndStatus(null, null);
			ids = centerService.getIdsByDynamicCondition(Center.class, map, start, size);
			List<Center> centerList = centerService.getObjectsByIds(ids);
			Integer total = centerService.getIdsByDynamicCondition(Center.class, map, 0, Integer.MAX_VALUE).size();
			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("centerList", centerList);
		} catch (Throwable t) {
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/center/json/centerListJson";
	}

}
