package com.ptteng.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.yi.model.Manager;
import com.ptteng.common.yi.service.ManagerService;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ListUtil;
import com.ptteng.yi.nucleus.model.CardType;
import com.ptteng.yi.nucleus.service.CardTypeService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CardType  crud
 * 
 * @author wangmeng
 * @Date 2017-12-20 13:43
 * 
 */
@Controller
public class CardTypeController {
    private static final Log log = LogFactory.getLog(CardTypeController.class);

    @Autowired
    private CardTypeService cardTypeService;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private CookieUtil cookieUtil;

    /**
     * 查看卡券类型详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.GET)
    public String getCardTypeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {

        log.info("GET request url: /a/u/cardType/{id}, get path variable : id= " + id);
        try {
            CardType cardType = cardTypeService.getObjectById(id);
            log.info("get cardType data is " + cardType);

            if (DataUtils.isNullOrEmpty(cardType)) {
                log.info("no this cardType");
                model.addAttribute("code", -9004);
                return "/common/failure";
            }

            model.addAttribute("code", 0);

            model.addAttribute("cardType", cardType);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get cardType error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/cardType/json/cardTypeDetailJson";
    }

    /**
     * 编辑卡券类型
     * @param request
     * @param response
     * @param model
     * @param id
     * @param cardType
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.PUT)
    public String updateCardTypeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, CardType cardType) throws Exception {

        log.info("PUT request url: /a/u/cardType/{id}, get parameter : cardType= " + cardType);

        if (DataUtils.isNullOrEmpty(cardType)) {
            model.addAttribute("code", -9005);
            log.info("parameter cardType is null");
            return "/common/failure";
        }

        if (StringUtils.isEmpty(cardType.getTitle())) {
            model.addAttribute("code", -9006);
            log.info("parameter title is null or empty");
            return "/common/failure";
        }

        if (StringUtils.isEmpty(cardType.getDescription())) {
            model.addAttribute("code", -9007);
            log.info("parameter description is null or empty");
            return "/common/failure";
        }

        if (StringUtils.isEmpty(cardType.getImg())) {
            model.addAttribute("code", -9008);
            log.info("parameter img is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(cardType.getValue())) {
            model.addAttribute("code", -9032);
            log.info("parameter cardType is null");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(cardType.getExpire())) {
            model.addAttribute("code", -9009);
            log.info("parameter expire is null or empty");
            return "/common/failure";
        }

        if (cardType.getExpire() < 1) {
            model.addAttribute("code", -9010);
            log.info("parameter expire is illegal");
            return "/common/failure";
        }

        if (cardType.getValue() < 1) {
            model.addAttribute("code", -9033);
            log.info("parameter cardType is illegal");
            return "/common/failure";
        }

        try {

            CardType cardType1 = cardTypeService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(cardType1)) {
                log.info("no this cardType");
                model.addAttribute("code", -9011);
                return "/common/failure";
            }

            cardType1.setImg(cardType.getImg());
            cardType1.setDescription(cardType.getDescription());
            cardType1.setTitle(cardType.getTitle());
            cardType1.setValue(cardType.getValue());
            cardType1.setExpire(cardType.getExpire());

            String managerId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            cardType1.setUpdateBy(Long.parseLong(managerId));

            cardTypeService.update(cardType1);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update cardType error,id is  " + cardType.getId());
            model.addAttribute("code", -100000);

        }

        return "/common/success";
    }

    /**
     * 启用/禁用卡券类型
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status 状态
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/cardType/{id}/status", method = RequestMethod.PUT)
    public String updateCardTypeStatusJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, Integer status) throws Exception {

        log.info("PUT request url: /a/u/cardType/{id}/status, get path variable : id= " + id + ", parameter : status= "
                + status);

        if (DataUtils.isNullOrEmpty(status)) {
            model.addAttribute("code", -9003);
            log.info("parameter status is null or empty");
            return "/common/failure";
        }

        if (status > CardType.STATUS_USING || status < CardType.STATUS_BAN) {
            model.addAttribute("code", -9014);
            log.info("parameter status is illegal");
            return "/common/failure";
        }

        try {
            CardType cardType = cardTypeService.getObjectById(id);

            if (DataUtils.isNullOrEmpty(cardType)) {
                log.info("no this cardType");
                model.addAttribute("code", -9011);
                return "/common/failure";
            }

            cardType.setStatus(status);
            String managerId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            cardType.setUpdateBy(Long.parseLong(managerId));

            cardTypeService.update(cardType);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update cardType error,id is  " + id);
            model.addAttribute("code", -100000);

        }

        return "/common/success";
    }

    /**
     * 新增卡券类型
     * @param request
     * @param response
     * @param model
     * @param cardType
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/cardType", method = RequestMethod.POST)
    public String addCardTypeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            CardType cardType) throws Exception {

        log.info("POST request url: /a/u/cardType, get parameter : cardType= " + cardType);

        if (DataUtils.isNullOrEmpty(cardType)) {
            model.addAttribute("code", -9005);
            log.info("parameter cardType is null");
            return "/common/failure";
        }

        if (StringUtils.isEmpty(cardType.getTitle())) {
            model.addAttribute("code", -9006);
            log.info("parameter title is null or empty");
            return "/common/failure";
        }

        if (StringUtils.isEmpty(cardType.getDescription())) {
            model.addAttribute("code", -9007);
            log.info("parameter description is null or empty");
            return "/common/failure";
        }

        if (StringUtils.isEmpty(cardType.getImg())) {
            model.addAttribute("code", -9008);
            log.info("parameter img is null or empty");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(cardType.getValue())) {
            model.addAttribute("code", -9032);
            log.info("parameter cardType is null");
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(cardType.getExpire())) {
            model.addAttribute("code", -9009);
            log.info("parameter expire is null or empty");
            return "/common/failure";
        }

        if (cardType.getExpire() < 0) {
            model.addAttribute("code", -9010);
            log.info("parameter expire is illegal");
            return "/common/failure";
        }

        try {
            cardType.setId(null);
            cardType.setAmount(CardType.INITIAL_VALUE);
            cardType.setExchangedAmount(CardType.INITIAL_VALUE);
            cardType.setVerifiedAmount(CardType.INITIAL_VALUE);
            cardType.setStatus(CardType.STATUS_BAN);

            String managerId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            cardType.setCreateBy(Long.parseLong(managerId));
            cardType.setUpdateBy(Long.parseLong(managerId));

            Long result = cardTypeService.insert(cardType);
            log.info("insert cardType id is: " + result);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add cardType error ");
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    //	@RequestMapping(value = "/a/u/cardType/{id}", method = RequestMethod.DELETE)
    //	public String deleteCardTypeJson(HttpServletRequest request,
    //			HttpServletResponse response, ModelMap model, @PathVariable Long id)
    //			throws Exception {
    //
    //		log.info("delete cardType : id= " + id);
    //		try {
    //			cardTypeService.delete(id);
    //
    //			log.info("add cardType success");
    //			model.addAttribute("code", 0);
    //
    //		} catch (Throwable t) {
    //		    t.printStackTrace();
    //			log.error(t.getMessage());
    //			log.error("delete cardType error,id is  " + id);
    //			model.addAttribute("code", -6004);
    //
    //		}
    //
    //		return "/data/json";
    //	}

    /**
     * 获取卡券类型列表
     * @param request
     * @param response
     * @param model
     * @param title 标题名称
     * @param creator 创建人角色名
     * @param createAtStart 创建时间起
     * @param createAtEnd 创建时间止
     * @param status 状态
     * @param value 价值
     * @param page
     * @param size
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/cardType/list", method = RequestMethod.GET)
    public String getMultiCardTypeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            String title, String creator, Long createAtStart, Long createAtEnd, Integer status, Integer value,
            Integer page, Integer size) throws Exception {

        log.info("GET request url: /a/u/cardType/list, get parameter title: " + title + ", creator: " + creator
                + ", createAtStart: " + createAtStart + ", createAtEnd: " + createAtEnd + ", status: " + status
                + ", value: " + value + ", page: " + page + ", size: " + size);

        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Map<String, Object> map = DynamicUtil.getCardTypeListParams(title, creator, createAtStart, createAtEnd,
                    value, status, false);
            log.info("query cardType map = " + map);

            List<Long> cids = cardTypeService.getIdsByDynamicCondition(CardType.class, map, start, size);
            log.info("get dynamic query cardType list ids is: " + cids);

            Integer total = cardTypeService.getIdsByDynamicCondition(CardType.class, map, 0, Integer.MAX_VALUE).size();
            log.info("get dynamic query cardType total is: " + total);

            if (CollectionUtils.isEmpty(cids)) {
                model.addAttribute("cardTypeList", new ArrayList());
                model.addAttribute("cid_managerName", new HashMap());
                model.addAttribute("code", 0);
            } else {
                List<CardType> cardTypeList = cardTypeService.getObjectsByIds(cids);
                log.info("get cardType list size is " + cardTypeList.size());

                List<Long> managerIds = MyListUtil.getFieldValueListFromModelList(cardTypeList, false,
                        CardType.class.getDeclaredField("createBy"));
                List<Manager> managerList = managerService.getObjectsByIds(managerIds);

                List<String> managerNames = MyListUtil.getFieldValueListFromModelList(managerList, false,
                        Manager.class.getDeclaredField("name"));
                Map<Long, String> cid_managerName = ListUtil.convert2Map(cids, managerNames);

                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("size", size);
                model.addAttribute("total", total);

                model.addAttribute("cardTypeList", cardTypeList);
                model.addAttribute("cid_managerName", cid_managerName);
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get cardType error, start is  " + start + " , size " + size);
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/cardType/json/cardTypeListJson";
    }

    /**
     * 获取 可用的/所有 卡券类型列表
     * @param request
     * @param response
     * @param model
     * @param available 可用1/所有0
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/cardType/list/available", method = RequestMethod.GET)
    public String getAvailableCardTypeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer available) throws Exception {

        log.info("GET request url: /a/u/cardType/list/available, get parameter available : " + available);

        if (DataUtils.isNullOrEmpty(available)) {
            model.addAttribute("code", -9028);
            log.info("parameter available is null or empty");
            return "/common/failure";
        }

        if (available > 1 || available < 0) {
            model.addAttribute("code", -9029);
            log.info("parameter available is illegal");
            return "/common/failure";
        }

        try {
            List<Long> cardTypeIds;
            if (available == 1) {
                cardTypeIds = cardTypeService.getCardTypeIdsByStatusOrderByCreateBy(CardType.STATUS_USING, 0,
                        Integer.MAX_VALUE);
                log.info("get available cardType id list : " + cardTypeIds);
            } else {
                cardTypeIds = cardTypeService.getCardTypeIds(0, Integer.MAX_VALUE);
                log.info("get available cardType id list : " + cardTypeIds);
            }

            if (CollectionUtils.isEmpty(cardTypeIds)) {
                model.addAttribute("cardTypeList", new ArrayList());
                model.addAttribute("code", 0);
            } else {
                List<CardType> cardTypeList = cardTypeService.getObjectsByIds(cardTypeIds);
                model.addAttribute("cardTypeList", cardTypeList);
                model.addAttribute("total", cardTypeList.size());
                model.addAttribute("code", 0);
            }

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get available cardType list error ");
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/cardType/json/availableCardTypeListJson";
    }

}
