package com.ptteng.controller;

import com.ptteng.yi.nucleus.model.Car;
import com.ptteng.yi.nucleus.service.CarService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Car  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class CarController {
	private static final Log log = LogFactory.getLog(CarController.class);

	@Autowired
	private CarService carService;

	@RequestMapping(value = "/a/u/car/list ", method = RequestMethod.GET)
	public String getCarIdsByCityIdJsonList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer page, Integer size, Long cityId) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = carService.getCarIdsByCityId(cityId, start, size);
			log.info("get countCarIdsByCityId size is " + ids.size());

			List<Car> carList = carService.getObjectsByIds(ids);
			log.info("get car data is " + carList.size());

			Integer total = carService.countCarIdsByCityId(cityId);
			log.info("get car count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("carList", carList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get car list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/car/json/carListJson";
	}

	@RequestMapping(value = "/a/u/car/{id}", method = RequestMethod.GET)
	public String getCarJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Car car = carService.getObjectById(id);
			log.info("get car data is " + car);

			model.addAttribute("code", 0);

			model.addAttribute("car", car);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get car error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/car/json/carDetailJson";
	}

	@RequestMapping(value = "/a/u/car/{id}", method = RequestMethod.PUT)
	public String updateCarJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Car car,
			@PathVariable Long id) throws Exception {

		log.info("update car : car= " + car);

		try {
			Car oCar = carService.getObjectById(id);

			if (car.getCar() == null) {
				model.addAttribute("code", -7000);
				log.info(" manager roleid is null");
				return "/data/json";
			}
			oCar.setCar(car.getCar());
			carService.update(oCar);

			model.addAttribute("code", 0);

			model.addAttribute("car", car);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update car error,id is  " + car.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/car", method = RequestMethod.POST)
	public String addCarJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Car car,
			Long managerId) throws Exception {

		log.info("update car : car= " + car);

		try {

			car.setCreateBy(managerId);
			car.setUpdateBy(managerId);
			car.setId(null);

			carService.insert(car);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add car error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/car/{id}", method = RequestMethod.DELETE)
	public String deleteCarJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete car : id= " + id);
		try {
			carService.delete(id);

			log.info("add car success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete car error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/multi/car", method = RequestMethod.GET)
	public String getMultiCarJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Car> carList = carService.getObjectsByIds(idList);
			log.info("get  car data is " + carList);

			model.addAttribute("code", 0);
			model.addAttribute("total", carList.size());

			model.addAttribute("carList", carList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get car error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/car/json/carListJson";
	}

}
