package com.ptteng.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.service.CoachService;
import com.ptteng.yi.nucleus.service.StudentsService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.AppointOrder;
import com.ptteng.yi.nucleus.service.AppointOrderService;

/**
 * AppointOrder  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class AppointOrderController {
	private static final Log log = LogFactory.getLog(AppointOrderController.class);

	@Autowired
	private AppointOrderService appointOrderService;
	@Autowired
	private StudentsService studentsService;
	@Autowired
	private CoachService coachService;

	/**
	 * 获取订单列表
	 * @param request
	 * @param response
	 * @param model
	 * @param orderTimeStart
	 * @param orderTimeEnd
	 * @param practiceTimeStart
	 * @param practiceTimeEnd
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/appoint/order/list", method = RequestMethod.GET)
	public String getCarOrderEvaluateList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Integer type, Integer subject, String score, Long orderTimeStart, Long orderTimeEnd, String studentMobile,
			String coachMobile, Long practiceTimeStart, Long practiceTimeEnd, Integer page, Integer size,Long cityId,Long schoolId)
			throws Exception {
		log.info(" type is " + type + " subject is " + subject + " score is " + score + " orderTimeStart is "
				+ orderTimeStart + " orderTimeEnd is " + orderTimeEnd + " studentMobile is " + studentMobile
				+ " coachMobile is " + coachMobile + " practiceTimeStart is " + practiceTimeStart
				+ " practiceTimeEnd is " + practiceTimeEnd + " page is " + page + " size is " + size);
		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		List<String> typeList = new ArrayList<>();
		if (DataUtils.isNotNullOrEmpty(type)) {
			if (Integer.valueOf(type).equals(AppointOrder.STUDENT_PENDING_COACH_CANCEL)) {
				typeList.add(AppointOrder.STUDENT_PENDING_COACH_CANCEL_INQUIRE);
			}
			if (Integer.valueOf(type).equals(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED)) {
				typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
				typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
				typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
			}
			if (Integer.valueOf(type).equals(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED)) {
				typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
				typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);
			}
			if (Integer.valueOf(type).equals(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL)) {
				typeList.add(AppointOrder.ORDER_SOLD_INQUIRE);
			}
			if (Integer.valueOf(type).equals(AppointOrder.ORDER_COMPLETED_EVALUATED_NO)) {
				typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
			}
			if (Integer.valueOf(type).equals(AppointOrder.ORDER_COMPLETED_EVALUATED_YES)) {
				typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);
			}
		} else {
			typeList = null;
		}

		try {
			Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, null, null, null, null, null, subject,
					orderTimeStart, orderTimeEnd, practiceTimeStart, practiceTimeEnd, score, coachMobile,
					studentMobile,schoolId,cityId);
			log.info("map is " + map);
			List<Long> ids = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, start, size);
			log.info("ids is " + ids);
			Integer total = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0, Integer.MAX_VALUE)
					.size();
			List<AppointOrder> appointOrderList=new ArrayList<>();
			if(CollectionUtils.isNotEmpty(ids)){
				appointOrderList = appointOrderService.getObjectsByIds(ids);
			}
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("appointOrderList", appointOrderList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/appointOrder/json/appointOrderList";
	}

	/**
	 * 消单
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/appoint/order/{id}", method = RequestMethod.DELETE)
	public String carOrderEvaluate(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {
		log.info(" id is " + id);
		try {
			AppointOrder appointOrder = appointOrderService.getObjectById(id);
			if (DataUtils.isNullOrEmpty(appointOrder)) {
				model.addAttribute("code", -25000);
				log.info("appointOrder is null or empty");
				return "/common/failure";
			}
			log.info("appointOrder is "+appointOrder);
			appointOrderService.delete(id);
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			model.addAttribute("code", -100000);
		}

		return "/common/success";
	}

}
