package com.ptteng.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.AdvanceTime;
import com.ptteng.yi.nucleus.service.AdvanceTimeService;

/**
 * AdvanceTime  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class AdvanceTimeController {
	private static final Log log = LogFactory.getLog(AdvanceTimeController.class);

	@Autowired
	private AdvanceTimeService advanceTimeService;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/advanceTime", method = RequestMethod.GET)
	public String getadvanceTimeList(HttpServletRequest request, HttpServletResponse response, ModelMap model)
			throws Exception {

		log.info("/advanceTime  to /advanceTime/view/advanceTimeList");

		return "/yi-nucleus-service/advanceTime/view/advanceTimeList";
	}

	/**
	*
	* @param
	* @return
	* @throws ServiceException
	* @throws ServiceDaoException
	*/

	@RequestMapping(value = "/c/advanceTime1 ", method = RequestMethod.GET)
	public String getAdvanceTimeIdsBySubjectAndCoachTimeIdOrderByCreateByList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, int subject, Long coachTimeId) throws Exception {

		log.info("/advanceTime  to /advanceTime/view/advanceTimeList");

		return "/yi-nucleus-service/advanceTime/view/advanceTimeList";
	}

	@RequestMapping(value = "/c/advanceTime/{id}", method = RequestMethod.GET)
	public String getAdvanceTime(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("/advanceTime/" + id + "  to /advanceTime/view/advanceTimeDeail");
		if (null != id) {
			model.addAttribute("id", id);
		} else {
			model.addAttribute("id", 0);
		}

		return "/yi-nucleus-service/advanceTime/view/advanceTimeDetail";
	}

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/advanceTime1 ", method = RequestMethod.GET)
	public String getAdvanceTimeIdsBySubjectAndCoachTimeIdOrderByCreateByJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size, int subject, Long coachTimeId)
			throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = advanceTimeService.getAdvanceTimeIdsBySubjectAndCoachTimeIdOrderByCreateBy(subject,
					coachTimeId, start, size);
			log.info("get countAdvanceTimeIdsBySubjectAndCoachTimeIdOrderByCreateBy size is " + ids.size());

			List<AdvanceTime> advanceTimeList = advanceTimeService.getObjectsByIds(ids);
			log.info("get advanceTime data is " + advanceTimeList.size());

			Integer total = advanceTimeService.countAdvanceTimeIdsBySubjectAndCoachTimeIdOrderByCreateBy(subject,
					coachTimeId);
			log.info("get advanceTime count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("advanceTimeList", advanceTimeList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get advanceTime list error,page is  " + start + " , size " + size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/advanceTime/json/advanceTimeListJson";
	}

	@RequestMapping(value = "/a/advanceTime/{id}", method = RequestMethod.GET)
	public String getAdvanceTimeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			AdvanceTime advanceTime = advanceTimeService.getObjectById(id);
			log.info("get advanceTime data is " + advanceTime);

			model.addAttribute("code", 0);

			model.addAttribute("advanceTime", advanceTime);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get advanceTime error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/advanceTime/json/advanceTimeDetailJson";
	}

	@RequestMapping(value = "/a/advanceTime/{id}", method = RequestMethod.PUT)
	public String updateAdvanceTimeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			AdvanceTime advanceTime) throws Exception {

		log.info("update advanceTime : advanceTime= " + advanceTime);

		try {

			advanceTimeService.update(advanceTime);

			model.addAttribute("code", 0);

			model.addAttribute("advanceTime", advanceTime);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update advanceTime error,id is  " + advanceTime.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/advanceTime", method = RequestMethod.POST)
	public String addAdvanceTimeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			AdvanceTime advanceTime) throws Exception {

		log.info("update advanceTime : advanceTime= " + advanceTime);

		try {
			advanceTime.setId(null);

			advanceTimeService.insert(advanceTime);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add advanceTime error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/advanceTime/{id}", method = RequestMethod.DELETE)
	public String deleteAdvanceTimeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("delete advanceTime : id= " + id);
		try {
			advanceTimeService.delete(id);

			log.info("add advanceTime success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete advanceTime error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/multi/advanceTime", method = RequestMethod.GET)
	public String getMultiAdvanceTimeJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			Long[] ids) throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<AdvanceTime> advanceTimeList = advanceTimeService.getObjectsByIds(idList);
			log.info("get  advanceTime data is " + advanceTimeList);

			model.addAttribute("code", 0);
			model.addAttribute("total", advanceTimeList.size());

			model.addAttribute("advanceTimeList", advanceTimeList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get advanceTime error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/advanceTime/json/advanceTimeListJson";
	}

}
