package com.ptteng.xqlease.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.Topic;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface TopicService extends BaseDaoService {

	



   		   
		
		public Long insert(Topic topic)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Topic> insertList(List<Topic> topicList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Topic topic)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Topic> topicList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Topic getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Topic> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;





			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getTopicIdByTopicName(String topicName)throws ServiceException, ServiceDaoException;


	public List<Long>  getTopicIdsByShelfStatus(Integer shelfStatus,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getTopicIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countTopicIds() throws ServiceException, ServiceDaoException;
	


	public List<Long> getTopicIdsOrderByShelfStatusAndSortAndUpdateAt(Integer start,Integer limit)throws ServiceException, ServiceDaoException;

}

