package com.ptteng.xqlease.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.GoodsSort;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface GoodsSortService extends BaseDaoService {

	



   		   
		
		public Long insert(GoodsSort goodsSort)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<GoodsSort> insertList(List<GoodsSort> goodsSortList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(GoodsSort goodsSort)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<GoodsSort> goodsSortList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public GoodsSort getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<GoodsSort> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGoodsSortIdsBySortLevelOrderBySort(Integer sortLevel)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGoodsSortIdsByShelfStatusOrderBySort(Integer shelfStatus)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countGoodsSortIdsBySortNameOrderBySort(String sortName)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getGoodsSortIdsBySortLevelOrderBySort(Integer sortLevel, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getGoodsSortIdsByShelfStatusOrderBySort(Integer shelfStatus, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
    public Long  getGoodsSortIdBySortNameOrderBySort(String sortName)throws ServiceException, ServiceDaoException;
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getGoodsSortIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countGoodsSortIds() throws ServiceException, ServiceDaoException;


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long>  getGoodsSortIdsByFatherIdOrderBySort(Long fatherId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


}

