package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "version")
public class Version implements Serializable, Comparable<Version> {

    /**
     *
     */
    private static final long serialVersionUID = 965174674511656960L;
    /**安卓*/
    public static final String OS_ANDROID = "android";
    public static final String OS_IOS = "ios";
    public static final String OS_WEB = "web";

    private Long id;


    private String url;


    private String versionCode;


    private String info;


    private String summary;

    private String type;

    private String os;

    private Boolean isForceUpdate;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    @Column(name = "type")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "url")
    public String getUrl() {
        return url;
    }


    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name = "version_code")
    public String getVersionCode() {
        return versionCode;
    }


    public void setVersionCode(String versionCode) {
        this.versionCode = versionCode;
    }

    @Column(name = "info")
    public String getInfo() {
        return info;
    }


    public void setInfo(String info) {
        this.info = info;
    }

    @Column(name = "summary")
    public String getSummary() {
        return summary;
    }


    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Column(name = "os")
    public String getOs() {
        return os;
    }


    public void setOs(String os) {
        this.os = os;
    }

    @Column(name = "is_force_update")
    public Boolean getIsForceUpdate() {
        return isForceUpdate;
    }


    public void setIsForceUpdate(Boolean isForceUpdate) {
        this.isForceUpdate = isForceUpdate;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public int compareTo(Version o) {


        String mykey = o.getVersionCode();
        String thisMykey = this.getVersionCode();
        int result = compareCode(mykey, thisMykey);

        return result;

    }


    public int compareCode(String a, String b) {
        String[] aList = a.split("\\.");
        String[] bList = b.split("\\.");

        if (Integer.valueOf(aList[0]) > Integer.valueOf(bList[0])) {
            return 1;
        } else if (Integer.valueOf(aList[0]) < Integer.valueOf(bList[0])) {
            return -1;
        } else if (Integer.valueOf(aList[1]) > Integer.valueOf(bList[1])) {
            return 1;
        } else if (Integer.valueOf(aList[1]) < Integer.valueOf(bList[1])) {
            return -1;
        } else if (Integer.valueOf(aList[2]) > Integer.valueOf(bList[2])) {
            return 1;
        } else if (Integer.valueOf(aList[2]) < Integer.valueOf(bList[2])) {
            return -1;
        } else {
            return 0;
        }
    }

}

