package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "trading_flow")
public class TradingFlow implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 7903725404860718080L;

    //tradingSort：交易流水分类 1-余额 2-押金
    public static final Integer TRADING_SORT_BALANCE = 1;
    public static final Integer TRADING_SORT_DEPOSIT = 2;


    //recordType：交易流水记录类型 1-收入 2-支出
    public static final Integer RECORD_TYPE_INCOME = 1;
    public static final Integer RECORD_TYPE_EXPENDITURE = 2;


    //transactionType：交易流水的交易类型  10-充值 20-提现 30-账单支付 40-账单支付后的退款 50-支付订单产生的押金 60-退押金
    public static final Integer TRANSACTION_TYPE_RECHARGE = 10;
    public static final Integer TRANSACTION_TYPE_WITHDRAW = 20;
    public static final Integer TRANSACTION_TYPE_BILL_PAYMENT = 30;
    public static final Integer TRANSACTION_TYPE_REFUND = 40;
    public static final Integer TRANSACTION_TYPE_ORDER_PAYMENT = 50;
    public static final Integer TRANSACTION_TYPE_RETURN_KEEPFEE = 60;


    private Long id;


    private String serialNum;


    private Long uid;


    private Integer tradingSort;


    private Integer recordType;


    private Integer transactionType;


    private BigDecimal transactionAmount;


    private Long transactionTime;


    private BigDecimal balance;


    private String ordersNum;


    private String deviceSerialNum;


    private String goodsName;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "serial_num")
    public String getSerialNum() {
        return serialNum;
    }


    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "trading_sort")
    public Integer getTradingSort() {
        return tradingSort;
    }


    public void setTradingSort(Integer tradingSort) {
        this.tradingSort = tradingSort;
    }

    @Column(name = "record_type")
    public Integer getRecordType() {
        return recordType;
    }


    public void setRecordType(Integer recordType) {
        this.recordType = recordType;
    }

    @Column(name = "transaction_type")
    public Integer getTransactionType() {
        return transactionType;
    }


    public void setTransactionType(Integer transactionType) {
        this.transactionType = transactionType;
    }

    @Column(name = "transaction_amount")
    public BigDecimal getTransactionAmount() {
        return transactionAmount;
    }


    public void setTransactionAmount(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    @Column(name = "transaction_time")
    public Long getTransactionTime() {
        return transactionTime;
    }


    public void setTransactionTime(Long transactionTime) {
        this.transactionTime = transactionTime;
    }

    @Column(name = "balance")
    public BigDecimal getBalance() {
        return balance;
    }


    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    @Column(name = "orders_num")
    public String getOrdersNum() {
        return ordersNum;
    }


    public void setOrdersNum(String ordersNum) {
        this.ordersNum = ordersNum;
    }

    @Column(name = "device_serial_num")
    public String getDeviceSerialNum() {
        return deviceSerialNum;
    }


    public void setDeviceSerialNum(String deviceSerialNum) {
        this.deviceSerialNum = deviceSerialNum;
    }

    @Column(name = "goods_name")
    public String getGoodsName() {
        return goodsName;
    }


    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

