package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.omg.CORBA.PUBLIC_MEMBER;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "rent_orders_log")
public class RentOrdersLog implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3300428407266512896L;


    /**
     * createrSort：租赁订单日志操作人类型 1-前台用户 2-后台用户
     */

    public static final int CREATER_HOME = 1;
    public static final int CREATER_ADMIN = 2;


    /**
     * operationAction:租赁订单日志操作类型
     * 10-编辑订单地址  20-创建订单 30-用户取消订单 35-后台管理取消订单 40-支付订单 50-订单发货
     * 60-订单完成 70-提交退款审核 80-取消订单审核通过 90-取消订单审核不通过 100-订单返货 110-订单到期
     */

    public static final int ORDER_EDIT = 10;
    public static final int ORDER_CREATE = 20;
    public static final int ORDER_CANCEL_BY_USER = 30;
    public static final int ORDER_CANCEL_BY_MANAGER = 35;
    public static final int ORDER_PAYED = 40;
    public static final int ORDER_SEND = 50;
    public static final int ORDER_COMPLETE = 60;
    public static final int ORDER_CANCELLED_CHECK = 70;
    public static final int ORDER_CANCELLED_CHECK_YES = 80;
    public static final int ORDER_CANCELLED_CHECK_NO = 90;
    public static final int ORDER_RETURN = 100;
    public static final int ORDER_END = 110;


    private Long id;


    private Long oid;


    private Integer orderStatus;


    private Integer operationAction;


    private String createrName;


    private Integer createrSort;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "oid")
    public Long getOid() {
        return oid;
    }


    public void setOid(Long oid) {
        this.oid = oid;
    }

    @Column(name = "order_status")
    public Integer getOrderStatus() {
        return orderStatus;
    }


    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    @Column(name = "operation_action")
    public Integer getOperationAction() {
        return operationAction;
    }


    public void setOperationAction(Integer operationAction) {
        this.operationAction = operationAction;
    }

    @Column(name = "creater_name")
    public String getCreaterName() {
        return createrName;
    }


    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Column(name = "creater_sort")
    public Integer getCreaterSort() {
        return createrSort;
    }


    public void setCreaterSort(Integer createrSort) {
        this.createrSort = createrSort;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

