package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "rent_orders")
public class RentOrders implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5343776611044542464L;


    /**
     * 订单状态 待付款
     */
    public static final int TO_PAYING = 10;
    /**
     * 订单状态 待发货
     */
    public static final int TO_SENDING = 20;
    /**
     * 订单状态 已发货/待收货
     */
    public static final int TO_GETTING = 30;
    /**
     * 订单状态 租赁中
     */
    public static final int IN_LEASING = 40;
    /**
     * 订单状态 已完成
     */
    public static final int ORDERS_COMPLITED = 50;
    /**
     * 订单状态 已取消
     */
    public static final int ORDERS_CANCELLED = 60;
    /**
     * 订单状态 审核中
     */
    public static final int ORDERS_CHECKING = 70;

    /**
     * 订单状态 付款失败
     */
    public static final int ORDERS_PAY_FAIL = 80;

    /**
     * 订单状态 已到期
     */
    public static final int ORDERS_MATURITY = 90;

    /**
     * 订单状态 返货中
     */
    public static final int ORDERS_RETURN = 100;


    /**
     * 审核通过
     */
    public static final Integer CHECKING_PASSED = 1;
    /**
     * 审核不通过
     */
    public static final Integer CHECKING_DENIED = 2;


    /**
     * 未打印
     */
    public static final Integer PRINTED_NO = 1;
    /**
     * 已打印
     */
    public static final Integer PRINTED_YES = 2;

    /**
     * 用户自提
     */
    public static final Integer USER_PICK = 10;
    /**
     * 德邦快递
     */
    public static final Integer DELIVERY_PICK = 20;
    /**
     * 公司送货
     */
    public static final int COMPANY_PICK = 30;


    /**
     * payMethod：支付方式 10-线下支付  20-微信(小程序)支付 25-微信PC端支付 30-支付宝支付 40-网银支付
     * 50-账户余额扣款
     */
    public static final int OFFLINE_PAY = 10;
    public static final int WX_MINIPROGRAM_PAY = 20;
    public static final int WX_PC_PAY = 25;
    public static final int ALI_PAY = 30;
    public static final int ONLINE_BANK_PAY = 40;
    public static final int ACCOUNT_PAY = 50;

    /**
     * payMode:1-短租（全额付款） 10-月付   20-季付  30-半年付 40-年付 50-二年全额付 60-三年全额付
     */
    public static final int PAY_MODE_SHORT = 1;
    public static final int PAY_MODE_MONTH = 10;
    public static final int PAY_MODE_SEASON = 20;
    public static final int PAY_MODE_HALF_YEAR = 30;
    public static final int PAY_MODE_1_YEAR = 40;
    public static final int PAY_MODE_2_YEAR = 50;
    public static final int PAY_MODE_3_YEAR = 60;

    /**  ordersType 0=父订单 1=子订单 */
    public  static  final  int FATHER_ORDERS=0;
    public  static  final  int SUB_ORDERS=1;


    private Long id;


    private Long uid;


    private String userName;


    private String ordersNumber;


    private Integer ordersType;


    private String parentOrdersNumber;


    private Integer ordersStatus;


    private String receiver;


    private String receiveProvince;


    private String receiveCity;


    private String receiveDistrict;


    private String receiveDetail;


    private String receivePhone;


    private Integer pickupMethod;


    private String userRemarks;


    private Integer payMethod;


    private String payAccount;


    private Long skuId;


    private String skuAttributes;


    private String goodsName;


    private Integer skuAmount;


    private String goodsImgPc;
    private String goodsImgWx;

    private Integer random;


    private Integer payMode;


    private BigDecimal totalFee;


    private BigDecimal transportationFee;


    private BigDecimal keepFee;


    private String securityName;


    private BigDecimal securityFee;


    private BigDecimal firstRentFee;


    private String discountName;


    private BigDecimal discountFee;


    private Long rentStart;


    private Integer rentPeriod;


    private String rentFee;


    private Integer printStatus;


    private Long sendAt;

    private Long endAt;

    private Long finishAt;


    private Long backRemarksId;


    private String paymentNumber;
    private Long  paymentAt;


    private String deliveryNum;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "user_name")
    public String getUserName() {
        return userName;
    }


    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name = "orders_number")
    public String getOrdersNumber() {
        return ordersNumber;
    }


    public void setOrdersNumber(String ordersNumber) {
        this.ordersNumber = ordersNumber;
    }

    @Column(name = "orders_type")
    public Integer getOrdersType() {
        return ordersType;
    }


    public void setOrdersType(Integer ordersType) {
        this.ordersType = ordersType;
    }

    @Column(name = "parent_orders_number")
    public String getParentOrdersNumber() {
        return parentOrdersNumber;
    }


    public void setParentOrdersNumber(String parentOrdersNumber) {
        this.parentOrdersNumber = parentOrdersNumber;
    }

    @Column(name = "orders_status")
    public Integer getOrdersStatus() {
        return ordersStatus;
    }


    public void setOrdersStatus(Integer ordersStatus) {
        this.ordersStatus = ordersStatus;
    }

    @Column(name = "receiver")
    public String getReceiver() {
        return receiver;
    }


    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Column(name = "receive_province")
    public String getReceiveProvince() {
        return receiveProvince;
    }


    public void setReceiveProvince(String receiveProvince) {
        this.receiveProvince = receiveProvince;
    }

    @Column(name = "receive_city")
    public String getReceiveCity() {
        return receiveCity;
    }


    public void setReceiveCity(String receiveCity) {
        this.receiveCity = receiveCity;
    }

    @Column(name = "receive_district")
    public String getReceiveDistrict() {
        return receiveDistrict;
    }


    public void setReceiveDistrict(String receiveDistrict) {
        this.receiveDistrict = receiveDistrict;
    }

    @Column(name = "receive_detail")
    public String getReceiveDetail() {
        return receiveDetail;
    }


    public void setReceiveDetail(String receiveDetail) {
        this.receiveDetail = receiveDetail;
    }

    @Column(name = "receive_phone")
    public String getReceivePhone() {
        return receivePhone;
    }


    public void setReceivePhone(String receivePhone) {
        this.receivePhone = receivePhone;
    }

    @Column(name = "pickup_method")
    public Integer getPickupMethod() {
        return pickupMethod;
    }


    public void setPickupMethod(Integer pickupMethod) {
        this.pickupMethod = pickupMethod;
    }

    @Column(name = "user_remarks")
    public String getUserRemarks() {
        return userRemarks;
    }


    public void setUserRemarks(String userRemarks) {
        this.userRemarks = userRemarks;
    }

    @Column(name = "pay_method")
    public Integer getPayMethod() {
        return payMethod;
    }


    public void setPayMethod(Integer payMethod) {
        this.payMethod = payMethod;
    }

    @Column(name = "pay_account")
    public String getPayAccount() {
        return payAccount;
    }


    public void setPayAccount(String payAccount) {
        this.payAccount = payAccount;
    }

    @Column(name = "sku_id")
    public Long getSkuId() {
        return skuId;
    }


    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    @Column(name = "sku_attributes")
    public String getSkuAttributes() {
        return skuAttributes;
    }


    public void setSkuAttributes(String skuAttributes) {
        this.skuAttributes = skuAttributes;
    }

    @Column(name = "goods_name")
    public String getGoodsName() {
        return goodsName;
    }


    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    @Column(name = "sku_amount")
    public Integer getSkuAmount() {
        return skuAmount;
    }


    public void setSkuAmount(Integer skuAmount) {
        this.skuAmount = skuAmount;
    }

    @Column(name = "goods_img_pc")
    public String getGoodsImgPc() {
        return goodsImgPc;
    }


    public void setGoodsImgPc(String goodsImgPc) {
        this.goodsImgPc = goodsImgPc;
    }


    @Column(name = "goods_img_wx")
    public String getGoodsImgWx() {
        return goodsImgWx;
    }


    public void setGoodsImgWx(String goodsImgWx) {
        this.goodsImgWx = goodsImgWx;
    }

    @Column(name = "pay_mode")
    public Integer getPayMode() {
        return payMode;
    }


    public void setPayMode(Integer payMode) {
        this.payMode = payMode;
    }

    @Column(name = "total_fee")
    public BigDecimal getTotalFee() {
        return totalFee;
    }


    public void setTotalFee(BigDecimal totalFee) {
        this.totalFee = totalFee;
    }

    @Column(name = "transportation_fee")
    public BigDecimal getTransportationFee() {
        return transportationFee;
    }


    public void setTransportationFee(BigDecimal transportationFee) {
        this.transportationFee = transportationFee;
    }

    @Column(name = "keep_fee")
    public BigDecimal getKeepFee() {
        return keepFee;
    }


    public void setKeepFee(BigDecimal keepFee) {
        this.keepFee = keepFee;
    }

    @Column(name = "security_name")
    public String getSecurityName() {
        return securityName;
    }


    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    @Column(name = "security_fee")
    public BigDecimal getSecurityFee() {
        return securityFee;
    }


    public void setSecurityFee(BigDecimal securityFee) {
        this.securityFee = securityFee;
    }

    @Column(name = "first_rent_fee")
    public BigDecimal getFirstRentFee() {
        return firstRentFee;
    }


    public void setFirstRentFee(BigDecimal firstRentFee) {
        this.firstRentFee = firstRentFee;
    }

    @Column(name = "discount_name")
    public String getDiscountName() {
        return discountName;
    }


    public void setDiscountName(String discountName) {
        this.discountName = discountName;
    }

    @Column(name = "discount_fee")
    public BigDecimal getDiscountFee() {
        return discountFee;
    }


    public void setDiscountFee(BigDecimal discountFee) {
        this.discountFee = discountFee;
    }

    @Column(name = "rent_start")
    public Long getRentStart() {
        return rentStart;
    }


    public void setRentStart(Long rentStart) {
        this.rentStart = rentStart;
    }

    @Column(name = "rent_period")
    public Integer getRentPeriod() {
        return rentPeriod;
    }


    public void setRentPeriod(Integer rentPeriod) {
        this.rentPeriod = rentPeriod;
    }

    @Column(name = "rent_fee")
    public String getRentFee() {
        return rentFee;
    }


    public void setRentFee(String rentFee) {
        this.rentFee = rentFee;
    }

    @Column(name = "print_status")
    public Integer getPrintStatus() {
        return printStatus;
    }


    public void setPrintStatus(Integer printStatus) {
        this.printStatus = printStatus;
    }

    @Column(name = "send_at")
    public Long getSendAt() {
        return sendAt;
    }


    public void setSendAt(Long sendAt) {
        this.sendAt = sendAt;
    }


    @Column(name = "end_at")
    public Long getEndAt() {
        return endAt;
    }


    public void setEndAt(Long endAt) {
        this.endAt = endAt;
    }


    @Column(name = "finish_at")
    public Long getFinishAt() {
        return finishAt;
    }


    public void setFinishAt(Long finishAt) {
        this.finishAt = finishAt;
    }

    @Column(name = "back_remarks_id")
    public Long getBackRemarksId() {
        return backRemarksId;
    }


    public void setBackRemarksId(Long backRemarksId) {
        this.backRemarksId = backRemarksId;
    }


    @Column(name = "payment_number")
    public String getPaymentNumber() {
        return paymentNumber;
    }


    public void setPaymentNumber(String paymentNumber) {
        this.paymentNumber = paymentNumber;
    }

    @Column(name = "payment_at")
    public Long getPaymentAt() {
        return paymentAt;
    }


    public void setPaymentAt(Long paymentAt) {
        this.paymentAt = paymentAt;
    }


    @Column(name = "delivery_num")
    public String getDeliveryNum() {
        return deliveryNum;
    }


    public void setDeliveryNum(String deliveryNum) {
        this.deliveryNum = deliveryNum;
    }

    @Column(name = "random")
    public Integer getRandom(){
        return random;
    }

    public void setRandom(Integer random){
        this.random=random;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

