package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "refund_orders")
public class RefundOrders implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4549027277170819072L;

    /**
     * 订单状态 待付款
     */
    public static final Integer TO_PAYING = 10;

    /**
     * 退货退款：11小强未收货（有退款单，但是不能支付）  12小强已收货（有退款单，可以支付了）
     */
    public static final Integer TO_PAYING_NOT_RECEIVE = 11;
    public static final Integer TO_PAYING_RECEIVED = 12;


    /**
     * 订单状态 已完成
     */
    public static final Integer ORDERS_COMPLITED = 50;

    /**
     * 订单状态 已拒绝
     */
    public static final Integer ORDERS_REFUSED = 60;


    /**
     * 付款失败
     */
    public static final Integer ORDERS_FAILURE = 80;

    /**
     * ordersType  提现退款订单=10 退货退款订单=20 租赁订单取消=30
     */
    public static final Integer WITHDRAW_REFUND_ORDERS_TYPE = 10;
    public static final Integer RETURN_REFUND_ORDERS_TYPE = 20;
    public static final Integer RENT_ORDERS_COMPLETE = 30;

    /**
     * 退款单支付方式  线下=10  线下支付宝=11  线下微信=12  线下网银=13
     * 线上  20-微信（小程序）支付    25-微信pc支付   30-支付宝支付 40-网银支付
     */
    public static final Integer PAY_OFF_LINE = 10;
    public static final Integer PAY_OFF_LINE_ALI = 11;
    public static final Integer PAY_OFF_LINE_WX = 12;
    public static final Integer PAY_OFF_LINE_YL = 13;
    public static final Integer PAY_ON_LINE_WX_CX = 20;
    public static final Integer PAY_ON_LINE_WX_PC = 25;
    public static final Integer PAY_ON_LINE_AL = 30;
    public static final Integer PAY_ON_LINE_YL = 40;


    private Long id;


    private String refundOrdersNumber;


    private Long oid;

    private Long uid;


    private String associatedOrderNumber;


    private BigDecimal rentFee;


    private BigDecimal securityFee;


    private BigDecimal keepFee;


    private BigDecimal totalFee;


    private Integer payMethod;


    private String payAccount;


    private String paymentNumber;

    private Integer ordersStatus;

    private Integer refundOrdersType;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "refund_orders_number")
    public String getRefundOrdersNumber() {
        return refundOrdersNumber;
    }


    public void setRefundOrdersNumber(String refundOrdersNumber) {
        this.refundOrdersNumber = refundOrdersNumber;
    }

    @Column(name = "oid")
    public Long getOid() {
        return oid;
    }


    public void setOid(Long oid) {
        this.oid = oid;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }


    @Column(name = "associated_order_number")
    public String getAssociatedOrderNumber() {
        return associatedOrderNumber;
    }


    public void setAssociatedOrderNumber(String associatedOrderNumber) {
        this.associatedOrderNumber = associatedOrderNumber;
    }

    @Column(name = "rent_fee")
    public BigDecimal getRentFee() {
        return rentFee;
    }


    public void setRentFee(BigDecimal rentFee) {
        this.rentFee = rentFee;
    }

    @Column(name = "security_fee")
    public BigDecimal getSecurityFee() {
        return securityFee;
    }


    public void setSecurityFee(BigDecimal securityFee) {
        this.securityFee = securityFee;
    }

    @Column(name = "keep_fee")
    public BigDecimal getKeepFee() {
        return keepFee;
    }


    public void setKeepFee(BigDecimal keepFee) {
        this.keepFee = keepFee;
    }

    @Column(name = "total_fee")
    public BigDecimal getTotalFee() {
        return totalFee;
    }


    public void setTotalFee(BigDecimal totalFee) {
        this.totalFee = totalFee;
    }

    @Column(name = "pay_method")
    public Integer getPayMethod() {
        return payMethod;
    }


    public void setPayMethod(Integer payMethod) {
        this.payMethod = payMethod;
    }

    @Column(name = "pay_account")
    public String getPayAccount() {
        return payAccount;
    }


    public void setPayAccount(String payAccount) {
        this.payAccount = payAccount;
    }

    @Column(name = "payment_number")
    public String getPaymentNumber() {
        return paymentNumber;
    }


    public void setPaymentNumber(String paymentNumber) {
        this.paymentNumber = paymentNumber;
    }

    @Column(name = "orders_status")
    public Integer getOrdersStatus() {
        return ordersStatus;
    }


    public void setOrdersStatus(Integer ordersStatus) {
        this.ordersStatus = ordersStatus;
    }

    @Column(name = "refund_orders_type")
    public Integer getRefundOrdersType() {
        return refundOrdersType;
    }

    public void setRefundOrdersType(Integer refundOrdersType) {
        this.refundOrdersType = refundOrdersType;
    }


    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

