package com.ptteng.xqlease.common.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;


@Entity
@Table(name = "goods_sku_rent_fee_period")
public class GoodsSkuRentFeePeriod implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5849403266426859520L;

    /** 租期   1-1天 5-5天 10-10天 20-20天  30-1个月 100-12个月 110-24个月 120-36个月   */

    public  static  final  int ONE_DAY=1;
    public  static  final  int FIVE_DAY=5;
    public  static  final  int TEN_DAY=10;
    public  static  final  int TWENTY_DAY=20;
    public  static  final  int ONE_MONTH=30;
    public  static  final  int ONE_YEAR=100;
    public  static  final  int TWO_YEAR=110;
    public  static  final  int THREE_YEAR=120;



    private Long id;


    private Long skuId;


    private Integer rentPeriod;


    private String rentFee;


    private List<BigDecimal> rentFeeList;

    private String skuIdPeriod;

    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "sku_id")
    public Long getSkuId() {
        return skuId;
    }


    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    @Column(name = "rent_period")
    public Integer getRentPeriod() {
        return rentPeriod;
    }


    public void setRentPeriod(Integer rentPeriod) {
        this.rentPeriod = rentPeriod;
    }

    @Column(name = "rent_fee")
    public String getRentFee() {
        return rentFee;
    }


    public void setRentFee(String rentFee) {
        this.rentFee = rentFee;

        Gson gson = new GsonBuilder().create();
        rentFeeList = gson.fromJson(this.rentFee, new TypeToken<List<BigDecimal>>() {
        }.getType());
    }

    @Transient
    public List<BigDecimal> getRentFeeList() {
        if (StringUtils.isBlank(this.rentFee)) {
            return new ArrayList<>();
        } else {
            if (this.rentFeeList == null) {
                Gson gson = new GsonBuilder().create();
                rentFeeList = gson.fromJson(this.rentFee, new TypeToken<List<BigDecimal>>() {
                }.getType());
            }
        }
        return rentFeeList;
    }

    public void setRentFeeList(List<BigDecimal> rentFeeList) {
        this.rentFeeList = rentFeeList;
        Gson gson = new GsonBuilder().create();
        this.rentFee = gson.toJson(rentFeeList);
    }

    @Column(name = "sku_id_period")
    public String getSkuIdPeriod() {
        return skuIdPeriod;
    }

    public void setSkuIdPeriod(String skuIdPeriod) {
        this.skuIdPeriod = skuIdPeriod;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

