package com.ptteng.xqlease.common.debang.util;


import com.ptteng.xqlease.common.debang.domain.result.ResultDO;
import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * HttpUtils
 * @author lesia
 * @date 2013
 */
public class HttpUtils {

	public static final ResultDO<String> sendRequest(String url,
                                                     List<Header> headerList, RequestEntity requestEntry,
                                                     String encoding, int timeout) {

		if (StringUtils.isEmpty(url)) {
			return new ResultDO<String>()
					.setException(new NullPointerException("url empty"));
		}
		if (null == requestEntry) {
			return new ResultDO<String>()
					.setException(new NullPointerException("requestEntry empty"));
		}

		// 设置PostMethod
		PostMethod postMethod = new PostMethod(url);
		postMethod.getParams().setContentCharset(encoding);
		postMethod.getParams().setHttpElementCharset(encoding);

		// 设置header
		if (headerList != null) {
			for (Header header : headerList) {
				postMethod.addRequestHeader(header);
			}
		}

		// 设置body
		postMethod.setRequestEntity(requestEntry);

		// http client 参数设置 连接超时 读取数据超时
		HttpClient httpClient = new HttpClient();
		httpClient.getHttpConnectionManager().getParams()
				.setConnectionTimeout(timeout);
		httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);

		try {
			httpClient.executeMethod(postMethod);
			if (postMethod.getStatusCode() == HttpStatus.SC_OK) {
				return new ResultDO<String>().setModel(postMethod
						.getResponseBodyAsString());
			}
			return new ResultDO<String>().setException(
					new IllegalStateException("sendRequest remote error"))
					.setModel(postMethod.getResponseBodyAsString());
		} catch (Exception e) {
			return new ResultDO<String>().setException(e);
		} finally {
			postMethod.releaseConnection();
		}
	}

	/**
	 * HTTP的RequestBody方式请求
	 * @author 269870
	 * @date 2016-3-8 下午5:23:05
	 * @param url
	 * @param paramsList
	 * @param encoding
	 * @param timeout
	 * @return
	 * @see
	 */
	public static final ResultDO<String> sendRequest(String url,
                                                     NameValuePair[] paramsList, String encoding, int timeout) {
		
		String tmpencoding = encoding; 
		int tmptimeout = timeout;

		if (StringUtils.isEmpty(url)) {
			return new ResultDO<String>()
					.setException(new NullPointerException("url empty"));
		}
		if (null == paramsList) {
			return new ResultDO<String>()
					.setException(new NullPointerException("paramsList empty"));
		}
		if (StringUtils.isBlank(encoding)) {
			tmpencoding = "UTF-8";
		}
		if (timeout <= 0) {
			tmptimeout = NumberConstants.DECIMAL_5000;
		}

		// 设置PostMethod
		PostMethod postMethod = new PostMethod(url);
		postMethod.getParams().setContentCharset(tmpencoding);
		postMethod.getParams().setHttpElementCharset(tmpencoding);

		// 设置body
		postMethod.setRequestBody(paramsList);

		// http client 参数设置 连接超时 读取数据超时
		HttpClient httpClient = new HttpClient();
		httpClient.getHttpConnectionManager().getParams()
				.setConnectionTimeout(tmptimeout);
		httpClient.getHttpConnectionManager().getParams().setSoTimeout(tmptimeout);

		try {
			httpClient.executeMethod(postMethod);
			if (postMethod.getStatusCode() == HttpStatus.SC_OK) {
				return new ResultDO<String>().setModel(postMethod
						.getResponseBodyAsString());
			}
			return new ResultDO<String>().setException(
					new IllegalStateException("sendRequest remote error"))
					.setModel(postMethod.getResponseBodyAsString());
		} catch (Exception e) {
			return new ResultDO<String>().setException(e);
		} finally {
			postMethod.releaseConnection();
		}
	}

	/**
	 * @author 李鹏飞
	 * @Description 发送http请求
	 * @Time 2013-12-4
	 * @param url
	 * @param params
	 * @param encoding
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	public static final String postHttp(String url, String params,
			String encoding) throws UnsupportedEncodingException {
		String responseMsg = "";
		// 构造HttpClient的实例
		HttpClient httpClient = new HttpClient();
		// 设置编码格式
		httpClient.getParams().setContentCharset(encoding);
		// 构造PostMethod的实例
		PostMethod postMethod = new PostMethod(url);
		InputStream requestIO = new ByteArrayInputStream(
				params.getBytes("UTF-8"));
		InputStreamRequestEntity entity = new InputStreamRequestEntity(
				requestIO);
		postMethod.setRequestEntity(entity);
		try {
			// 执行postMethod,调用http接口
			httpClient.executeMethod(postMethod);
			// 读取内容
			responseMsg = postMethod.getResponseBodyAsString();
		} catch (HttpException e) {
			e.printStackTrace();
			throw new UnsupportedEncodingException(e.getClass().getName());
		} catch (IOException e) {
			e.printStackTrace();
			throw new UnsupportedEncodingException(e.getClass().getName());
		} finally {
			// 释放连接
			postMethod.releaseConnection();
		}
		return responseMsg;

	}

	/**
	 * 酒仙网post -zjy
	 * 
	 * @param url
	 * @param params
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	@SuppressWarnings("deprecation")
	public static final String postHttp(String url, String params)
			throws UnsupportedEncodingException {
		String responseMsg = "";
		// 构造HttpClient的实例
		HttpClient httpClient = new HttpClient(new HttpClientParams(),new SimpleHttpConnectionManager(true));
		httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(NumberConstants.DECIMAL_10000);
		httpClient.getHttpConnectionManager().getParams().setSoTimeout(NumberConstants.DECIMAL_10000);
		// 设置编码格式
		httpClient.getParams().setContentCharset("UTF-8");
		// 构造PostMethod的实例
		PostMethod postMethod = new PostMethod(url);
		// postMethod.set
		postMethod.setRequestHeader("Content-Type",
				"application/x-www-form-urlencoded;charset=utf-8");

		postMethod.setRequestBody(params);
		postMethod.setRequestHeader("Connection", "close");
		try {
			// 执行postMethod,调用http接口
			httpClient.executeMethod(postMethod);
			// 读取内容
			responseMsg = postMethod.getResponseBodyAsString();
		} catch (HttpException e) {
			e.printStackTrace();
			throw new UnsupportedEncodingException(e.getClass().getName());
		} catch (IOException e) {
			e.printStackTrace();
			throw new UnsupportedEncodingException(e.getClass().getName());
		} finally {
			// 释放连接
			postMethod.releaseConnection();
			httpClient.getHttpConnectionManager().closeIdleConnections(0);
		}
		return responseMsg;

	}
	
	/**
	 * zhanglong 
	 * 
	 *  tp foss   set timeout  
	 * 
	 * @param url
	 * @param params
	 * @return
	 * @throws IOException 
	 */
	public static final String post(String url, String params,int timeout)
			throws IOException {
		String responseMsg = "";
		// 构造HttpClient的实例
		HttpClient httpClient = new HttpClient();
		// 设置编码格式
		httpClient.getParams().setContentCharset("UTF-8");
		// 构造PostMethod的实例
		PostMethod postMethod = new PostMethod(url);
		// postMethod.set
		postMethod.setRequestHeader("Content-Type",
				"application/json");
		if (timeout <= 0) {
			timeout = NumberConstants.DECIMAL_5000;
		}

		//postMethod.setRequestBody(params);
		postMethod.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "UTF-8");
		RequestEntity requestEntity = new StringRequestEntity(params,"application/json","UTF-8");
	     postMethod.setRequestEntity(requestEntity);
		// http client 参数设置 连接超时 读取数据超时
		httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
		httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);

		try {
			// 执行postMethod,调用http接口
			httpClient.executeMethod(postMethod);
			// 读取内容
			responseMsg = postMethod.getResponseBodyAsString();
		} catch (HttpException e) {
			e.printStackTrace();
			throw new HttpException(e.getClass().getName());
		} catch (IOException e) {
			e.printStackTrace();
			throw new IOException(e.getClass().getName());
		} finally {
			// 释放连接
			postMethod.releaseConnection();
		}
		return responseMsg;

	}

	/**
	 * 快递100代理运单互推功能HTTP请求封装方法
	 * 
	 * @author jiangwenqi
	 * @date 2015-2-9
	 * @param url
	 * @param params
	 * @param codePage
	 * @return
	 * @throws Exception
	 */
	public synchronized static String postData(String url,
			Map<String, String> params, String codePage) throws IOException {

		final HttpClient httpClient = new HttpClient();
		httpClient.getHttpConnectionManager().getParams()
				.setConnectionTimeout(
						NumberConstants.DECIMAL_60 * NumberConstants.DECIMAL_1000);
		httpClient.getHttpConnectionManager().getParams()
				.setSoTimeout(
						NumberConstants.DECIMAL_60 * NumberConstants.DECIMAL_1000);

		final PostMethod method = new PostMethod(url);
		if (params != null) {
			method.getParams().setParameter(
					HttpMethodParams.HTTP_CONTENT_CHARSET, codePage);
			method.setRequestBody(assembleRequestParams(params));
		}
		String result = "";
		try {
			httpClient.executeMethod(method);
			result = new String(method.getResponseBody(), codePage);
		} catch (final IOException  e) {
			throw e;
		} finally {
			method.releaseConnection();
		}
		return result;
	}

	@SuppressWarnings("deprecation")
	public synchronized static String postDataRequestBody(String url,
			String params, String codePage) throws IOException {

		final HttpClient httpClient = new HttpClient();
		httpClient.getHttpConnectionManager().getParams()
				.setConnectionTimeout(
						NumberConstants.DECIMAL_5 * NumberConstants.DECIMAL_1000);
		httpClient.getHttpConnectionManager().getParams()
				.setSoTimeout(
						NumberConstants.DECIMAL_5 * NumberConstants.DECIMAL_1000);

		final PostMethod method = new PostMethod(url);
		if (params != null) {
			method.getParams().setParameter(
					HttpMethodParams.HTTP_CONTENT_CHARSET, codePage);
			method.setRequestBody(params);
		}
		String result = "";
		try {
			httpClient.executeMethod(method);
			result = new String(method.getResponseBody(), codePage);
		} catch (final IOException e) {
			throw e;
		} finally {
			method.releaseConnection();
		}
		return result;
	}
	
	
	/**
	 * 菜鸟异常单查询接口
	 * @author ZHOUXI
	 * @date 2015-9-18
	 */
	public static String postHttp(String url,NameValuePair[] data) {
		
		HttpClient httpClient = new HttpClient();
	
		httpClient.getParams().setContentCharset("utf-8");
	
		PostMethod postMethod = new PostMethod(url);
		
		// postMethod.set
		postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
		
		postMethod.setRequestBody(data);
	
		StringBuffer stringBuffer = new StringBuffer();  
		try {
			httpClient.executeMethod(postMethod);
		    InputStream inputStream = postMethod.getResponseBodyAsStream();  
		    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream,"utf-8"));  
		    String str= "";  
		    while((str = br.readLine()) != null){  
		    	stringBuffer .append(str );  
		    }  
		} catch (HttpException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			postMethod.releaseConnection();
		}
		return stringBuffer.toString();
	}
	
	
	/**
	 * 聚石塔API请求方法 （一）
	 * @version V1.0
	 * @description HttpClient封装的请求方法
	 * @author ZHOUXI
	 * @date 2015-09-07
	 */
	public static String httpClient(String url, String params, String chartSet) {
		
		String jsonResponse = "";
		
		HttpClient client = new HttpClient();
		PostMethod method = new PostMethod(url);
//		method.getParams().setParameter(HttpMethodParams.SO_TIMEOUT, 15000);
		client.getHttpConnectionManager().getParams().setConnectionTimeout(NumberConstants.NUMBER_5000);
		method.getParams().setContentCharset(chartSet);
		method.getParams().setHttpElementCharset(chartSet);
		
		try {
			
			System.out.println("请求发出前消息：" + params);
			
			RequestEntity entity = null;
			entity = new StringRequestEntity(params, "application/json", "UTF-8");
			
			method.setRequestEntity(entity);
			method.addRequestHeader("Content-Type", "application/json;charset=UTF-8");
			int statuCode = client.executeMethod(method);
			jsonResponse = method.getResponseBodyAsString();
			System.out.println("响应消息：" + jsonResponse);
			if (statuCode == HttpStatus.SC_OK) {
				System.out.println("response is ok!");
			}
		} catch (HttpException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return jsonResponse;
	}
	
	
	/**
	 * 聚石塔API请求方法 （二）
	 * @version V1.0
	 * @description sendPostRequest get形式的参数post方式的请求
	 * @author ZHOUXI
	 * @date 2015-09-07
	 */
	public static String sendPostRequest(String urlStr, String params) {
        
        //Build parameter string
        String data = params;
        String response = "";
        try {
            
            // Send the request
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            
            //write parameters
            writer.write(data);
            writer.flush();
            
            // Get the response
            StringBuffer answer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line;
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            writer.close();
            reader.close();
            
            //Output the response
            response = answer.toString();
            System.out.println("菜鸟异常响应：" + response);
            
        } catch (MalformedURLException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        
        return response;
	}
	
	
	/**
	 * 聚石塔API请求方法 （三）
	 * @version V1.0
	 * @description HttpURLConnection流请求
	 * @author ZHOUXI
	 * @date 2015-09-07
	 */
	public static String getJstHttpResult(String urlStr, String content) {
		URL url = null;
		HttpURLConnection connection = null;

		try {
			url = new URL(urlStr);
			connection = (HttpURLConnection) url.openConnection();
			connection.setDoOutput(true);
			connection.setDoInput(true);
			connection.setRequestMethod("POST");
			connection.setUseCaches(false);
			connection.connect();

			DataOutputStream out = new DataOutputStream(
					connection.getOutputStream());
			out.write(content.getBytes("utf-8"));
			out.flush();
			out.close();

			BufferedReader reader =
					new BufferedReader(
							new InputStreamReader(
									connection.getInputStream(), "utf-8"));
			StringBuffer buffer = new StringBuffer();
			String line = "";
			while ((line = reader.readLine()) != null) {
				buffer.append(line);
			}
			reader.close();
			return buffer.toString();
			
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (connection != null) {
				connection.disconnect();
			}
		}
		
		return null;
	}
	
	/**
	* @Title: sendGetRequest 
	* @Description: 无参的get请求
	* @param @param url
	* @param @param charset
	* @param @return
	* @param @throws Exception     
	* @return String    返回类型 
	* @throws 
	* @author： 245167
	* @remark
	* @date 2016-12-19 上午11:40:48 
	* @see
	*/
	public static String sendGetRequest(String url, String charset){
		/* 1 生成 HttpClinet 对象并设置参数 */
		HttpClient httpClient = new HttpClient();
		// 设置 Http 连接超时为5秒
		httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(NumberConstants.NUMBER_5000);
		/* 2 生成 GetMethod 对象并设置参数 */
		GetMethod getMethod = new GetMethod(url);
		// 设置 get 请求超时为 5 秒
		getMethod.getParams().setParameter(HttpMethodParams.SO_TIMEOUT, NumberConstants.NUMBER_5000);
		// 设置请求重试处理，用的是默认的重试处理：请求三次
		getMethod.getParams().setParameter(HttpMethodParams.RETRY_HANDLER,	new DefaultHttpMethodRetryHandler());
		String response = "";
		/* 3 执行 HTTP GET 请求 */
		try {
			int statusCode = httpClient.executeMethod(getMethod);
			/* 4 判断访问的状态码 */
			if (statusCode != HttpStatus.SC_OK) {
				System.out.println("请求出错: "+ getMethod.getStatusLine());
			}
			/* 5 处理 HTTP 响应内容 */
			byte[] responseBody = getMethod.getResponseBody();// 读取为字节数组
			response = new String(responseBody, charset);
			// 读取为 InputStream，在网页内容数据量大时候推荐使用
			// InputStream response = getMethod.getResponseBodyAsStream();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			/* 6 .释放连接 */
			getMethod.releaseConnection();
		}
		return response;
	}
	
	
	

	/**
	 * 组装http请求参数
	 * 
	 * @param data
	 * @return
	 */
	private synchronized static NameValuePair[] assembleRequestParams(
			Map<String, String> data) {
		final List<NameValuePair> nameValueList = new ArrayList<NameValuePair>();

		Iterator<Map.Entry<String, String>> it = data.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry<String, String> entry = (Map.Entry<String, String>) it
					.next();
			nameValueList.add(new NameValuePair((String) entry.getKey(),
					(String) entry.getValue()));
		}

		return nameValueList.toArray(new NameValuePair[nameValueList.size()]);
	}

}
