package com.ptteng.xqlease.common.debang.util;

import java.io.Serializable;
import java.util.Date;

public abstract class BaseEntity implements Serializable, IEntity, Comparable<IEntity> {
    private static final long serialVersionUID = 1372509362360011358L;
    private String id;
    private Date createDate;
    private String createUser;
    private Date modifyDate;
    private String modifyUser;

    public BaseEntity() {
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getModifyUser() {
        return this.modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        } else if (obj == null) {
            return false;
        } else if (this.getClass().getPackage() != obj.getClass().getPackage()) {
            return false;
        } else if (IEntity.class.isAssignableFrom(obj.getClass())) {
            BaseEntity other = (BaseEntity) obj;
            if (this.id == null) {
                if (other.getId() != null) {
                    return false;
                }
            } else if (!this.id.equals(other.getId())) {
                return false;
            }

            return true;
        } else {
            return false;
        }
    }

    public int compareTo(IEntity o) {
        if (null == o) {
            return 0;
        } else {
            return o.equals(this) ? 0 : 1;
        }
    }
}
