package com.ptteng.xqlease.common.debang.domain.result;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 给外部合作伙伴返回的 数据统一用此格式
 * 
 * @author 杨长燕
 * @Time 2013-5-10
 * @version V1.0
 * @Description 返回结果基类
 */
@EqualsAndHashCode
public @Data
final class StandardResultInfo<T> {

	// 返回结果，true false
	private String result;

	// 结果编码
	private String resultCode;

	// 错误原因 9999 系统异常
	private String reason;

	// 返回内容的实体
	private Pair<T> model;

	public StandardResultInfo<T> setResult(String result) {
		this.result = result;
		return this;
	}

	public StandardResultInfo<T> setResultCode(String resultCode) {
		this.resultCode = resultCode;
		return this;
	}

	public StandardResultInfo<T> setReason(String reason) {
		this.reason = reason;
		return this;
	}

	public StandardResultInfo<T> setModel(Pair<T> model) {
		this.model = model;
		return this;
	}
	
}
