package com.ptteng.xqlease.common.debang.domain.result;

import com.ptteng.xqlease.common.debang.domain.errorcode.ErrorCode;
import lombok.Data;

import java.io.Serializable;

/**
 * 操作结果
 * 
 * @author lesia
 * @version V1.0
 * @Time 2013-5-9
 * @Modify remarks:
 */
public @Data
class OperationResult implements Serializable {

	private static final long serialVersionUID = 6788852244451712314L;

	private Object responseParam; // 出参
	private Object resultJson; // 出参RESULT_JSON

	private ErrorCode errorCode;

	private Throwable exception; // 异常类名称(运行时异常没有错误码,jdk自带的CheckedExeption也没有错误码)

	private Long endTime;

	public boolean isSuccess() {
		return null == getErrorCode() && null == getException();
	}
}
