package com.ptteng.xqlease.common.debang.domain.price;

import lombok.Data;

import java.math.BigDecimal;

/**
 * DOP暴露出去的价格时效对象
 */
@Data
public class PriceInfo {
	/**
	 * 产品代码
	 */
	protected String productCode;
	
	/**
	 * 产品名称
	 */
	protected String productName;

	/**
	 * 承诺到达时间
	 */
	protected String promiseArriveTime;

	/**
	 * 重货费率
	 */
	protected BigDecimal heavyRate;

	/**
	 * 轻货费率
	 */
	protected BigDecimal lightRate;

	/**
	 * 最低一票(最低消费)
	 */
	protected BigDecimal lowestPrice;

	/** 快递类数据 */
	//
	protected BigDecimal groundPrice;
	protected BigDecimal lowerGround;
	protected BigDecimal upperGround;
	protected BigDecimal rateOfStage1;
	protected BigDecimal lowerOfStage1;
	protected BigDecimal upperOfStage1;
	protected BigDecimal rateOfStage2;
	protected BigDecimal lowerOfStage2;
	protected BigDecimal upperOfStage2;
}
