package com.ptteng.xqlease.common.debang.domain.order;

import com.alibaba.fastjson.annotation.JSONField;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单状态同步实体
 * @version V1.0
 * @description
 *  order-status-push itf-restful共同使用
 * @author ZHOUXI
 * @date 2016-3-23
 */
public class StatusSyncInfo implements Serializable {

	/**
	 * UID-Serial
	 */
	private static final long serialVersionUID = 2795726227361674276L;
	
	private Long id;

	private String channelOrderNumber;		//渠道单号
	
	private String orderNumber;				//订单号
	
	private String waybillNumber;			//运单号
	
	private String orderSource;				//订单来源   "ALIBABA" "YOUSHANG" "SHANGCHENG" "TAOBAO"
	
	private String orderStatus;				//订单状态   "WAIT_ACCEPT"  "ACCEPT" "WAIT_ALLOT" "CANCEL" "REJECT"  "SIGNSUCCESS" "SIGNFAIL" "FAILGOT"  "GOT"
	
	@JSONField(name="comment")
	private String feedBack;				//订单反馈原因(例如订单取消原因 业务失败)
	
	private SyncCode syncCode = SyncCode.WAIT_SYNC;

	private String syncResult;              //调用淘宝 接口 淘宝 返回失败原因

	private Long repeatTimes = Long.valueOf(0);

	private Date cerateTime;

	private Date nextPushTime;

	private String transportMode;//运输方式

	/**
	 * 服务类型，用于鉴别"裹裹"订单
	 */
	private String serviceType;

	//dop orderInfo
	private transient OrderInfo orderInfo;


	public String getOrderSource(){
		if(StringUtils.isNotBlank(orderSource)){
			return orderSource.toUpperCase();
		}
		return orderSource;
	}

	public String getOrderStatus(){
		if(StringUtils.isNotBlank(orderStatus)){
			return orderStatus.toUpperCase();
		}
		return orderStatus;
	}

	public Long getId(){
		return null != id ? id : System.nanoTime();
	}

	public Date getCreateTime(){
		return null == cerateTime ? new Date() : cerateTime;
	}

	/**
	 * @return  the channelOrderNumber
	 */
	public String getChannelOrderNumber() {
		return channelOrderNumber;
	}

	/**
	 * @param channelOrderNumber the channelOrderNumber to set
	 */
	public void setChannelOrderNumber(String channelOrderNumber) {
		this.channelOrderNumber = channelOrderNumber;
	}

	/**
	 * @return  the orderNumber
	 */
	public String getOrderNumber() {
		return orderNumber;
	}

	/**
	 * @param orderNumber the orderNumber to set
	 */
	public void setOrderNumber(String orderNumber) {
		this.orderNumber = orderNumber;
	}

	/**
	 * @return  the waybillNumber
	 */
	public String getWaybillNumber() {
		return waybillNumber;
	}

	/**
	 * @param waybillNumber the waybillNumber to set
	 */
	public void setWaybillNumber(String waybillNumber) {
		this.waybillNumber = waybillNumber;
	}

	/**
	 * @return  the feedBack
	 */
	public String getFeedBack() {
		return feedBack;
	}

	/**
	 * @param feedBack the feedBack to set
	 */
	public void setFeedBack(String feedBack) {
		this.feedBack = feedBack;
	}

	/**
	 * @return  the syncCode
	 */
	public SyncCode getSyncCode() {
		return syncCode;
	}

	/**
	 * @param syncCode the syncCode to set
	 */
	public void setSyncCode(SyncCode syncCode) {
		this.syncCode = syncCode;
	}

	/**
	 * @return  the syncResult
	 */
	public String getSyncResult() {
		return syncResult;
	}

	/**
	 * @param syncResult the syncResult to set
	 */
	public void setSyncResult(String syncResult) {
		this.syncResult = syncResult;
	}

	/**
	 * @return  the repeatTimes
	 */
	public Long getRepeatTimes() {
		return repeatTimes;
	}

	/**
	 * @param repeatTimes the repeatTimes to set
	 */
	public void setRepeatTimes(Long repeatTimes) {
		this.repeatTimes = repeatTimes;
	}

	/**
	 * @return  the cerateTime
	 */
	public Date getCerateTime() {
		return cerateTime;
	}

	/**
	 * @param cerateTime the cerateTime to set
	 */
	public void setCerateTime(Date cerateTime) {
		this.cerateTime = cerateTime;
	}

	/**
	 * @return  the nextPushTime
	 */
	public Date getNextPushTime() {
		return nextPushTime;
	}

	/**
	 * @param nextPushTime the nextPushTime to set
	 */
	public void setNextPushTime(Date nextPushTime) {
		this.nextPushTime = nextPushTime;
	}

	/**
	 * @return  the transportMode
	 */
	public String getTransportMode() {
		return transportMode;
	}

	/**
	 * @param transportMode the transportMode to set
	 */
	public void setTransportMode(String transportMode) {
		this.transportMode = transportMode;
	}

	/**
	 * @return  the serviceType
	 */
	public String getServiceType() {
		return serviceType;
	}

	/**
	 * @param serviceType the serviceType to set
	 */
	public void setServiceType(String serviceType) {
		this.serviceType = serviceType;
	}

	/**
	 * @return  the orderInfo
	 */
	public OrderInfo getOrderInfo() {
		return orderInfo;
	}

	/**
	 * @param orderInfo the orderInfo to set
	 */
	public void setOrderInfo(OrderInfo orderInfo) {
		this.orderInfo = orderInfo;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @param orderSource the orderSource to set
	 */
	public void setOrderSource(String orderSource) {
		this.orderSource = orderSource;
	}

	/**
	 * @param orderStatus the orderStatus to set
	 */
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}

	/**
	 * <p>TODO(方法详细描述说明、方法参数的具体涵义)</p>
	 * @author ZHOUXI
	 * @date 2016-3-23
	 * @return
	 * @see Object#toString()
	 */
	@Override
	public String toString() {
		return "StatusSyncInfo [id=" + id + ", channelOrderNumber="
				+ channelOrderNumber + ", orderNumber=" + orderNumber
				+ ", waybillNumber=" + waybillNumber + ", orderSource="
				+ orderSource + ", orderStatus=" + orderStatus + ", feedBack="
				+ feedBack + ", syncCode=" + syncCode + ", syncResult="
				+ syncResult + ", repeatTimes=" + repeatTimes + ", cerateTime="
				+ cerateTime + ", nextPushTime=" + nextPushTime
				+ ", transportMode=" + transportMode + ", serviceType="
				+ serviceType + ", orderInfo=" + orderInfo + "]";
	}
	
}
