package com.ptteng.xqlease.common.debang.domain.order;

import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 杨长燕
 * @version V1.0
 * @Description 订单实体 菜鸟项目改造修改电子运单字段要求，增加“必接”、“原始地址”等字段
 * @Time 2013-5-10
 * @modify 周玺
 * @date 2015-3-13
 */
@Data
public class OrderInfo {
	// 物流公司ID
	protected String logisticCompanyID;

	// 单号
	protected String logisticID;

	// 客户ID-渠道用户名
	private String customerID;

	// 客户在CRM中的客户编码
	private String customerCode;

	// 始发网点编码
	private String businessNetworkNo;

	// 到达网点编码
	private String toNetworkNo;

	// 发货人信息(内含新增五级地址与原始地址信息)
	private TransPeopleInfo sender;

	// 收货人信息(内含新增五级地址与原始地址信息)
	private TransPeopleInfo receiver;

	// 订单提交时间
	private Date gmtCommit;

	// 货物名称
	private String cargoName;

	// 货物性质，普通[0]、易碎[1]、液态[2]、化学品[3]、白色粉末状[4]、香烟[5]
	private String special;

	// 总件数
	private int totalNumber;

	// 总重量
	private double totalWeight;

	// 总体积
	private double totalVolume;

	// 支付方式
	private String payType;

	// 运输方式
	private String transportType;

	// 保价金额
	private BigDecimal insuranceValue;

	// 代收货款类型
	private String codType;

	// 代收货款
	private BigDecimal codValue;

	// 代收货款客户账号
	private String reciveLoanAccount;

	// 代收货款客户开户名
	private String accountName;

	// 上门接货 是Y 否N
	private String vistReceive;

	// 提货方式
	private String deliveryType;

	// 包装
	private String packageService;

	// 短信通知，Y：需要 N: 不需要
	private String smsNotify;

	// 备注
	private String remark;

	// 上门接货开始时间
	private Date sendStartTime;

	// 上门接货结束时间
	private Date sendEndTime;

	// 返单方式
	private String backSignBill;

	// 订单来源 company-->companyCode 一定
	private String orderSource;

	// 服务类型 线上 线下 0-自己联系 1-在线下单
	private String serviceType = "1";

	// orderInfo 扩展类
	private CRMDealOrderInfo crmDealOrderInfo = new CRMDealOrderInfo();

	// --------------------------------------------------313电子运单新增字段
	// 是否为推荐物流（必接单）
	private String isRecommend;

	// 纯运费（巨商汇20150402新增字段）
	private Double reight;

	// MRO采购单号（阿里采购商城使用20150526新增字段）
	private String subOrderId;
	
	//
	private String serviceJZCode;
	//
	private String serviceJZType;
	
	/**
	 * Add QinYetao 运单号
	 */
	private String mailNo;
	
	/**
	 * 筛单模式 ：SIEVEORDER 仅筛单       SIEVECREATEORDER 筛单下单
	 */
	private String sieveMode;
	
	/**
	 * 是否外发
	 */
	private String isOut;
	 
	/**
	 * 是否字母件的标示
	 */
	private String isPicPackage;
	
	/**
	 * 订单来源 大写
	 * 
	 * @return
	 */
	public String getOrderSource() {
		if (StringUtils.isNotBlank(orderSource)) {
			return orderSource.toUpperCase();
		}
		return orderSource;
	}

	/**
	 * CRM 处理订单结果
	 * 
	 * @author lesia
	 * 
	 */
	@Data
	private class CRMDealOrderInfo {

		// crm 订单号
		private String crmOrderNumber;
		// 运单号
		private String maillNo;
		// 反馈信息
		private String feedBack;
		// 订单状态
		private String statusType;
		// 受理部门 crm acceptDept acceptDeptName
		private String acceptDept;
		// 订单受理时间 (已受理 揽货失败)
		private Date orderAcceptTime;
		// OrderState.REJECT
		private Date modifyDate;
		// 会员类型，目前针对阿里巴巴
		private String memberType;
	}

	public void setCrmOrderNumber(String crmOrderNumber) {
		crmDealOrderInfo.setCrmOrderNumber(crmOrderNumber);
	}

	public String getCrmOrderNumber() {
		return crmDealOrderInfo.getCrmOrderNumber();
	}

	public void setMaillNo(String maillNo) {
		crmDealOrderInfo.setMaillNo(maillNo);
	}

	public String getMaillNo() {
		return crmDealOrderInfo.getMaillNo();
	}

	public void setFeedBack(String feedBack) {
		crmDealOrderInfo.setFeedBack(feedBack);
	}

	public String getFeedBack() {
		return crmDealOrderInfo.getFeedBack();
	}

	public void setStatusType(String statusType) {
		crmDealOrderInfo.setStatusType(statusType);
	}

	public String getStatusType() {
		return crmDealOrderInfo.getStatusType();
	}

	public void setAcceptDept(String acceptDept) {
		crmDealOrderInfo.setAcceptDept(acceptDept);
	}

	public String getAcceptDept() {
		return crmDealOrderInfo.getAcceptDept();
	}

	public void setOrderAcceptTime(Date orderAcceptTime) {
		crmDealOrderInfo.setOrderAcceptTime(orderAcceptTime);
	}

	public Date getOrderAcceptTime() {
		return crmDealOrderInfo.getOrderAcceptTime();
	}

	public void setModifyDate(Date modifyDate) {
		crmDealOrderInfo.setModifyDate(modifyDate);
	}

	public Date getModifyDate() {
		return crmDealOrderInfo.getModifyDate();
	}

	// 设置会员类型，
	public void setMemberType(String memberType) {
		crmDealOrderInfo.setMemberType(memberType);
	}

	// 获取会员类型
	public String getMemberType() {
		return crmDealOrderInfo.getMemberType();
	}

}
