package com.ptteng.xqlease.common.debang.domain.order;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

public class ExpOrderUtil {

	/**
	 * 
	 * <p>
	 * 筛单实体转换成快递订单实体
	 * </p>
	 * 
	 * @author 311290
	 * @date 2016-5-3 下午5:18:50
	 * @param dto
	 * @return
	 */
	public static ExpOrderDTO expSieveDto2expOrder(ExpSieveOrderDTO dto) {
		ExpOrderDTO entity = new ExpOrderDTO();
		// 是否筛单
		entity.setIfSieveOrder(true);
		// 渠道单号
		entity.setChannelNumber(dto.getLogisticID());
		// 订单号
		entity.setOrderNumber(dto.getLogisticID());
		// 下单时间
		entity.setOrderTime(dto.getGmtCommit());
		// 渠道客户id
		entity.setChannelCustId(dto.getChannelCustId());
		// 联系人id
		entity.setContactManId(dto.getCustomerID());

		// 客户在CRM中的客户编码
		entity.setShipperNumber(dto.getCustomerCode());

		// 始发网点编码
		entity.setStartStation(dto.getBusinessNetworkNo());

		// 到达网点编码
		entity.setReceivingToPoint(dto.getToNetworkNo());

		// 客户订单号--海淘用
		entity.setCustOrderLine(dto.getCustOrderLine());
		// 其他费用
		if (dto.getOtherFee() != null) {
			entity.setOtherFee(dto.getOtherFee());
		} else {
			entity.setOtherFee(new BigDecimal(0));
		}

		// 发货人信息(内含新增五级地址与原始地址信息)
		if (dto.getSender() != null) {

			// 名称
			entity.setContactName(dto.getSender().getName());

			// 电话
			entity.setContactPhone(dto.getSender().getPhone());
			// 手机
			entity.setContactMobile(dto.getSender().getMobile());
			// 省份
			entity.setContactProvince(dto.getSender().getProvince());
			entity.setContactProvinceCode(dto.getSender().getProvinceCode());
			// 城市
			entity.setContactCity(dto.getSender().getCity());
			entity.setContactCityCode(dto.getSender().getCityCode());
			// 县/区
			entity.setContactArea(dto.getSender().getCounty());
			entity.setContactAreaCode(dto.getSender().getCountyCode());
			// 街道镇（五级地址菜鸟项目使用）
			entity.setContactTown(dto.getSender().getTown());
			entity.setContactTownCode(dto.getSender().getTownCode());
			// 详细地址（详细地址不做校验，因为不是所有的渠道都有详细地址）
			entity.setContactAddress(dto.getSender().getAddress());
			// 渠道：VAS 官网 设置原始人发货地址
			entity.setOriginalsaddress(dto.getOriginalAddress());

			// 收货人信息(内含新增五级地址与原始地址信息)
			if (dto.getReceiver() != null) {

				// 名称
				entity.setReceiverCustName(dto.getReceiver().getName());

				// 电话
				entity.setReceivePhone(dto.getReceiver().getPhone());
				// 手机
				entity.setReceiveMobile(dto.getReceiver().getMobile());
				// 省份
				entity.setReceiveProvince(dto.getReceiver().getProvince());
				entity.setReceiveProvinceCode(dto.getReceiver()
						.getProvinceCode());
				// 城市
				entity.setReceiveCity(dto.getReceiver().getCity());
				entity.setReceiveCityCode(dto.getReceiver().getCityCode());
				// 县/区
				entity.setReceiveArea(dto.getReceiver().getCounty());
				entity.setReceiveAreaCode(dto.getReceiver().getCountyCode());
				// 街道镇（五级地址菜鸟项目使用）
				entity.setReceiveTown(dto.getReceiver().getTown());
				entity.setReceiveTownCode(dto.getReceiver().getTownCode());
				// 详细地址（详细地址不做校验，因为不是所有的渠道都有详细地址）
				entity.setReceiveAddress(dto.getReceiver().getAddress());
				entity.setOriginalraddress(dto.getReceiver()
						.getOriginalAddress());
				entity.setOriginalrStreet(dto.getReceiver()
						.getOriginalsStreet());
			}

			// 货物名称
			entity.setGoodsName(dto.getCargoName());

			// 货物性质，普通[0]、易碎[1]、液态[2]、化学品[3]、白色粉末状[4]、香烟[5]
			// entity.setGoodsType(dto.getSpecial());

			// 总件数
			entity.setGoodsNumber(dto.getTotalNumber());

			// 总重量
			if (dto.getTotalWeight() != null) {
				entity.setTotalWeight(dto.getTotalWeight().doubleValue());
			}

			// 总体积
			if (dto.getTotalVolume() != null) {
				entity.setTotalVolume(dto.getTotalVolume().doubleValue());
			}
			// 支付方式
			// if (StringUtil.isNotBlank(dto.getPayType())) {
			// entity.setPaymentType(DOPTypeConvert.dop2crmPayType(dto.getPayType()));
			// }
			entity.setPaymentType(dto.getPayType());

			// 运输方式
			entity.setTransportMode(dto.getTransportType());

			// 保价金额
			if (dto.getInsuranceValue() != null) {
				entity.setInsuredAmount(dto.getInsuranceValue().doubleValue());
			} else {
				entity.setInsuredAmount(new Double(0));
			}

			// 代收货款类型
			entity.setReciveLoanType(dto.getCodType());
			// if (StringUtil.isNotBlank(dto.getCodType())) {
			// entity.setReciveLoanType(DOPTypeConvert.dop2crmCodeType(dto.getCodType()));
			// }
			// 代收货款客户账号
			entity.setReciveLoanAccount(dto.getReciveLoanAccount());

			// 代收货款客户开户名
			entity.setAccountName(dto.getAccountName());

			// 代收货款
			if (dto.getCodValue() != null) {
				entity.setReviceMoneyAmount(dto.getCodValue().doubleValue());
			} else {
				entity.setReviceMoneyAmount(new Double(0));
				entity.setReciveLoanType(null);
				entity.setReciveLoanAccount(null);
				entity.setAccountName(null);
			}

			// 上门接货 是1 否0
			entity.setIsReceiveGoods(dto.getVistReceive());
			// if(CommonConst.BOOLEAN_Y.equalsIgnoreCase(dto.getVistReceive())){
			// entity.setIsReceiveGoods(CommonConst.NUMBER1);
			// }else{
			// entity.setIsReceiveGoods(CommonConst.NUMBER0);
			// }

			// 提货方式
			entity.setDeliveryMode(dto.getDeliveryType());
			// if (StringUtil.isNotBlank(dto.getDeliveryType())) {
			// entity.setDeliveryMode(DOPTypeConvert.dop2crmPickGoodsType(dto.getDeliveryType()));
			// }

			// 包装
			entity.setPacking(dto.getPackageService());

			// 短信通知，1：需要 0: 不需要
			if (StringUtils.isNotBlank(dto.getSmsNotify())) {
				// entity.setIsSendmessage(dto.getSmsNotify());
				if (StringUtils.equals(dto.getSmsNotify(), "true")
						|| StringUtils.equals(dto.getSmsNotify(), "1")
						|| StringUtils.equals(dto.getSmsNotify(), "Y")) {
					entity.setIsSendmessage("1");
				} else {
					entity.setIsSendmessage("0");
				}

			} else {
				entity.setIsSendmessage("0");
			}
			// if(CommonConst.BOOLEAN_Y.equalsIgnoreCase(dto.getSmsNotify())){
			// entity.setIsSendmessage(CommonConst.NUMBER1);
			// }else{
			// entity.setIsSendmessage(CommonConst.NUMBER0);
			// }

			// 备注
			entity.setRemark(dto.getRemark());
			// 储运事项
			entity.setTransNote(dto.getTransNote());

			// 上门接货开始时间
			entity.setBeginAcceptTime(dto.getSendStartTime());

			// 上门接货结束时间
			entity.setEndAcceptTime(dto.getSendEndTime());

			// 签收单返回方式
			entity.setReturnBillType(dto.getBackSignBill());
			// if (StringUtil.isNotBlank(dto.getBackSignBill())) {
			// entity.setReturnBillType(DOPTypeConvert.dop2crmSignBillType(dto.getBackSignBill()));
			// }

			// 订单来源 company-->companyCode 一定
			entity.setResource(dto.getOrderSource());

			// 服务类型 2:快递线上订单 3:快递线下订单
			entity.setServiceType(dto.getServiceType());

			// --------------------------------------------------313电子运单新增字段
			// 是否为推荐物流（必接单）
			// entity.setRecommend(dto.getIsRecommend());

			// MRO采购单号（阿里采购商城使用20150526新增字段）
			// entity.setProcurementNumber(dto.getSubOrderId());

			// 运单号
			entity.setWaybillNumber(dto.getMailNo());
			// 是否子母件
			entity.setIsPicPackage(dto.getIsPicPackage());
			entity.setConsignorComments(dto.getAddressComments());
			entity.setReceivingComments(dto.getArriveAddressComments());
			entity.setSenderCode(dto.getSenderCode());
			entity.setPaymentOrgCode(dto.getPaymentOrgcode());
			// 门店编号
			entity.setStoreCode(dto.getStoreCode());
			// 子母件类型
			entity.setPicPackageType(dto.getPicPackageType());
			return entity;
		}
		return entity;
	}
	/**
	 * 
	 * <p>
	 * 标准订单实体转换成快递订单实体
	 * </p>
	 * 
	 * @author 311290
	 * @date 2016-5-3 下午5:18:50
	 * @param dto
	 * @return
	 */
	public static ExpressOrderEntity expSieveDtoToExpressOrderEntity(ExpSieveOrderDTO dto) {
		ExpressOrderEntity entity = new ExpressOrderEntity();
		// 渠道单号
		entity.setChannelNumber(dto.getLogisticID());
		// 订单号
		entity.setOrderNumber(dto.getLogisticID());
		// 下单时间
		entity.setOrderTime(dto.getGmtCommit());
		// 渠道客户id
		entity.setChannelCustId(dto.getChannelCustId());
		// 联系人id
		entity.setChannelCustId(dto.getCustomerID());
		
		// 客户在CRM中的客户编码
		entity.setShipperNumber(dto.getCustomerCode());
		
		// 始发网点编码
		entity.setDepartureId(dto.getBusinessNetworkNo());
		
		// 到达网点编码
		entity.setReceivingtoPointid(dto.getToNetworkNo());
		
		// 客户订单号--海淘用
//		entity.setCustOrderLine(dto.getCustOrderLine());
		// 其他费用
		if (dto.getOtherFee() != null) {
			entity.setOtherFee(dto.getOtherFee());
		} else {
			entity.setOtherFee(new BigDecimal(0));
		}
		
		// 发货人信息(内含新增五级地址与原始地址信息)
		if (dto.getSender() != null) {
			
			// 名称
			entity.setContactName(dto.getSender().getName());
			
			// 电话
			entity.setContactPhone(dto.getSender().getPhone());
			// 手机
			entity.setContactMobile(dto.getSender().getMobile());
			// 省份
			entity.setContactProvince(dto.getSender().getProvince());
			entity.setContactProvinceCode(dto.getSender().getProvinceCode());
			// 城市
			entity.setContactCity(dto.getSender().getCity());
			entity.setContactCityCode(dto.getSender().getCityCode());
			// 县/区
			entity.setContactArea(dto.getSender().getCounty());
			entity.setContactAreaCode(dto.getSender().getCountyCode());
			// 街道镇（五级地址菜鸟项目使用）
			entity.setContactTown(dto.getSender().getTown());
			entity.setContactTownCode(dto.getSender().getTownCode());
			// 详细地址（详细地址不做校验，因为不是所有的渠道都有详细地址）
			entity.setContactAddress(dto.getSender().getAddress());
			// 渠道：VAS 官网 设置原始人发货地址
			entity.setOriginalSaddress(dto.getOriginalAddress());
			
			// 收货人信息(内含新增五级地址与原始地址信息)
			if (dto.getReceiver() != null) {
				
				// 名称
				entity.setReceiveCustname(dto.getReceiver().getName());
				
				// 电话
				entity.setReceivePhone(dto.getReceiver().getPhone());
				// 手机
				entity.setReceiveMobile(dto.getReceiver().getMobile());
				// 省份
				entity.setReceiveProvince(dto.getReceiver().getProvince());
				entity.setReceiveProvinceCode(dto.getReceiver()
						.getProvinceCode());
				// 城市
				entity.setReceiveCity(dto.getReceiver().getCity());
				entity.setReceiveCityCode(dto.getReceiver().getCityCode());
				// 县/区
				entity.setReceiveArea(dto.getReceiver().getCounty());
				entity.setReceiveAreaCode(dto.getReceiver().getCountyCode());
				// 街道镇（五级地址菜鸟项目使用）
				entity.setReceiveTown(dto.getReceiver().getTown());
				entity.setReceiveTownCode(dto.getReceiver().getTownCode());
				// 详细地址（详细地址不做校验，因为不是所有的渠道都有详细地址）
				entity.setReceiveAddress(dto.getReceiver().getAddress());
				entity.setOriginalRaddress(dto.getReceiver()
						.getOriginalAddress());
				entity.setOriginalRstreet(dto.getReceiver()
						.getOriginalsStreet());
			}
			
			// 货物名称
			entity.setGoodsName(dto.getCargoName());
			
			// 货物性质，普通[0]、易碎[1]、液态[2]、化学品[3]、白色粉末状[4]、香烟[5]
			// entity.setGoodsType(dto.getSpecial());
			
			// 总件数
			entity.setTotalPiece(dto.getTotalNumber());
			
			// 总重量
			if (dto.getTotalWeight() != null) {
				entity.setTotalWeight(dto.getTotalWeight().doubleValue());
			}
			
			// 总体积
			if (dto.getTotalVolume() != null) {
				entity.setTotalVolume(dto.getTotalVolume().doubleValue());
			}
			// 支付方式
			// if (StringUtil.isNotBlank(dto.getPayType())) {
			// entity.setPaymentType(DOPTypeConvert.dop2crmPayType(dto.getPayType()));
			// }
			entity.setPaymentType(dto.getPayType());
			
			// 运输方式
			entity.setTransportMode(dto.getTransportType());
			
			// 保价金额
			if (dto.getInsuranceValue() != null) {
				entity.setBjsmjz(dto.getInsuranceValue().doubleValue());
			} else {
				entity.setBjsmjz(new Double(0));
			}
			
			// 代收货款类型
			entity.setDshkType(dto.getCodType());
			// if (StringUtil.isNotBlank(dto.getCodType())) {
			// entity.setReciveLoanType(DOPTypeConvert.dop2crmCodeType(dto.getCodType()));
			// }
			// 代收货款客户账号
			entity.setDshkAccount(dto.getReciveLoanAccount());
			
			// 代收货款客户开户名
			entity.setDshkAccountName(dto.getAccountName());
			
			// 代收货款
			if (dto.getCodValue() != null) {
				entity.setDshk(dto.getCodValue().doubleValue());
			} else {
				entity.setDshk(new Double(0));
				entity.setDshkType(null);
				entity.setDshkAccount(null);
				entity.setDshkAccountName(null);
			}
			
			// 上门接货 是1 否0
			entity.setIsreceivegood(dto.getVistReceive());
			// if(CommonConst.BOOLEAN_Y.equalsIgnoreCase(dto.getVistReceive())){
			// entity.setIsReceiveGoods(CommonConst.NUMBER1);
			// }else{
			// entity.setIsReceiveGoods(CommonConst.NUMBER0);
			// }
			
			// 提货方式
			entity.setDeliveryMode(dto.getDeliveryType());
			// if (StringUtil.isNotBlank(dto.getDeliveryType())) {
			// entity.setDeliveryMode(DOPTypeConvert.dop2crmPickGoodsType(dto.getDeliveryType()));
			// }
			
			// 包装
			entity.setPacking(dto.getPackageService());
			
			// 短信通知，1：需要 0: 不需要
			if (StringUtils.isNotBlank(dto.getSmsNotify())) {
				// entity.setIsSendmessage(dto.getSmsNotify());
				if (StringUtils.equals(dto.getSmsNotify(), "true")
						|| StringUtils.equals(dto.getSmsNotify(), "1")
						|| StringUtils.equals(dto.getSmsNotify(), "Y")) {
					entity.setIssendms("1");
				} else {
					entity.setIssendms("0");
				}
				
			} else {
				entity.setIssendms("0");
			}
			// if(CommonConst.BOOLEAN_Y.equalsIgnoreCase(dto.getSmsNotify())){
			// entity.setIsSendmessage(CommonConst.NUMBER1);
			// }else{
			// entity.setIsSendmessage(CommonConst.NUMBER0);
			// }
			
			// 备注
			entity.setRemark(dto.getRemark());
			// 储运事项
			entity.setTransNote(dto.getTransNote());
			
			// 上门接货开始时间
			entity.setBeginaccepTime(dto.getSendStartTime());
			
			// 上门接货结束时间
			entity.setEndaccpTime(dto.getSendEndTime());
			
			// 签收单返回方式
			entity.setReturnbillType(dto.getBackSignBill());
			// if (StringUtil.isNotBlank(dto.getBackSignBill())) {
			// entity.setReturnBillType(DOPTypeConvert.dop2crmSignBillType(dto.getBackSignBill()));
			// }
			
			// 订单来源 company-->companyCode 一定
			entity.setResource(dto.getOrderSource());
			
			// 服务类型 2:快递线上订单 3:快递线下订单
			entity.setServiceType(dto.getServiceType());
			
			// --------------------------------------------------313电子运单新增字段
			// 是否为推荐物流（必接单）
			// entity.setRecommend(dto.getIsRecommend());
			
			// MRO采购单号（阿里采购商城使用20150526新增字段）
			// entity.setProcurementNumber(dto.getSubOrderId());
			
			// 运单号
			entity.setWaybillNumber(dto.getMailNo());
			// 是否子母件
			entity.setIsPicPackage(dto.getIsPicPackage());
//			entity.setConsignorComments(dto.getAddressComments());
//			entity.setReceivingComments(dto.getArriveAddressComments());
			entity.setSenderCode(dto.getSenderCode());
			entity.setPaymentOrgcode(dto.getPaymentOrgcode());
			// 门店编号
			entity.setStoreCode(dto.getStoreCode());
			// 子母件类型
			entity.setPicPackageType(dto.getPicPackageType());
			return entity;
		}
		return entity;
	}

}