package com.ptteng.xqlease.common.debang.domain.order;

import com.ptteng.xqlease.common.debang.domain.result.Pair;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=false)
public class EwbResultInfo<T> {

	private String result; // 返回结果，true false

	private String resultCode; // 结果编码

	private String reason; // 错误原因 9999 系统异常

	private Pair<T> model; // 返回内容的实体

	/**
	 * 增加了运单号 返回给客户！
	 */
	private String mailNo;

	/**
	 * 返回分练参数
	 * add by Qinyetao
	 */
	private EwbSortingParamInfo sortingParam;

	public EwbResultInfo<T> setResult(String result) {
		this.result = result;
		return this;
	}

	public EwbResultInfo<T> setResultCode(String resultCode) {
		this.resultCode = resultCode;
		return this;
	}

	public EwbResultInfo<T> setReason(String reason) {
		this.reason = reason;
		return this;
	}
}
