package com.ptteng.xqlease.common.debang.domain.order;

import com.ptteng.xqlease.common.debang.domain.result.Pair;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
public class EwbNewResultInfo<T> {
    private String result; // 返回结果，true false

    private String resultCode; // 结果编码

    private String reason; // 错误原因 9999 系统异常

    private Pair<T> model; // 返回内容的实体

    /**
     * 增加了运单号 返回给客户！
     */
    private String mailNo;

    private List<String> mailNos;
    /**
     * 返回分练参数
     * add by Qinyetao
     */
    private EwbNewSortingParamInfo sortingParam;


    public EwbNewResultInfo<T> setSortingParams(EwbNewSortingParamInfo ewbSortingParam) {
        this.sortingParam = ewbSortingParam;
        return this;
    }

    public EwbNewResultInfo<T> setMailNo(String mailNo) {
        this.mailNo = mailNo;
        return this;
    }

    public EwbNewResultInfo<T> setMailNos(List<String> mailNos) {
        this.mailNos = mailNos;
        return this;
    }
    public EwbNewResultInfo<T> setResult(String result) {
        this.result = result;
        return this;
    }

    public EwbNewResultInfo<T> setResultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public EwbNewResultInfo<T> setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public EwbNewResultInfo<T> setModel(Pair<T> model) {
        this.model = model;
        return this;
    }

}
