package com.ptteng.xqlease.common.debang;

import com.ptteng.xqlease.common.debang.domain.order.TraceOrder;
import com.ptteng.xqlease.common.debang.domain.order.TraceOrderReqInfo;
import com.ptteng.xqlease.common.debang.util.FastJsonUtil;
import com.ptteng.xqlease.common.debang.util.HttpUtils;
import com.ptteng.xqlease.common.debang.util.SecurityUtil;
import com.ptteng.xqlease.common.model.ResultInfo;
import org.apache.commons.httpclient.NameValuePair;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName ExpressUtil
 * @author: UU
 * @Date: 2018/11/24 20:34
 * @Description: TODO
 * @Version 1.0
 */
public class ExpressUtil {

    /**
     * @author: UU
     * @description:
     * @Date: 17:54 2018/11/8
     * @Param: [common]
     * @Return: com.ptteng.zln.demo.entity.ResultInfo
     **/
    public static ResultInfo queryOrder(TraceOrderReqInfo common) {
        //订单内容 json字符串，SDK提供FastJsonUtil转Json
        String params = FastJsonUtil.toJSONString(common.getOrders().get(0));
        System.out.println(params);
        //companyCode与appkey为双方约定
        //todo 这个是默认的测试账密，需要找甲方要，项目上线还需要与德邦接口联调，申请正式Code和Key
        String companyCode = "EWBBJXQWLKJYXGS";
        String appkey = "821514f6123330fe9c71c85bced3fe01";
        //时间戳 SDK提供SecurityUtil获取时间戳
        String timestamp = String.valueOf(System.currentTimeMillis());
        //摘要 SDK提供SecurityUtil生成摘要
        String digest = SecurityUtil.getStandardDigest(params + appkey + timestamp);
        //post请求参数
        NameValuePair[] data = new NameValuePair[4];
        data[0] = new NameValuePair("companyCode", companyCode);
        data[1] = new NameValuePair("digest", digest);
        data[2] = new NameValuePair("timestamp", timestamp);
        data[3] = new NameValuePair("params", params);
        //请求url
//        String url = "http://dpsanbox.deppon.com/sandbox-web/standard-order/newTraceQuery.action";
        String url = "http://dpapi.deppon.com/dop-interface-sync/standard-query/newTraceQuery.action";
        //返回结果
        String response = HttpUtils.sendRequest(url, data, "UTF-8", 5000).getModel();
        //根据返回结果进行后续操作
        return FastJsonUtil.parseObject(response, ResultInfo.class);
    }

    public static ResultInfo queryOrderByMailNo(String mailNo) {
        //生成单号查询实体类（德邦提供的）
        TraceOrderReqInfo traceOrderReqInfo = new TraceOrderReqInfo();
        //设置参数
        traceOrderReqInfo.setIsNeedGPS("false");
        traceOrderReqInfo.setIsPackaging("true");
        traceOrderReqInfo.setLogisticCompanyID("DEPPON");
        //生成订单实体类（德邦提供的）
        TraceOrder traceOrder = new TraceOrder();
        traceOrder.setMailNo(mailNo);
        List list = new ArrayList<>();
        list.add(traceOrder);
        //单号查询实体设置单号查询这里参数类型是list，所以放入list中
        traceOrderReqInfo.setOrders(list);
        //返回值是json类型，ResultInfo是对应实体类
        return queryOrder(traceOrderReqInfo);
    }


    public static void main(String[] args) {
        ResultInfo resultInfo = queryOrderByMailNo("0670256149");
        System.out.println(resultInfo.getResponseParam());
        System.out.println("+++++++++++++++++++++++++");
        System.out.println(resultInfo);


       String result = FastJsonUtil.toJSONString(resultInfo);
        System.out.println("result=========="+result);
    }

}
