package com.ptteng.xqlease.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.xqlease.common.model.ShoppingCart;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ShoppingCartService extends BaseDaoService {

	



   		   
		
		public Long insert(ShoppingCart shoppingCart)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<ShoppingCart> insertList(List<ShoppingCart> shoppingCartList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(ShoppingCart shoppingCart)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<ShoppingCart> shoppingCartList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public ShoppingCart getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<ShoppingCart> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countShoppingCartIdsByUid(Long uid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getShoppingCartIdsByUid(Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getShoppingCartIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countShoppingCartIds() throws ServiceException, ServiceDaoException;
	

}

