package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "stock")
public class Stock implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2926402183169266688L;

    /**
     * 库存操作类型 10-新增商品/SKU 20-加库存 30-减库存 40-生成订单 45-生成售后订单 50-取消订单 55-订单完成 60-退货 70-换货 80-订单过期
     */
    public static final int SKU_CREATE = 10;
    public static final int STOCK_INCREASE = 20;
    public static final int STOCK_DECREASE = 30;
    public static final int RENT_ORDERS_CREATE = 40;
    public static final int SALES_ORDERS_CREATE = 45;
    public static final int ORDERS_CANCEL = 50;
    public static final int ORDERS_COMPLETE = 55;
    public static final int SKU_BACK = 60;
    public static final int SKU_CHANGE = 70;
    public static final int ORDER_EXPIRED = 80;


    /**
     * stockType：库存类型 1-入库 2-出库
     */
    public static final int STOCK_IN = 1;
    public static final int STOCK_OUT = 2;

    private Long id;


    private String stockNum;


    private String goodsName;


    private String goodsNum;


    private String ordersNum;


    private String brandName;


    private String sku;


    private String operateAccount;


    private Integer operateType;


    private Integer operateAmount;


    private Long operateTime;


    private Integer stockAmount;


    private Integer stockType;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "stock_num")
    public String getStockNum() {
        return stockNum;
    }


    public void setStockNum(String stockNum) {
        this.stockNum = stockNum;
    }

    @Column(name = "goods_name")
    public String getGoodsName() {
        return goodsName;
    }


    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    @Column(name = "goods_num")
    public String getGoodsNum() {
        return goodsNum;
    }


    public void setGoodsNum(String goodsNum) {
        this.goodsNum = goodsNum;
    }

    @Column(name = "orders_num")
    public String getOrdersNum() {
        return ordersNum;
    }


    public void setOrdersNum(String ordersNum) {
        this.ordersNum = ordersNum;
    }

    @Column(name = "brand_name")
    public String getBrandName() {
        return brandName;
    }


    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @Column(name = "sku")
    public String getSku() {
        return sku;
    }


    public void setSku(String sku) {
        this.sku = sku;
    }

    @Column(name = "operate_account")
    public String getOperateAccount() {
        return operateAccount;
    }


    public void setOperateAccount(String operateAccount) {
        this.operateAccount = operateAccount;
    }

    @Column(name = "operate_type")
    public Integer getOperateType() {
        return operateType;
    }


    public void setOperateType(Integer operateType) {
        this.operateType = operateType;
    }

    @Column(name = "operate_amount")
    public Integer getOperateAmount() {
        return operateAmount;
    }


    public void setOperateAmount(Integer operateAmount) {
        this.operateAmount = operateAmount;
    }

    @Column(name = "operate_time")
    public Long getOperateTime() {
        return operateTime;
    }


    public void setOperateTime(Long operateTime) {
        this.operateTime = operateTime;
    }

    @Column(name = "stock_amount")
    public Integer getStockAmount() {
        return stockAmount;
    }

    public void setStockAmount(Integer stockAmount) {
        this.stockAmount = stockAmount;
    }

    @Column(name = "stock_type")
    public Integer getStockType() {
        return stockType;
    }


    public void setStockType(Integer stockType) {
        this.stockType = stockType;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }


    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }


    @Column(name = "update_by")
    public Long getUpdateBy() {
        return createBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }


//根据操作变更库存
    public static Integer countStock(GoodsSku sku, Integer stockAmount, Integer operateType) {
        // 当前库存
        Integer stockNow=sku.getStock();
        switch (operateType){
            //创建sku，库存=新增的库存
            case Stock.SKU_CREATE:
                stockNow=stockAmount;
                break;
            //增加库存
            case Stock.STOCK_INCREASE:
                stockNow=stockNow+stockAmount;
                break;
            //减少库存
            case Stock.STOCK_DECREASE:
                stockNow=stockNow-stockAmount;
                break;
            //生成租赁订单 减少库存
            case Stock.RENT_ORDERS_CREATE:
                stockNow=stockNow-stockAmount;
                break;
            case Stock.SALES_ORDERS_CREATE:
                stockNow=stockNow-stockAmount;
                break;

            case Stock.ORDERS_CANCEL:
                stockNow=stockNow+stockAmount;
                break;
            case Stock.ORDERS_COMPLETE:
                stockNow=stockNow+stockAmount;
                break;
            case Stock.SKU_BACK:
                stockNow=stockNow+stockAmount;
                break;
            case Stock.SKU_CHANGE:
                stockNow=stockNow+stockAmount;
                break;
        }

        return stockNow;
    }
}

