package com.ptteng.xqlease.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "goods_log")
public class GoodsLog implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5368400612485928960L;

    /**
     * 商品日志操作状态  1-创建商品 2-编辑商品 3-上架 4-下架 5-删除（保留，看需求变化）
     */
    public static final Integer CREATE_GOODS = 1;
    public static final Integer UPDATE_GOODS = 2;
    public static final Integer GOODS_ON = 3;
    public static final Integer GOODS_OFF = 4;
    public static final Integer DELETE_GOODS = 5;


    private Long id;


    private Long goodsId;


    private String goodsNumber;


    private String goodsName;


    private String goodsImg;


    private Long brandId;


    private String brandName;


    private Integer operationDescribe;


    private String createrName;


    private Long createAt;


    private Long updateAt;


    private Long createBy;


    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "goods_id")
    public Long getGoodsId() {
        return goodsId;
    }


    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    @Column(name = "goods_number")
    public String getGoodsNumber() {
        return goodsNumber;
    }


    public void setGoodsNumber(String goodsNumber) {
        this.goodsNumber = goodsNumber;
    }

    @Column(name = "goods_name")
    public String getGoodsName() {
        return goodsName;
    }


    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    @Column(name = "goods_img")
    public String getGoodsImg() {
        return goodsImg;
    }


    public void setGoodsImg(String goodsImg) {
        this.goodsImg = goodsImg;
    }

    @Column(name = "brand_id")
    public Long getBrandId() {
        return brandId;
    }


    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    @Column(name = "brand_name")
    public String getBrandName() {
        return brandName;
    }


    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @Column(name = "operation_describe")
    public Integer getOperationDescribe() {
        return operationDescribe;
    }


    public void setOperationDescribe(Integer operationDescribe) {
        this.operationDescribe = operationDescribe;
    }

    @Column(name = "creater_name")
    public String getCreaterName() {
        return createrName;
    }


    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

