package com.ptteng.xqlease.common.debang.domain.result;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 系统内部用
 * 
 * @author lesia
 * @version V1.0
 * @Time 2013-5-9
 * @Modify remarks:
 */
public class ResultDO<T> {
    //封装返回对象的实体
	private @Getter
	T model;

	private Map<String, Object> extra = Maps.newConcurrentMap();

	private List<Exception> exceptionList = Lists.newArrayList(); // 批量处理

	@SuppressWarnings("rawtypes")
	public ResultDO set(String key, Object value) {

		if (StringUtils.isBlank(key) || null == value) {
			throw new IllegalArgumentException("argument is empty");
		}
		extra.put(key, value);
		return this;
	}
    /**
     * 
    * @Title: get 
    * @Description: TODO(这里用一句话描述这个方法的作用) 
    * @param @param key
    * @param @return    设定文件 
    * @return Object    返回类型 
    * @throws 
    * @author zhangjiayi
    * @date 2016-5-3 下午2:12:15
     */
	public Object get(String key) {
		if (StringUtils.isBlank(key)) {
			return null;
		}
		return extra.get(key);
	}
    /**
     * 
    * @Title: setException 
    * @Description: TODO(这里用一句话描述这个方法的作用) 
    * @param @param exception
    * @param @return    设定文件 
    * @return ResultDO<T>    返回类型 
    * @throws 
    * @author zhangjiayi
    * @date 2016-5-3 下午2:12:19
     */
	public ResultDO<T> setException(Exception exception) {
		return addException(exception);
	}
    /**
     * 
    * @Title: setModel 
    * @Description: TODO(这里用一句话描述这个方法的作用) 
    * @param @param model
    * @param @return    设定文件 
    * @return ResultDO<T>    返回类型 
    * @throws 
    * @author zhangjiayi
    * @date 2016-5-3 下午2:12:23
     */
	public ResultDO<T> setModel(T model) {
		this.model = model;
		return this;
	}
    /**
     * 
    * @Title: addException 
    * @Description: TODO(这里用一句话描述这个方法的作用) 
    * @param @param ex
    * @param @return    设定文件 
    * @return ResultDO<T>    返回类型 
    * @throws 
    * @author zhangjiayi
    * @date 2016-5-3 下午2:12:26
     */
	public ResultDO<T> addException(Exception ex) {
		if (null != ex) {
			exceptionList.add(ex);
		}
		return this;
	}
    /**
     * 
    * @Title: addExceptionList 
    * @Description: TODO(这里用一句话描述这个方法的作用) 
    * @param @param exList
    * @param @return    设定文件 
    * @return ResultDO<T>    返回类型 
    * @throws 
    * @author zhangjiayi
    * @date 2016-5-3 下午2:12:30
     */
	public ResultDO<T> addExceptionList(List<Exception> exList) {
		if (CollectionUtils.isNotEmpty(exList)) {
			exceptionList.addAll(exList);
		}
		return this;
	}

	/**
	 * 是否成功
	 * 
	 * @return
	 */
	public boolean isSuccess() {
		return CollectionUtils.isEmpty(exceptionList);
	}

	public Exception getException() {
		return CollectionUtils.isNotEmpty(exceptionList) ? exceptionList.get(0)
				: null;
	}

	public List<Exception> getExceptionList() {
		return Collections.unmodifiableList(exceptionList);
	}
}
