package com.ptteng.xqlease.common.debang.domain.order;


import com.ptteng.xqlease.common.debang.util.BaseEntity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 快递订单对外接口---实体
 * @author 320446 崔永振
 * @date 20160406
 */
public class ExpOrderDTO extends BaseEntity implements Serializable {

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = 5739047730290088306L;
	// 1. 菜鸟和老淘宝区分用 2. 物流商编码
	private String provideId;
	//电子运单状态
	private int CNStatus;
	//电子运单版本号
	private int CNMsgVersion;
	//催单次数	 
	private int hastenCount;
	//最后催单时间	
	private Date lastHastenTime;
	//联系人id	
	private String contactManId;
	//订单号	
	private String orderNumber;
	//渠道单号	
	private String channelNumber;
	//发货客户id	
	private String shipperId;
	//发货客户编号	
	private String shipperNumber;
	//发货客户名称	
	private String shipperName;
	//发货联系人名称	
	private String contactName;
	//联系人手机	
	private String contactMobile;
	//联系人电话	
	private String contactPhone;
	//联系人省份	
	private String contactProvince;
	//联系人城市	
	private String contactCity;
	//联系人区县	
	private String contactArea;
	//联系人乡镇	
	private String contactTown;
	//联系地址	
	private String contactAddress;
	//联系人地址备注（发货方）	
	private String consignorComments;
	//是否接货	
	private String isReceiveGoods;
	//接货起始时间	
	private Date beginAcceptTime;
	//接货结束时间	
	private Date endAcceptTime;
	
	/**CNOP-OMS-GIS查询收派小区ID新增经,纬度匹配逻辑需求
	 * 339815 lijingpeng 2016-08-22 
	 */
	//寄件人地址纬度
	private String senderLatitude;
	//寄件人地址经度
	private String senderLongitude;
	
	//收货客户id	
	private String receiverCustId;
	//收货客户编号	
	private String receiverCustNumber;
	//收货客户所属公司	
	private String receiverCustcompany;
	//收货人联系姓名	
	private String receiverCustName;
	//接货人联系手机	
	private String receiveMobile;
	//接货人联系电话	
	private String receivePhone;
	//接货人省份	
	private String receiveProvince;
	//接货人城市	
	private String receiveCity;
	//接货人区县	
	private String receiveArea;
	//接货人乡镇	
	private String receiveTown;
	//接货人详细地址	
	private String receiveAddress;
	//接货人地址备注	
	private String receivingComments;
	//是否短信通知	
	private String isSendmessage;
	//到达网点	
	private String receivingToPoint;
	//到达网点名称	
	private String receivingToPointName;
	//货物运输方式	
	private String transportMode;
	//货物名称	
	private String goodsName;
	//货物包装类型	
	private String packing;
	//货物类型	
//	private String goodsType;
	//托运货物总件数	
	private Integer goodsNumber;
	//托运货物总重量	
	private Double totalWeight;
	//货物总体积	
	private Double totalVolume;
	//付款方式	
	private String paymentType;
	//渠道类型	
	private String channelType;
	//渠道客户Id	
	private String channelCustId;
	//提货方式	
	private String deliveryMode;
	//代收货款类型	
	private String reciveLoanType;
	//代收货款金额	
	private Double reviceMoneyAmount;
	//报价申明价值	
	private Double insuredAmount;
	//下单时间	
	private Date orderTime;
	//始发网点	
	private String startStation;
	//始发网点名称	
	private String startStationName;
	//受理部门	
	private String acceptDept;
	//受理部门名称	
	private String acceptDeptName;
	//订单状态	
	private String orderStatus;
	//受理人	
	private String dealPerson;
	//订单受理时间	
//	private Date orderAcceptTime;
	//接货员姓名	
//	private String receiver;
	//接货员手机	
//	private String accepterPersonMobile;
	//运单号	
	private String waybillNumber;
	//订单来源	
	private String resource;
	//储运事项	
	private String transNote;
	//签收单	
	private String returnBillType;
	//下单人	
	private String orderPerson;
	//反馈信息	
	private String feedbackInfo;
	//官网收货人德邦用户名	
	private String onlineName;
	//阿里巴巴订单的会员类型	
//	private String memberType;
	//到待受理时间	
//	private Date toWaitAcceptTime;
	//优惠券	
	private String couponNumber;
	//提示的延迟时间	
	private Date delayTime;
	//制单员工号（CC用）	
	private String createUserNum;
	//制单员部门标杆编码	
	private String createUserDeptNum;
	//发货联系人编码	
	private String departLinkManNumber;
	//收货联系人编码	
//	private String arriveLinkManNumber;
	//订单类型	
	private  String orderType;
	//是否电子运单大客户	
	private String ifElecBillBigCust;
	//代收货款帐号	
	private String reciveLoanAccount;
	//开户名	
	private String accountName;
	//线下订单运单号	
	private String offlineWaybillNum;
	//是否电子发票	
	private String ifEInvoice;
	//电子发票手机号	
	private String invoicePhone;
	//电子发票邮箱	
	private String invoiceMail;
	//特安上限	
	private Double teanLimit;
	//订单操作记录	operationLogs;
	//收货省编码	
	private String receiveProvinceCode;
	//收货市编码	
	private String receiveCityCode;
	//收货区编码	
	private String receiveAreaCode;
	//收货乡镇编码	
	private String receiveTownCode;
	//联系人省编码	
	private String contactProvinceCode;
	//联系人市编码	
	private String contactCityCode;
	//发货联系人区编码	
	private String contactAreaCode;
	//发货联系人乡镇编码	
	private String contactTownCode;
	//原始发货地址	
	private String originalsaddress;
	//原始发货地址	
	private String originalsStreet;
	//原始收货地址
	private String originalraddress;
	//原始收货街道镇	
	private String originalrStreet;
	//是否推荐物	
//	private String recommend;
	//纯运费	
	private Double freight;
	//采购单号	
//	private String procurementNumber;
	//是否淘系订单	
	private String ifTaoBao;
	//大头笔	
	private String markerPen;
	//路由信息	
	private String routInfo;
	//版本号	
	private Double versionId;
	//修改类型	
	private String modifyType;
	//发货人工号	
	private String senderCode;
	//费用承担部门	
	private String paymentOrgCode;
	//是否字母键(YN)	
	private String isPicPackage;
	//原始订单号	
	private String originalNumber;
	//采购单号	
	private String labelLevelMonth;
	//服务类型	
	private String serviceType;
	//备注	
	private String remark;
	//原始订单地址（原始收货人地址）	
//	private String consigneeCompanyAddress;
	//其他费用	
	private BigDecimal otherFee;
	//客户订单号	
	private String custOrderLine;
	//退款方式
	private String refundMode;
	
	//20160509  320446  崔永振    裹裹抢单新增字段
	//裹裹抢单时间
	private Date grabOrderTime;
	
	//上门时效:120：2小时上门,30：30分钟上门
	private String gotInTime;
	
	//快递员ID
	private String pickupManId;
	
	//筛单用
	private boolean ifSieveOrder;
	//门店编号
	private String storeCode;
	//子母件类型(0是母件,1是子件)
	private String picPackageType;
	//总费用
	private BigDecimal totalFee;
	//裹裹订单类型
	private String messageType;
	
	/* OMS20160906    菜鸟仓配    崔永振  */
	//菜鸟仓配
	private String cnWd;
	//菜鸟增值服务标识
	private String serviceFlag;
	//菜鸟增值服务类型
	private String scheduleType;
	//用来判断客户编码和运输方式（菜鸟仓配）
	private String cpCode;
	//是否异地调货 0为否，1为是
	private String isOffSiteTransfer;
	//是否优先接货 0为否，1为是
	private String isThePriority;
	
	public String getIsOffSiteTransfer() {
		return isOffSiteTransfer;
	}

	public void setIsOffSiteTransfer(String isOffSiteTransfer) {
		this.isOffSiteTransfer = isOffSiteTransfer;
	}

	public String getIsThePriority() {
		return isThePriority;
	}

	public void setIsThePriority(String isThePriority) {
		this.isThePriority = isThePriority;
	}
	
	
	/**
	 * @return the hastenCount
	 */
	public int getHastenCount() {
		return hastenCount;
	}
	/**
	 * @param hastenCount the hastenCount to set
	 */
	public void setHastenCount(int hastenCount) {
		this.hastenCount = hastenCount;
	}
	/**
	 * @return the lastHastenTime
	 */
	public Date getLastHastenTime() {
		return lastHastenTime;
	}
	/**
	 * @param lastHastenTime the lastHastenTime to set
	 */
	public void setLastHastenTime(Date lastHastenTime) {
		this.lastHastenTime = lastHastenTime;
	}
	/**
	 * @return the contactManId
	 */
	public String getContactManId() {
		return contactManId;
	}
	/**
	 * @param contactManId the contactManId to set
	 */
	public void setContactManId(String contactManId) {
		this.contactManId = contactManId;
	}
	/**
	 * @return the orderNumber
	 */
	public String getOrderNumber() {
		return orderNumber;
	}
	/**
	 * @param orderNumber the orderNumber to set
	 */
	public void setOrderNumber(String orderNumber) {
		this.orderNumber = orderNumber;
	}
	/**
	 * @return the channelNumber
	 */
	public String getChannelNumber() {
		return channelNumber;
	}
	/**
	 * @param channelNumber the channelNumber to set
	 */
	public void setChannelNumber(String channelNumber) {
		this.channelNumber = channelNumber;
	}
	/**
	 * @return the shipperId
	 */
	public String getShipperId() {
		return shipperId;
	}
	/**
	 * @param shipperId the shipperId to set
	 */
	public void setShipperId(String shipperId) {
		this.shipperId = shipperId;
	}
	/**
	 * @return the shipperNumber
	 */
	public String getShipperNumber() {
		return shipperNumber;
	}
	/**
	 * @param shipperNumber the shipperNumber to set
	 */
	public void setShipperNumber(String shipperNumber) {
		this.shipperNumber = shipperNumber;
	}
	/**
	 * @return the shipperName
	 */
	public String getShipperName() {
		return shipperName;
	}
	/**
	 * @param shipperName the shipperName to set
	 */
	public void setShipperName(String shipperName) {
		this.shipperName = shipperName;
	}
	/**
	 * @return the contactName
	 */
	public String getContactName() {
		return contactName;
	}
	/**
	 * @param contactName the contactName to set
	 */
	public void setContactName(String contactName) {
		this.contactName = contactName;
	}
	/**
	 * @return the contactMobile
	 */
	public String getContactMobile() {
		return contactMobile;
	}
	/**
	 * @param contactMobile the contactMobile to set
	 */
	public void setContactMobile(String contactMobile) {
		this.contactMobile = contactMobile;
	}
	/**
	 * @return the contactPhone
	 */
	public String getContactPhone() {
		return contactPhone;
	}
	/**
	 * @param contactPhone the contactPhone to set
	 */
	public void setContactPhone(String contactPhone) {
		this.contactPhone = contactPhone;
	}
	/**
	 * @return the contactProvince
	 */
	public String getContactProvince() {
		return contactProvince;
	}
	/**
	 * @param contactProvince the contactProvince to set
	 */
	public void setContactProvince(String contactProvince) {
		this.contactProvince = contactProvince;
	}
	/**
	 * @return the contactCity
	 */
	public String getContactCity() {
		return contactCity;
	}
	/**
	 * @param contactCity the contactCity to set
	 */
	public void setContactCity(String contactCity) {
		this.contactCity = contactCity;
	}
	/**
	 * @return the contactArea
	 */
	public String getContactArea() {
		return contactArea;
	}
	/**
	 * @param contactArea the contactArea to set
	 */
	public void setContactArea(String contactArea) {
		this.contactArea = contactArea;
	}
	/**
	 * @return the contactAddress
	 */
	public String getContactAddress() {
		return contactAddress;
	}
	/**
	 * @param contactAddress the contactAddress to set
	 */
	public void setContactAddress(String contactAddress) {
		this.contactAddress = contactAddress;
	}
	/**
	 * @return the consignorComments
	 */
	public String getConsignorComments() {
		return consignorComments;
	}
	/**
	 * @param consignorComments the consignorComments to set
	 */
	public void setConsignorComments(String consignorComments) {
		this.consignorComments = consignorComments;
	}
	/**
	 * @return the isReceiveGoods
	 */
	public String getIsReceiveGoods() {
		return isReceiveGoods;
	}
	/**
	 * @param isReceiveGoods the isReceiveGoods to set
	 */
	public void setIsReceiveGoods(String isReceiveGoods) {
		this.isReceiveGoods = isReceiveGoods;
	}
	/**
	 * @return the beginAcceptTime
	 */
	public Date getBeginAcceptTime() {
		return beginAcceptTime;
	}
	/**
	 * @param beginAcceptTime the beginAcceptTime to set
	 */
	public void setBeginAcceptTime(Date beginAcceptTime) {
		this.beginAcceptTime = beginAcceptTime;
	}
	/**
	 * @return the endAcceptTime
	 */
	public Date getEndAcceptTime() {
		return endAcceptTime;
	}
	/**
	 * @param endAcceptTime the endAcceptTime to set
	 */
	public void setEndAcceptTime(Date endAcceptTime) {
		this.endAcceptTime = endAcceptTime;
	}
	/**
	 * @return the receiverCustId
	 */
	public String getReceiverCustId() {
		return receiverCustId;
	}
	/**
	 * @param receiverCustId the receiverCustId to set
	 */
	public void setReceiverCustId(String receiverCustId) {
		this.receiverCustId = receiverCustId;
	}
	/**
	 * @return the receiverCustNumber
	 */
	public String getReceiverCustNumber() {
		return receiverCustNumber;
	}
	/**
	 * @param receiverCustNumber the receiverCustNumber to set
	 */
	public void setReceiverCustNumber(String receiverCustNumber) {
		this.receiverCustNumber = receiverCustNumber;
	}
	/**
	 * @return the receiverCustcompany
	 */
	public String getReceiverCustcompany() {
		return receiverCustcompany;
	}
	/**
	 * @param receiverCustcompany the receiverCustcompany to set
	 */
	public void setReceiverCustcompany(String receiverCustcompany) {
		this.receiverCustcompany = receiverCustcompany;
	}
	/**
	 * @return the receiverCustName
	 */
	public String getReceiverCustName() {
		return receiverCustName;
	}
	/**
	 * @param receiverCustName the receiverCustName to set
	 */
	public void setReceiverCustName(String receiverCustName) {
		this.receiverCustName = receiverCustName;
	}
	/**
	 * @return the receiveMobile
	 */
	public String getReceiveMobile() {
		return receiveMobile;
	}
	/**
	 * @param receiveMobile the receiveMobile to set
	 */
	public void setReceiveMobile(String receiveMobile) {
		this.receiveMobile = receiveMobile;
	}
	/**
	 * @return the receivePhone
	 */
	public String getReceivePhone() {
		return receivePhone;
	}
	/**
	 * @param receivePhone the receivePhone to set
	 */
	public void setReceivePhone(String receivePhone) {
		this.receivePhone = receivePhone;
	}
	/**
	 * @return the receiveProvince
	 */
	public String getReceiveProvince() {
		return receiveProvince;
	}
	/**
	 * @param receiveProvince the receiveProvince to set
	 */
	public void setReceiveProvince(String receiveProvince) {
		this.receiveProvince = receiveProvince;
	}
	/**
	 * @return the receiveCity
	 */
	public String getReceiveCity() {
		return receiveCity;
	}
	/**
	 * @param receiveCity the receiveCity to set
	 */
	public void setReceiveCity(String receiveCity) {
		this.receiveCity = receiveCity;
	}
	/**
	 * @return the receiveArea
	 */
	public String getReceiveArea() {
		return receiveArea;
	}
	/**
	 * @param receiveArea the receiveArea to set
	 */
	public void setReceiveArea(String receiveArea) {
		this.receiveArea = receiveArea;
	}
	/**
	 * @return the receiveTown
	 */
	public String getReceiveTown() {
		return receiveTown;
	}
	/**
	 * @param receiveTown the receiveTown to set
	 */
	public void setReceiveTown(String receiveTown) {
		this.receiveTown = receiveTown;
	}
	/**
	 * @return the receiveAddress
	 */
	public String getReceiveAddress() {
		return receiveAddress;
	}
	/**
	 * @param receiveAddress the receiveAddress to set
	 */
	public void setReceiveAddress(String receiveAddress) {
		this.receiveAddress = receiveAddress;
	}
	/**
	 * @return the receivingComments
	 */
	public String getReceivingComments() {
		return receivingComments;
	}
	/**
	 * @param receivingComments the receivingComments to set
	 */
	public void setReceivingComments(String receivingComments) {
		this.receivingComments = receivingComments;
	}
	/**
	 * @return the isSendmessage
	 */
	public String getIsSendmessage() {
		return isSendmessage;
	}
	/**
	 * @param isSendmessage the isSendmessage to set
	 */
	public void setIsSendmessage(String isSendmessage) {
		this.isSendmessage = isSendmessage;
	}
	/**
	 * @return the receivingToPoint
	 */
	public String getReceivingToPoint() {
		return receivingToPoint;
	}
	/**
	 * @param receivingToPoint the receivingToPoint to set
	 */
	public void setReceivingToPoint(String receivingToPoint) {
		this.receivingToPoint = receivingToPoint;
	}
	/**
	 * @return the receivingToPointName
	 */
	public String getReceivingToPointName() {
		return receivingToPointName;
	}
	/**
	 * @param receivingToPointName the receivingToPointName to set
	 */
	public void setReceivingToPointName(String receivingToPointName) {
		this.receivingToPointName = receivingToPointName;
	}
	/**
	 * @return the transportMode
	 */
	public String getTransportMode() {
		return transportMode;
	}
	/**
	 * @param transportMode the transportMode to set
	 */
	public void setTransportMode(String transportMode) {
		this.transportMode = transportMode;
	}
	/**
	 * @return the goodsName
	 */
	public String getGoodsName() {
		return goodsName;
	}
	/**
	 * @param goodsName the goodsName to set
	 */
	public void setGoodsName(String goodsName) {
		this.goodsName = goodsName;
	}
	/**
	 * @return the packing
	 */
	public String getPacking() {
		return packing;
	}
	/**
	 * @param packing the packing to set
	 */
	public void setPacking(String packing) {
		this.packing = packing;
	}
//	/**
//	 * @return the goodsType
//	 */
//	public String getGoodsType() {
//		return goodsType;
//	}
//	/**
//	 * @param goodsType the goodsType to set
//	 */
//	public void setGoodsType(String goodsType) {
//		this.goodsType = goodsType;
//	}
	/**
	 * @return the goodsNumber
	 */
	public Integer getGoodsNumber() {
		return goodsNumber;
	}
	/**
	 * @param goodsNumber the goodsNumber to set
	 */
	public void setGoodsNumber(Integer goodsNumber) {
		this.goodsNumber = goodsNumber;
	}
	/**
	 * @return the totalWeight
	 */
	public Double getTotalWeight() {
		return totalWeight;
	}
	/**
	 * @param totalWeight the totalWeight to set
	 */
	public void setTotalWeight(Double totalWeight) {
		this.totalWeight = totalWeight;
	}
	/**
	 * @return the totalVolume
	 */
	public Double getTotalVolume() {
		return totalVolume;
	}
	/**
	 * @param totalVolume the totalVolume to set
	 */
	public void setTotalVolume(Double totalVolume) {
		this.totalVolume = totalVolume;
	}
	/**
	 * @return the paymentType
	 */
	public String getPaymentType() {
		return paymentType;
	}
	/**
	 * @param paymentType the paymentType to set
	 */
	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}
	/**
	 * @return the channelType
	 */
	public String getChannelType() {
		return channelType;
	}
	/**
	 * @param channelType the channelType to set
	 */
	public void setChannelType(String channelType) {
		this.channelType = channelType;
	}
	/**
	 * @return the channelCustId
	 */
	public String getChannelCustId() {
		return channelCustId;
	}
	/**
	 * @param channelCustId the channelCustId to set
	 */
	public void setChannelCustId(String channelCustId) {
		this.channelCustId = channelCustId;
	}
	/**
	 * @return the deliveryMode
	 */
	public String getDeliveryMode() {
		return deliveryMode;
	}
	/**
	 * @param deliveryMode the deliveryMode to set
	 */
	public void setDeliveryMode(String deliveryMode) {
		this.deliveryMode = deliveryMode;
	}
	/**
	 * @return the reciveLoanType
	 */
	public String getReciveLoanType() {
		return reciveLoanType;
	}
	/**
	 * @param reciveLoanType the reciveLoanType to set
	 */
	public void setReciveLoanType(String reciveLoanType) {
		this.reciveLoanType = reciveLoanType;
	}
	/**
	 * @return the reviceMoneyAmount
	 */
	public Double getReviceMoneyAmount() {
		return reviceMoneyAmount;
	}
	/**
	 * @param reviceMoneyAmount the reviceMoneyAmount to set
	 */
	public void setReviceMoneyAmount(Double reviceMoneyAmount) {
		this.reviceMoneyAmount = reviceMoneyAmount;
	}
	/**
	 * @return the insuredAmount
	 */
	public Double getInsuredAmount() {
		return insuredAmount;
	}
	/**
	 * @param insuredAmount the insuredAmount to set
	 */
	public void setInsuredAmount(Double insuredAmount) {
		this.insuredAmount = insuredAmount;
	}
	/**
	 * @return the orderTime
	 */
	public Date getOrderTime() {
		return orderTime;
	}
	/**
	 * @param orderTime the orderTime to set
	 */
	public void setOrderTime(Date orderTime) {
		this.orderTime = orderTime;
	}
	/**
	 * @return the startStation
	 */
	public String getStartStation() {
		return startStation;
	}
	/**
	 * @param startStation the startStation to set
	 */
	public void setStartStation(String startStation) {
		this.startStation = startStation;
	}
	/**
	 * @return the startStationName
	 */
	public String getStartStationName() {
		return startStationName;
	}
	/**
	 * @param startStationName the startStationName to set
	 */
	public void setStartStationName(String startStationName) {
		this.startStationName = startStationName;
	}
	/**
	 * @return the acceptDept
	 */
	public String getAcceptDept() {
		return acceptDept;
	}
	/**
	 * @param acceptDept the acceptDept to set
	 */
	public void setAcceptDept(String acceptDept) {
		this.acceptDept = acceptDept;
	}
	/**
	 * @return the acceptDeptName
	 */
	public String getAcceptDeptName() {
		return acceptDeptName;
	}
	/**
	 * @param acceptDeptName the acceptDeptName to set
	 */
	public void setAcceptDeptName(String acceptDeptName) {
		this.acceptDeptName = acceptDeptName;
	}
	/**
	 * @return the orderStatus
	 */
	public String getOrderStatus() {
		return orderStatus;
	}
	/**
	 * @param orderStatus the orderStatus to set
	 */
	public void setOrderStatus(String orderStatus) {
		this.orderStatus = orderStatus;
	}
	/**
	 * @return the dealPerson
	 */
	public String getDealPerson() {
		return dealPerson;
	}
	/**
	 * @param dealPerson the dealPerson to set
	 */
	public void setDealPerson(String dealPerson) {
		this.dealPerson = dealPerson;
	}
//	/**
//	 * @return the orderAcceptTime
//	 */
//	public Date getOrderAcceptTime() {
//		return orderAcceptTime;
//	}
//	/**
//	 * @param orderAcceptTime the orderAcceptTime to set
//	 */
//	public void setOrderAcceptTime(Date orderAcceptTime) {
//		this.orderAcceptTime = orderAcceptTime;
//	}
//	/**
//	 * @return the receiver
//	 */
//	public String getReceiver() {
//		return receiver;
//	}
//	/**
//	 * @param receiver the receiver to set
//	 */
//	public void setReceiver(String receiver) {
//		this.receiver = receiver;
//	}
//	/**
//	 * @return the accepterPersonMobile
//	 */
//	public String getAccepterPersonMobile() {
//		return accepterPersonMobile;
//	}
//	/**
//	 * @param accepterPersonMobile the accepterPersonMobile to set
//	 */
//	public void setAccepterPersonMobile(String accepterPersonMobile) {
//		this.accepterPersonMobile = accepterPersonMobile;
//	}
	/**
	 * @return the waybillNumber
	 */
	public String getWaybillNumber() {
		return waybillNumber;
	}
	/**
	 * @param waybillNumber the waybillNumber to set
	 */
	public void setWaybillNumber(String waybillNumber) {
		this.waybillNumber = waybillNumber;
	}
	/**
	 * @return the resource
	 */
	public String getResource() {
		return resource;
	}
	/**
	 * @param resource the resource to set
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}
	/**
	 * @return the transNote
	 */
	public String getTransNote() {
		return transNote;
	}
	/**
	 * @param transNote the transNote to set
	 */
	public void setTransNote(String transNote) {
		this.transNote = transNote;
	}
	/**
	 * @return the returnBillType
	 */
	public String getReturnBillType() {
		return returnBillType;
	}
	/**
	 * @param returnBillType the returnBillType to set
	 */
	public void setReturnBillType(String returnBillType) {
		this.returnBillType = returnBillType;
	}
	/**
	 * @return the orderPerson
	 */
	public String getOrderPerson() {
		return orderPerson;
	}
	/**
	 * @param orderPerson the orderPerson to set
	 */
	public void setOrderPerson(String orderPerson) {
		this.orderPerson = orderPerson;
	}
	/**
	 * @return the feedbackInfo
	 */
	public String getFeedbackInfo() {
		return feedbackInfo;
	}
	/**
	 * @param feedbackInfo the feedbackInfo to set
	 */
	public void setFeedbackInfo(String feedbackInfo) {
		this.feedbackInfo = feedbackInfo;
	}
	/**
	 * @return the onlineName
	 */
	public String getOnlineName() {
		return onlineName;
	}
	/**
	 * @param onlineName the onlineName to set
	 */
	public void setOnlineName(String onlineName) {
		this.onlineName = onlineName;
	}
//	/**
//	 * @return the memberType
//	 */
//	public String getMemberType() {
//		return memberType;
//	}
//	/**
//	 * @param memberType the memberType to set
//	 */
//	public void setMemberType(String memberType) {
//		this.memberType = memberType;
//	}
//	/**
//	 * @return the toWaitAcceptTime
//	 */
//	public Date getToWaitAcceptTime() {
//		return toWaitAcceptTime;
//	}
//	/**
//	 * @param toWaitAcceptTime the toWaitAcceptTime to set
//	 */
//	public void setToWaitAcceptTime(Date toWaitAcceptTime) {
//		this.toWaitAcceptTime = toWaitAcceptTime;
//	}
	/**
	 * @return the couponNumber
	 */
	public String getCouponNumber() {
		return couponNumber;
	}
	/**
	 * @param couponNumber the couponNumber to set
	 */
	public void setCouponNumber(String couponNumber) {
		this.couponNumber = couponNumber;
	}
	/**
	 * @return the delayTime
	 */
	public Date getDelayTime() {
		return delayTime;
	}
	/**
	 * @param delayTime the delayTime to set
	 */
	public void setDelayTime(Date delayTime) {
		this.delayTime = delayTime;
	}
	/**
	 * @return the createUserNum
	 */
	public String getCreateUserNum() {
		return createUserNum;
	}
	/**
	 * @param createUserNum the createUserNum to set
	 */
	public void setCreateUserNum(String createUserNum) {
		this.createUserNum = createUserNum;
	}
	/**
	 * @return the createUserDeptNum
	 */
	public String getCreateUserDeptNum() {
		return createUserDeptNum;
	}
	/**
	 * @param createUserDeptNum the createUserDeptNum to set
	 */
	public void setCreateUserDeptNum(String createUserDeptNum) {
		this.createUserDeptNum = createUserDeptNum;
	}
	/**
	 * @return the departLinkManNumber
	 */
	public String getDepartLinkManNumber() {
		return departLinkManNumber;
	}
	/**
	 * @param departLinkManNumber the departLinkManNumber to set
	 */
	public void setDepartLinkManNumber(String departLinkManNumber) {
		this.departLinkManNumber = departLinkManNumber;
	}
//	/**
//	 * @return the arriveLinkManNumber
//	 */
//	public String getArriveLinkManNumber() {
//		return arriveLinkManNumber;
//	}
//	/**
//	 * @param arriveLinkManNumber the arriveLinkManNumber to set
//	 */
//	public void setArriveLinkManNumber(String arriveLinkManNumber) {
//		this.arriveLinkManNumber = arriveLinkManNumber;
//	}
	/**
	 * @return the orderType
	 */
	public String getOrderType() {
		return orderType;
	}
	/**
	 * @param orderType the orderType to set
	 */
	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}
	/**
	 * @return the ifElecBillBigCust
	 */
	public String getIfElecBillBigCust() {
		return ifElecBillBigCust;
	}
	/**
	 * @param ifElecBillBigCust the ifElecBillBigCust to set
	 */
	public void setIfElecBillBigCust(String ifElecBillBigCust) {
		this.ifElecBillBigCust = ifElecBillBigCust;
	}
	/**
	 * @return the reciveLoanAccount
	 */
	public String getReciveLoanAccount() {
		return reciveLoanAccount;
	}
	/**
	 * @param reciveLoanAccount the reciveLoanAccount to set
	 */
	public void setReciveLoanAccount(String reciveLoanAccount) {
		this.reciveLoanAccount = reciveLoanAccount;
	}
	/**
	 * @return the accountName
	 */
	public String getAccountName() {
		return accountName;
	}
	/**
	 * @param accountName the accountName to set
	 */
	public void setAccountName(String accountName) {
		this.accountName = accountName;
	}
	/**
	 * @return the offlineWaybillNum
	 */
	public String getOfflineWaybillNum() {
		return offlineWaybillNum;
	}
	/**
	 * @param offlineWaybillNum the offlineWaybillNum to set
	 */
	public void setOfflineWaybillNum(String offlineWaybillNum) {
		this.offlineWaybillNum = offlineWaybillNum;
	}
	/**
	 * @return the ifEInvoice
	 */
	public String getIfEInvoice() {
		return ifEInvoice;
	}
	/**
	 * @param ifEInvoice the ifEInvoice to set
	 */
	public void setIfEInvoice(String ifEInvoice) {
		this.ifEInvoice = ifEInvoice;
	}
	/**
	 * @return the invoicePhone
	 */
	public String getInvoicePhone() {
		return invoicePhone;
	}
	/**
	 * @param invoicePhone the invoicePhone to set
	 */
	public void setInvoicePhone(String invoicePhone) {
		this.invoicePhone = invoicePhone;
	}
	/**
	 * @return the invoiceMail
	 */
	public String getInvoiceMail() {
		return invoiceMail;
	}
	/**
	 * @param invoiceMail the invoiceMail to set
	 */
	public void setInvoiceMail(String invoiceMail) {
		this.invoiceMail = invoiceMail;
	}
	/**
	 * @return the teanLimit
	 */
	public Double getTeanLimit() {
		return teanLimit;
	}
	/**
	 * @param teanLimit the teanLimit to set
	 */
	public void setTeanLimit(Double teanLimit) {
		this.teanLimit = teanLimit;
	}
	/**
	 * @return the receiveProvinceCode
	 */
	public String getReceiveProvinceCode() {
		return receiveProvinceCode;
	}
	/**
	 * @param receiveProvinceCode the receiveProvinceCode to set
	 */
	public void setReceiveProvinceCode(String receiveProvinceCode) {
		this.receiveProvinceCode = receiveProvinceCode;
	}
	/**
	 * @return the receiveCityCode
	 */
	public String getReceiveCityCode() {
		return receiveCityCode;
	}
	/**
	 * @param receiveCityCode the receiveCityCode to set
	 */
	public void setReceiveCityCode(String receiveCityCode) {
		this.receiveCityCode = receiveCityCode;
	}
	/**
	 * @return the receiveAreaCode
	 */
	public String getReceiveAreaCode() {
		return receiveAreaCode;
	}
	/**
	 * @param receiveAreaCode the receiveAreaCode to set
	 */
	public void setReceiveAreaCode(String receiveAreaCode) {
		this.receiveAreaCode = receiveAreaCode;
	}
	/**
	 * @return the receiveTownCode
	 */
	public String getReceiveTownCode() {
		return receiveTownCode;
	}
	/**
	 * @param receiveTownCode the receiveTownCode to set
	 */
	public void setReceiveTownCode(String receiveTownCode) {
		this.receiveTownCode = receiveTownCode;
	}
	/**
	 * @return the contactProvinceCode
	 */
	public String getContactProvinceCode() {
		return contactProvinceCode;
	}
	/**
	 * @param contactProvinceCode the contactProvinceCode to set
	 */
	public void setContactProvinceCode(String contactProvinceCode) {
		this.contactProvinceCode = contactProvinceCode;
	}
	/**
	 * @return the contactCityCode
	 */
	public String getContactCityCode() {
		return contactCityCode;
	}
	/**
	 * @param contactCityCode the contactCityCode to set
	 */
	public void setContactCityCode(String contactCityCode) {
		this.contactCityCode = contactCityCode;
	}
	/**
	 * @return the originalsaddress
	 */
	public String getOriginalsaddress() {
		return originalsaddress;
	}
	/**
	 * @param originalsaddress the originalsaddress to set
	 */
	public void setOriginalsaddress(String originalsaddress) {
		this.originalsaddress = originalsaddress;
	}
	/**
	 * @return the originalraddress
	 */
	public String getOriginalraddress() {
		return originalraddress;
	}
	/**
	 * @param originalraddress the originalraddress to set
	 */
	public void setOriginalraddress(String originalraddress) {
		this.originalraddress = originalraddress;
	}
	/**
	 * @return the originalsStreet
	 */
	public String getOriginalsStreet() {
		return originalsStreet;
	}
	/**
	 * @param originalsStreet the originalsStreet to set
	 */
	public void setOriginalsStreet(String originalsStreet) {
		this.originalsStreet = originalsStreet;
	}
	/**
	 * @return the originalrStreet
	 */
	public String getOriginalrStreet() {
		return originalrStreet;
	}
	/**
	 * @param originalrStreet the originalrStreet to set
	 */
	public void setOriginalrStreet(String originalrStreet) {
		this.originalrStreet = originalrStreet;
	}
//	/**
//	 * @return the recommend
//	 */
//	public String getRecommend() {
//		return recommend;
//	}
//	/**
//	 * @param recommend the recommend to set
//	 */
//	public void setRecommend(String recommend) {
//		this.recommend = recommend;
//	}
	/**
	 * @return the freight
	 */
	public Double getFreight() {
		return freight;
	}
	/**
	 * @param freight the freight to set
	 */
	public void setFreight(Double freight) {
		this.freight = freight;
	}
//	/**
//	 * @return the procurementNumber
//	 */
//	public String getProcurementNumber() {
//		return procurementNumber;
//	}
//	/**
//	 * @param procurementNumber the procurementNumber to set
//	 */
//	public void setProcurementNumber(String procurementNumber) {
//		this.procurementNumber = procurementNumber;
//	}
	/**
	 * @return the ifTaoBao
	 */
	public String getIfTaoBao() {
		return ifTaoBao;
	}
	/**
	 * @param ifTaoBao the ifTaoBao to set
	 */
	public void setIfTaoBao(String ifTaoBao) {
		this.ifTaoBao = ifTaoBao;
	}
	/**
	 * @return the markerPen
	 */
	public String getMarkerPen() {
		return markerPen;
	}
	/**
	 * @param markerPen the markerPen to set
	 */
	public void setMarkerPen(String markerPen) {
		this.markerPen = markerPen;
	}
	/**
	 * @return the routInfo
	 */
	public String getRoutInfo() {
		return routInfo;
	}
	/**
	 * @param routInfo the routInfo to set
	 */
	public void setRoutInfo(String routInfo) {
		this.routInfo = routInfo;
	}
	/**
	 * @return the versionId
	 */
	public Double getVersionId() {
		return versionId;
	}
	/**
	 * @param versionId the versionId to set
	 */
	public void setVersionId(Double versionId) {
		this.versionId = versionId;
	}
	/**
	 * @return the modifyType
	 */
	public String getModifyType() {
		return modifyType;
	}
	/**
	 * @param modifyType the modifyType to set
	 */
	public void setModifyType(String modifyType) {
		this.modifyType = modifyType;
	}
	/**
	 * @return the senderCode
	 */
	public String getSenderCode() {
		return senderCode;
	}
	/**
	 * @param senderCode the senderCode to set
	 */
	public void setSenderCode(String senderCode) {
		this.senderCode = senderCode;
	}
	/**
	 * @return the paymentOrgCode
	 */
	public String getPaymentOrgCode() {
		return paymentOrgCode;
	}
	/**
	 * @param paymentOrgCode the paymentOrgCode to set
	 */
	public void setPaymentOrgCode(String paymentOrgCode) {
		this.paymentOrgCode = paymentOrgCode;
	}
	/**
	 * @return the isPicPackage
	 */
	public String getIsPicPackage() {
		return isPicPackage;
	}
	/**
	 * @param isPicPackage the isPicPackage to set
	 */
	public void setIsPicPackage(String isPicPackage) {
		this.isPicPackage = isPicPackage;
	}
	/**
	 * @return the originalNumber
	 */
	public String getOriginalNumber() {
		return originalNumber;
	}
	/**
	 * @param originalNumber the originalNumber to set
	 */
	public void setOriginalNumber(String originalNumber) {
		this.originalNumber = originalNumber;
	}
	/**
	 * @return the labelLevelMonth
	 */
	public String getLabelLevelMonth() {
		return labelLevelMonth;
	}
	/**
	 * @param labelLevelMonth the labelLevelMonth to set
	 */
	public void setLabelLevelMonth(String labelLevelMonth) {
		this.labelLevelMonth = labelLevelMonth;
	}
	/**
	 * @return the serviceType
	 */
	public String getServiceType() {
		return serviceType;
	}
	/**
	 * @param serviceType the serviceType to set
	 */
	public void setServiceType(String serviceType) {
		this.serviceType = serviceType;
	}
	/**
	 * @return the remark
	 */
	public String getRemark() {
		return remark;
	}
	/**
	 * @param remark the remark to set
	 */
	public void setRemark(String remark) {
		this.remark = remark;
	}
//	/**
//	 * @return the consigneeCompanyAddress
//	 */
//	public String getConsigneeCompanyAddress() {
//		return consigneeCompanyAddress;
//	}
//	/**
//	 * @param consigneeCompanyAddress the consigneeCompanyAddress to set
//	 */
//	public void setConsigneeCompanyAddress(String consigneeCompanyAddress) {
//		this.consigneeCompanyAddress = consigneeCompanyAddress;
//	}
	/**
	 * @return the otherFee
	 */
	public BigDecimal getOtherFee() {
		return otherFee;
	}
	/**
	 * @param otherFee the otherFee to set
	 */
	public void setOtherFee(BigDecimal otherFee) {
		this.otherFee = otherFee;
	}
	/**
	 * @return the custOrderLine
	 */
	public String getCustOrderLine() {
		return custOrderLine;
	}
	/**
	 * @param custOrderLine the custOrderLine to set
	 */
	public void setCustOrderLine(String custOrderLine) {
		this.custOrderLine = custOrderLine;
	}
	public int getCNStatus() {
		return CNStatus;
	}
	public void setCNStatus(int cNStatus) {
		CNStatus = cNStatus;
	}
	public int getCNMsgVersion() {
		return CNMsgVersion;
	}
	public void setCNMsgVersion(int cNMsgVersion) {
		CNMsgVersion = cNMsgVersion;
	}
	public String getContactAreaCode() {
		return contactAreaCode;
	}
	public void setContactAreaCode(String contactAreaCode) {
		this.contactAreaCode = contactAreaCode;
	}
	public String getContactTownCode() {
		return contactTownCode;
	}
	public void setContactTownCode(String contactTownCode) {
		this.contactTownCode = contactTownCode;
	}
	public String getContactTown() {
		return contactTown;
	}
	public void setContactTown(String contactTown) {
		this.contactTown = contactTown;
	}
	public String getRefundMode() {
		return refundMode;
	}
	public void setRefundMode(String refundMode) {
		this.refundMode = refundMode;
	}
	/**
	 * @return the provideId
	 */
	public String getProvideId() {
		return provideId;
	}
	/**
	 * @param provideId the provideId to set
	 */
	public void setProvideId(String provideId) {
		this.provideId = provideId;
	}
	
	/**
	 * @return  the grabOrderTime
	 */
	public Date getGrabOrderTime() {
		return grabOrderTime;
	}
	/**
	 * @param grabOrderTime the grabOrderTime to set
	 */
	public void setGrabOrderTime(Date grabOrderTime) {
		this.grabOrderTime = grabOrderTime;
	}
	/**
	 * @return the gotInTime
	 */
	public String getGotInTime() {
		return gotInTime;
	}
	/**
	 * @param gotInTime the gotInTime to set
	 */
	public void setGotInTime(String gotInTime) {
		this.gotInTime = gotInTime;
	}
	/**
	 * @return the pickupManId
	 */
	public String getPickupManId() {
		return pickupManId;
	}
	/**
	 * @param pickupManId the pickupManId to set
	 */
	public void setPickupManId(String pickupManId) {
		this.pickupManId = pickupManId;
	}
	/**
	 * @return the ifSieveOrder
	 */
	public boolean isIfSieveOrder() {
		return ifSieveOrder;
	}
	/**
	 * @param ifSieveOrder the ifSieveOrder to set
	 */
	public void setIfSieveOrder(boolean ifSieveOrder) {
		this.ifSieveOrder = ifSieveOrder;
	}
	/**
	 * @return the storeCode
	 */
	public String getStoreCode() {
		return storeCode;
	}
	/**
	 * @param storeCode the storeCode to set
	 */
	public void setStoreCode(String storeCode) {
		this.storeCode = storeCode;
	}
	/**
	 * @return the picPackageType
	 */
	public String getPicPackageType() {
		return picPackageType;
	}
	/**
	 * @param picPackageType the picPackageType to set
	 */
	public void setPicPackageType(String picPackageType) {
		this.picPackageType = picPackageType;
	}
	public BigDecimal getTotalFee() {
		return totalFee;
	}
	public void setTotalFee(BigDecimal totalFee) {
		this.totalFee = totalFee;
	}
	
	public String getMessageType() {
		return messageType;
	}
	public void setMessageType(String messageType) {
		this.messageType = messageType;
	}
	public ExpOrderDTO(String channelNumber,String orderStatus) {
		this.channelNumber = channelNumber;
		this.orderStatus=orderStatus;
	}
	public ExpOrderDTO() {
	}
	/**
	 * @return the cnWd
	 */
	public String getCnWd() {
		return cnWd;
	}
	/**
	 * @param cnWd the cnWd to set
	 */
	public void setCnWd(String cnWd) {
		this.cnWd = cnWd;
	}
	/**
	 * @return the serviceFlag
	 */
	public String getServiceFlag() {
		return serviceFlag;
	}
	/**
	 * @param serviceFlag the serviceFlag to set
	 */
	public void setServiceFlag(String serviceFlag) {
		this.serviceFlag = serviceFlag;
	}
	/**
	 * @return the scheduleType
	 */
	public String getScheduleType() {
		return scheduleType;
	}
	/**
	 * @param scheduleType the scheduleType to set
	 */
	public void setScheduleType(String scheduleType) {
		this.scheduleType = scheduleType;
	}
	/**
	 * @return the cpCode
	 */
	public String getCpCode() {
		return cpCode;
	}
	/**
	 * @param cpCode the cpCode to set
	 */
	public void setCpCode(String cpCode) {
		this.cpCode = cpCode;
	}
	
		/**
	 * 寄件人地址纬度
	 * @return the sender_latitude
	 */
	public String getSenderLatitude() {
		return senderLatitude;
	}
	/**
	 * @param sender_latitude 寄件人地址纬度
	 * the sender_latitude to set
	 */
	public void setSenderLatitude(String senderLatitude) {
		this.senderLatitude = senderLatitude;
	}
	/**
	 * 寄件人地址经度
	 * @return the sender_longitude
	 */
	public String getSenderLongitude() {
		return senderLongitude;
	}
	/**
	 * @param sender_longitude 寄件人地址经度
	 * the sender_longitude to set
	 */
	public void setSenderLongitude(String senderLongitude) {
		this.senderLongitude = senderLongitude;
	}

}
