/**
 * 
 */
package com.ptteng.sca.xqlease.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.Stock;
import com.ptteng.xqlease.common.service.StockService;

import java.util.List;
import java.util.Map;

public class StockSCAClient implements StockService {

    private StockService stockService;

	public StockService getStockService() {
		return stockService;
	}
	
	
	public void setStockService(StockService stockService) {
		this.stockService =stockService;
	}
	
	
			   
		@Override
		public Long insert(Stock stock)throws ServiceException, ServiceDaoException{
		
		return stockService.insert(stock);
		          
		
		}	
		  
    	   
		@Override
		public List<Stock> insertList(List<Stock> stockList)throws ServiceException, ServiceDaoException{
		
		return stockService.insertList(stockList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return stockService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Stock stock)throws ServiceException, ServiceDaoException{
		
		return stockService.update(stock);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Stock> stockList)throws ServiceException, ServiceDaoException{
		
		return stockService.updateList(stockList);
		          
		
		}	
		  
    	   
		@Override
		public Stock getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return stockService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Stock> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return stockService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockIdsByGoodsName(String goodsName,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockService.getStockIdsByGoodsName(goodsName,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockIdsBySku(String sku,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockService.getStockIdsBySku(sku,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStockIdsByOperateType(String operateType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return stockService.getStockIdsByOperateType(operateType,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockIdsByGoodsName(String goodsName)throws ServiceException, ServiceDaoException{
		
		return stockService.countStockIdsByGoodsName(goodsName);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockIdsBySku(String sku)throws ServiceException, ServiceDaoException{
		
		return stockService.countStockIdsBySku(sku);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStockIdsByOperateType(String operateType)throws ServiceException, ServiceDaoException{
		
		return stockService.countStockIdsByOperateType(operateType);
	
	
	}
	
		
	
		@Override
	public List<Long> getStockIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockService.getStockIds(start, limit);
	}

	@Override
	public Integer countStockIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockService.countStockIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return stockService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   stockService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.stockService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

