/**
 * 
 */
package com.ptteng.sca.xqlease.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.RentOrders;
import com.ptteng.xqlease.common.service.RentOrdersService;

import java.util.List;
import java.util.Map;

public class RentOrdersSCAClient implements RentOrdersService {

    private RentOrdersService rentOrdersService;

	public RentOrdersService getRentOrdersService() {
		return rentOrdersService;
	}
	
	
	public void setRentOrdersService(RentOrdersService rentOrdersService) {
		this.rentOrdersService =rentOrdersService;
	}
	
	
			   
		@Override
		public Long insert(RentOrders rentOrders)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.insert(rentOrders);
		          
		
		}	
		  
    	   
		@Override
		public List<RentOrders> insertList(List<RentOrders> rentOrdersList)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.insertList(rentOrdersList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(RentOrders rentOrders)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.update(rentOrders);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<RentOrders> rentOrdersList)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.updateList(rentOrdersList);
		          
		
		}	
		  
    	   
		@Override
		public RentOrders getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<RentOrders> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getRentOrdersIdByOrdersNumber(String ordersNumber)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.getRentOrdersIdByOrdersNumber(ordersNumber);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getRentOrdersIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.getRentOrdersIdsByUid(uid,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRentOrdersIdsByOrdersNumber(Long ordersNumber)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.countRentOrdersIdsByOrdersNumber(ordersNumber);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRentOrdersIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		return rentOrdersService.countRentOrdersIdsByUid(uid);
	
	
	}
	
		
	
		@Override
	public List<Long> getRentOrdersIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return rentOrdersService.getRentOrdersIds(start, limit);
	}

	@Override
	public Integer countRentOrdersIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return rentOrdersService.countRentOrdersIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return rentOrdersService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return rentOrdersService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   rentOrdersService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.rentOrdersService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Integer  countRentOrdersIdsByOrdersStatus(Integer ordersStatus)throws ServiceException, ServiceDaoException{

		return rentOrdersService.countRentOrdersIdsByOrdersStatus(ordersStatus);


	}

	@Override
	public Integer  countRentOrdersIdsByOrdersStatusAndPayMethod(Integer ordersStatus,Integer payMethod)throws ServiceException, ServiceDaoException{

		return rentOrdersService.countRentOrdersIdsByOrdersStatusAndPayMethod(ordersStatus,payMethod);


	}


    @Override
    public List<Long> getRentOrdersByParentOrdersNumberAndOrderStatus(String parentOrdersNumber, Integer ordersStatus,Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return rentOrdersService.getRentOrdersByParentOrdersNumberAndOrderStatus(parentOrdersNumber,ordersStatus,start,limit);
    }


	@Override
	public List<Long> getRentOrdersByParentNumber(String parentOrdersNumber, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		return rentOrdersService.getRentOrdersByParentNumber(parentOrdersNumber, start, limit);
	}

	@Override
	public Integer  countRentOrdersIdsByUidAndOrdersType(Long uid,Integer ordersType)throws ServiceException, ServiceDaoException{

		return rentOrdersService.countRentOrdersIdsByUidAndOrdersType(uid,ordersType);


	}

	@Override
	public Integer  countRentOrdersIdsByUidAndOrdersStatus(Long uid,Integer ordersStatus)throws ServiceException, ServiceDaoException{

		return rentOrdersService.countRentOrdersIdsByUidAndOrdersStatus(uid,ordersStatus);


	}
	@Override
	public Integer  countRentOrdersIdsByUidAndOrdersTypeAndOrdersStatus(Long uid,Integer ordersType,Integer ordersStatus)throws ServiceException, ServiceDaoException{

		return rentOrdersService.countRentOrdersIdsByUidAndOrdersTypeAndOrdersStatus(uid,ordersType,ordersStatus);


	}
}

